/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.finance.entity.ElsFinanceConfirmationConfig;
import com.els.modules.finance.enumerate.ConfigStatusEnum;
import com.els.modules.finance.mapper.ElsFinanceConfirmationConfigMapper;
import com.els.modules.finance.service.ElsFinanceConfirmationConfigService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class ElsFinanceConfirmationConfigServiceImpl
extends BaseServiceImpl<ElsFinanceConfirmationConfigMapper, ElsFinanceConfirmationConfig>
implements ElsFinanceConfirmationConfigService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void addBy100000(String id) {
        ElsFinanceConfirmationConfig confirmationConfig = (ElsFinanceConfirmationConfig)((Object)((ElsFinanceConfirmationConfigMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        ElsFinanceConfirmationConfig elsFinanceConfirmationConfig = new ElsFinanceConfirmationConfig();
        BeanUtils.copyProperties((Object)((Object)confirmationConfig), (Object)((Object)elsFinanceConfirmationConfig));
        elsFinanceConfirmationConfig.setElsAccount(TenantContext.getTenant());
        elsFinanceConfirmationConfig.setId(null);
        elsFinanceConfirmationConfig.setCreateBy(null);
        elsFinanceConfirmationConfig.setCreateTime(null);
        elsFinanceConfirmationConfig.setUpdateBy(null);
        elsFinanceConfirmationConfig.setUpdateTime(null);
        ((ElsFinanceConfirmationConfigMapper)this.baseMapper).insert((Object)elsFinanceConfirmationConfig);
    }

    @Override
    public void add(ElsFinanceConfirmationConfig elsFinanceConfirmationConfig) {
        String nextCode = this.invokeBaseRpcService.getNextCode("srmConfirmationConfigNumber", (Object)elsFinanceConfirmationConfig);
        elsFinanceConfirmationConfig.setRuleNumber(nextCode);
        elsFinanceConfirmationConfig.setStatus(ConfigStatusEnum.NORMAL.getValue());
        ((ElsFinanceConfirmationConfigMapper)this.baseMapper).insert((Object)elsFinanceConfirmationConfig);
    }

    @Override
    public void edit(ElsFinanceConfirmationConfig elsFinanceConfirmationConfig) {
        int count = ((ElsFinanceConfirmationConfigMapper)this.baseMapper).updateById((Object)elsFinanceConfirmationConfig);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((ElsFinanceConfirmationConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((ElsFinanceConfirmationConfigMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public ElsFinanceConfirmationConfig getDefaultFinanceConfirmationConfig(String currentELSAccount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)currentELSAccount);
        queryWrapper.eq(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
        queryWrapper.eq(ElsFinanceConfirmationConfig::getStatus, (Object)"1");
        ElsFinanceConfirmationConfig config = (ElsFinanceConfirmationConfig)((Object)((ElsFinanceConfirmationConfigMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        if (ObjectUtils.isEmpty((Object)((Object)config))) {
            LambdaQueryWrapper defaultQueryWrapper = new LambdaQueryWrapper();
            defaultQueryWrapper.eq(BaseEntity::getElsAccount, (Object)"100000");
            defaultQueryWrapper.eq(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
            defaultQueryWrapper.eq(ElsFinanceConfirmationConfig::getStatus, (Object)"1");
            ElsFinanceConfirmationConfig defaultConfig = (ElsFinanceConfirmationConfig)((Object)((ElsFinanceConfirmationConfigMapper)this.baseMapper).selectOne((Wrapper)defaultQueryWrapper));
            return defaultConfig;
        }
        return config;
    }
}

