/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.entity.ElsBarCodeParamConfig;
import com.els.modules.barcode.entity.ElsBarcodeRuleHead;
import com.els.modules.barcode.entity.ElsBarcodeRuleItem;
import com.els.modules.barcode.enumerate.BarcodeAttrEnum;
import com.els.modules.barcode.enumerate.ElsBarCodeParamConfigEnum;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.mapper.ElsBarCodeParamConfigMapper;
import com.els.modules.barcode.mapper.ElsBarCodeShortCodeMapper;
import com.els.modules.barcode.mapper.ElsBarcodeRuleHeadMapper;
import com.els.modules.barcode.mapper.ElsBarcodeRuleItemMapper;
import com.els.modules.barcode.service.ElsBarcodeRuleHeadService;
import com.els.modules.system.service.CodeGeneratorService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ElsBarcodeRuleHeadServiceImpl
extends BaseServiceImpl<ElsBarcodeRuleHeadMapper, ElsBarcodeRuleHead>
implements ElsBarcodeRuleHeadService {
    private String initData = "abcdefghijklmnopqrstuvwxyz";
    @Autowired
    private ElsBarcodeRuleHeadMapper elsBarcodeRuleHeadMapper;
    @Autowired
    private ElsBarcodeRuleItemMapper elsBarcodeRuleItemMapper;
    @Autowired
    private CodeGeneratorService codeGeneratorService;
    @Autowired
    private ElsBarCodeParamConfigMapper elsBarCodeParamConfigMapper;
    @Autowired
    private ElsBarCodeShortCodeMapper elsBarCodeShortCodeMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(ElsBarcodeRuleHead elsBarcodeRuleHead, List<ElsBarcodeRuleItem> elsBarcodeRuleItemList) {
        List<String> ruleCodeList = this.elsBarcodeRuleHeadMapper.listRuleCode(TenantContext.getTenant());
        if (ruleCodeList.size() >= 999) {
            Assert.msgThrow((String)I18nUtil.translate((String)"i18n_alert_ToLFERWRWWWTWVQGxjjToLFSKcI_af335f49", (String)"\u6761\u7801\u89c4\u5219\u914d\u7f6e\u9650\u5236999\u6761\uff0c\u8bf7\u5220\u9664\u4e0d\u7528\u7684\u6761\u7801\u89c4\u5219\u540e\u518d\u521b\u5efa"));
        }
        String ruleCode = "001";
        for (int i = 1; i <= 999; ++i) {
            if (ruleCodeList.contains(String.format("%03d", i))) continue;
            ruleCode = String.format("%03d", i);
            break;
        }
        elsBarcodeRuleHead.setRuleCode(ruleCode);
        elsBarcodeRuleHead.setRuleStatus(SrmEnabledStatusEnum.NEW.getValue());
        elsBarcodeRuleHead.setRuleNumber(this.codeGeneratorService.getNextCode("srmBarcodeRuleNumber", (Object)elsBarcodeRuleHead));
        if (StringUtils.isBlank((CharSequence)elsBarcodeRuleHead.getEncrypt())) {
            elsBarcodeRuleHead.setEncrypt("0");
        }
        this.elsBarcodeRuleHeadMapper.insert((Object)elsBarcodeRuleHead);
        this.insertData(elsBarcodeRuleHead, elsBarcodeRuleItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(ElsBarcodeRuleHead elsBarcodeRuleHead, List<ElsBarcodeRuleItem> elsBarcodeRuleItemList, Integer type) {
        int count;
        elsBarcodeRuleHead.setExample(this.generateBarcode(elsBarcodeRuleItemList));
        if (type != null && 2 == type) {
            elsBarcodeRuleHead.setRuleStatus(SrmEnabledStatusEnum.ENABLED.getValue());
        }
        if ((count = this.elsBarcodeRuleHeadMapper.updateById((Object)elsBarcodeRuleHead)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.elsBarcodeRuleItemMapper.deleteByMainId(elsBarcodeRuleHead.getId());
        this.insertData(elsBarcodeRuleHead, elsBarcodeRuleItemList);
    }

    private void insertData(ElsBarcodeRuleHead elsBarcodeRuleHead, List<ElsBarcodeRuleItem> elsBarcodeRuleItemList) {
        if (elsBarcodeRuleItemList != null && !elsBarcodeRuleItemList.isEmpty()) {
            int itemNum = 1;
            for (ElsBarcodeRuleItem entity : elsBarcodeRuleItemList) {
                entity.setHeadId(elsBarcodeRuleHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)elsBarcodeRuleHead);
                entity.setItemNumber(Integer.toString(itemNum));
                entity.setId(null);
                if (StrUtil.isBlank((CharSequence)entity.getUsedCode())) {
                    entity.setUsedCode("0");
                }
                ++itemNum;
            }
            this.elsBarcodeRuleItemMapper.insertBatchSomeColumn(elsBarcodeRuleItemList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.elsBarcodeRuleItemMapper.deleteByMainId(id);
        this.elsBarcodeRuleHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.elsBarcodeRuleItemMapper.deleteByMainId(serializable.toString());
            this.elsBarcodeRuleHeadMapper.deleteById(serializable);
        }
    }

    private String generateBarcode(List<ElsBarcodeRuleItem> elsBarcodeRuleItemList) {
        try {
            if (elsBarcodeRuleItemList != null && elsBarcodeRuleItemList.size() > 0) {
                Map<String, List<ElsBarcodeRuleItem>> groupByRuleItem = elsBarcodeRuleItemList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getBusinessType())).collect(Collectors.groupingBy(ElsBarcodeRuleItem::getBusinessType));
                QueryWrapper paramConfigQueryWrapper = new QueryWrapper();
                ((LambdaQueryWrapper)paramConfigQueryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(ElsBarCodeParamConfig::getStatus, (Object)ElsBarCodeParamConfigEnum.PARAM_CONFIG_STATUS_ON.value());
                if (groupByRuleItem.size() > 1) {
                    paramConfigQueryWrapper.lambda().isNull(ElsBarCodeParamConfig::getBusDocType);
                } else {
                    paramConfigQueryWrapper.lambda().eq(ElsBarCodeParamConfig::getBusDocType, (Object)elsBarcodeRuleItemList.get(0).getBusinessType());
                }
                List paramConfigs = this.elsBarCodeParamConfigMapper.selectList((Wrapper)paramConfigQueryWrapper);
                if (paramConfigs.size() == 0) {
                    return null;
                }
                return this.replaceCode(elsBarcodeRuleItemList);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String replaceCode(List<ElsBarcodeRuleItem> elsBarcodeRuleItemList) throws Exception {
        StringBuffer newBarCode = new StringBuffer();
        for (ElsBarcodeRuleItem item : elsBarcodeRuleItemList) {
            String attrValue = this.complement(item, this.initData);
            if (BarcodeAttrEnum.SIX.getValue().equals(item.getAttributeType()) || BarcodeAttrEnum.SEVEN.getValue().equals(item.getAttributeType()) || BarcodeAttrEnum.EIGHT.getValue().equals(item.getAttributeType()) || BarcodeAttrEnum.NINE.getValue().equals(item.getAttributeType())) {
                Integer count = 1;
                attrValue = String.format("%0" + item.getLength() + "d", count);
            } else if ("1".equals(item.getUsedCode())) {
                String shortCodeValue = this.elsBarCodeShortCodeMapper.getShortCodeValue(attrValue, item.getCodeType(), TenantContext.getTenant());
                attrValue = StringUtils.isEmpty((CharSequence)shortCodeValue) ? attrValue : shortCodeValue;
            }
            newBarCode.append(attrValue);
        }
        return newBarCode.toString();
    }

    private String complement(ElsBarcodeRuleItem item, String attr) throws Exception {
        if (item.getLength() > attr.length()) {
            String part = String.format("%0" + (item.getLength() - attr.length()) + "d", Integer.parseInt(item.getCoverCode())).replaceAll("0", item.getCoverCode());
            attr = "1".equals(item.getAlignment()) ? attr + part : part + attr;
        } else if (item.getLength() < attr.length()) {
            attr = "1".equals(item.getAlignment()) ? attr.substring(0, item.getLength()) : attr.substring(attr.length() - item.getLength());
        }
        return attr;
    }
}

