/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.util.StyleUtil;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.AbstractVerticalCellStyleStrategy;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.els.common.util.I18nUtil;
import com.els.modules.system.entity.ExcelDetail;
import com.els.modules.system.enums.ExcelDataTypeEnum;
import com.els.modules.system.util.ExcelDictWriteHandler;
import java.util.List;
import org.apache.poi.common.Duplicatable;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelCellStyleStrategy
extends AbstractVerticalCellStyleStrategy {
    public static WriteHandler TEMPLATE_WRITE_HANDLER;
    private List<ExcelDetail> detailList;
    protected CellStyle commonCellStyle;
    protected CellStyle redCellStyle;
    protected Workbook workbook;

    public ExcelCellStyleStrategy(List<ExcelDetail> detailList) {
        this.detailList = detailList;
    }

    protected void initCellStyle(Workbook workbook) {
        this.workbook = workbook;
        WriteCellStyle writeCellStyle = new WriteCellStyle();
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontHeightInPoints(Short.valueOf((short)11));
        writeCellStyle.setWriteFont(headWriteFont);
        this.commonCellStyle = StyleUtil.buildHeadCellStyle((Workbook)workbook, (WriteCellStyle)writeCellStyle);
        WriteCellStyle redWriteCellStyle = new WriteCellStyle();
        WriteFont redWriteFont = new WriteFont();
        redWriteFont.setFontHeightInPoints(Short.valueOf((short)11));
        redWriteFont.setColor(Short.valueOf((short)10));
        redWriteCellStyle.setWriteFont(redWriteFont);
        this.redCellStyle = StyleUtil.buildHeadCellStyle((Workbook)workbook, (WriteCellStyle)redWriteCellStyle);
        WriteCellStyle writeCellStyle1 = new WriteCellStyle();
        DataFormat dataFormat = this.workbook.createDataFormat();
        writeCellStyle1.setDataFormat(Short.valueOf(dataFormat.getFormat("@")));
        StyleUtil.buildContentCellStyle((Workbook)workbook, (WriteCellStyle)writeCellStyle1);
    }

    protected void setHeadCellStyle(Cell cell, Head head, Integer relativeRowIndex) {
        if (relativeRowIndex > 0) {
            if (cell.getStringCellValue().contains("\u975e\u5fc5\u586b")) {
                cell.setCellStyle(this.commonCellStyle);
            } else {
                cell.setCellStyle(this.redCellStyle);
            }
            cell.getSheet().setColumnWidth(head.getColumnIndex().intValue(), cell.getStringCellValue().length() * 600);
        } else {
            if (relativeRowIndex == 0 && cell.getStringCellValue().contains(I18nUtil.translate((String)"", (String)"\u9519\u8bef\u7ed3\u679c\u8bb0\u5f55"))) {
                cell.setCellStyle(this.redCellStyle);
                cell.getCellStyle().setWrapText(true);
                cell.getSheet().setColumnWidth(head.getColumnIndex().intValue(), cell.getStringCellValue().length() * 1000);
                return;
            }
            if (cell.getStringCellValue().contains(I18nUtil.translate((String)"", (String)"\u5904\u7406\u72b6\u6001"))) {
                cell.setCellStyle(this.redCellStyle);
                return;
            }
            cell.setCellStyle(this.commonCellStyle);
        }
    }

    protected void setContentCellStyle(Cell cell, Head head, Integer relativeRowIndex) {
        cell.setCellStyle(this.commonCellStyle);
        if (head.getColumnIndex() >= this.detailList.size()) {
            cell.setCellType(CellType.STRING);
        } else {
            ExcelDetail detail = this.detailList.get(head.getColumnIndex());
            if (ExcelDataTypeEnum.STRING.getCode().equals(detail.getDataType())) {
                cell.setCellType(CellType.STRING);
            } else if (ExcelDataTypeEnum.NUMBER.getCode().equals(detail.getDataType())) {
                cell.setCellType(CellType.NUMERIC);
            } else if (ExcelDataTypeEnum.DATE.getCode().equals(detail.getDataType())) {
                cell.setCellType(CellType.STRING);
            }
            if (StrUtil.isNotBlank((CharSequence)detail.getDataFormat())) {
                DataFormat format = cell.getSheet().getWorkbook().createDataFormat();
                cell.getCellStyle().setDataFormat(format.getFormat(detail.getDataFormat()));
            }
        }
    }

    protected WriteCellStyle headCellStyle(Head head) {
        return new WriteCellStyle();
    }

    protected WriteCellStyle contentCellStyle(Head head) {
        WriteCellStyle writeCellStyle = new WriteCellStyle();
        ExcelDetail detail = this.detailList.get(head.getColumnIndex());
        if (ExcelDataTypeEnum.STRING.getCode().equals(detail.getDataType()) || ExcelDataTypeEnum.NUMBER.getCode().equals(detail.getDataType())) {
            DataFormat dataFormat = this.workbook.createDataFormat();
            writeCellStyle.setDataFormat(Short.valueOf(dataFormat.getFormat("@")));
        }
        return writeCellStyle;
    }

    public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        CellStyle cellStyle;
        Workbook workbook = writeSheetHolder.getSheet().getWorkbook();
        CellStyle cellStyle1 = ExcelDictWriteHandler.CellStyleContext.STYLE.get();
        if (null == cellStyle1) {
            cellStyle = workbook.createCellStyle();
        } else {
            if (cellStyle1 instanceof Duplicatable) {
                CellStyle cellStyle2 = (CellStyle)((Duplicatable)cellStyle1).copy();
                cell.setCellStyle(cellStyle2);
                return;
            }
            cellStyle = workbook.createCellStyle();
        }
        DataFormat dataFormat = workbook.createDataFormat();
        cellStyle.setDataFormat(dataFormat.getFormat("@"));
        ExcelDictWriteHandler.CellStyleContext.STYLE.set(cellStyle);
        cell.setCellStyle(cellStyle);
    }

    static {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontHeightInPoints(Short.valueOf((short)11));
        headWriteFont.setBold(Boolean.valueOf(true));
        headWriteCellStyle.setWriteFont(headWriteFont);
        headWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        headWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        headWriteCellStyle.setBorderRight(BorderStyle.THIN);
        headWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.WHITE.getIndex()));
        headWriteCellStyle.setWrapped(Boolean.valueOf(true));
        headWriteCellStyle.setLocked(Boolean.valueOf(true));
        WriteCellStyle bodyWriteCellStyle = new WriteCellStyle();
        bodyWriteCellStyle.setDataFormat(Short.valueOf((short)49));
        TEMPLATE_WRITE_HANDLER = new HorizontalCellStyleStrategy(headWriteCellStyle, bodyWriteCellStyle);
    }
}

