/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.integration.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AppContext;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.modules.integration.rpc.service.InvokeOpenApiRpcService;
import com.els.modules.integration.vo.ApiParamVo;
import com.els.modules.template.entity.TemplateConfigHead;
import com.els.modules.template.entity.TemplateConfigItem;
import com.els.modules.template.entity.TemplateGroup;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.service.TemplateConfigHeadService;
import com.els.modules.template.service.TemplateConfigItemService;
import com.els.modules.template.service.TemplateGroupService;
import com.els.modules.template.service.TemplateHeadService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5f00\u653e\u63a5\u53e3"})
@RestController
@Scope(value="prototype")
@RequestMapping(value={"/openApi"})
public class OpenApiController {
    private static final Logger log = LoggerFactory.getLogger(OpenApiController.class);
    @Resource
    private TemplateHeadService templateHeadService;
    @Resource
    private TemplateConfigHeadService templateConfigHeadService;
    @Resource
    private TemplateConfigItemService templateConfigItemService;
    @Resource
    private TemplateGroupService templateGroupService;
    private OpenApiRpcService service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoLog(value="\u5f00\u653e\u63a5\u53e3-\u5916\u90e8\u7cfb\u7edf\u8c03\u7528SRM")
    @ApiOperation(value="\u5916\u90e8\u7cfb\u7edf\u8c03\u7528SRM", notes="\u5916\u90e8\u7cfb\u7edf\u8c03\u7528SRM")
    @PostMapping(value={"/invokeSrm"})
    public Result<?> invokeSrm(@RequestBody String paramStr) {
        boolean isPushed = false;
        try {
            if (paramStr == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yVNsxOLVW_51d52976", (String)"\u63a5\u53e3\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
            JSONObject param = JSONObject.parseObject((String)paramStr);
            String busAccount = param.getString("busAccount");
            if (StrUtil.isBlank((CharSequence)busAccount)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ESCeyWWWWWWWWWWWWxOLV_1093fc86", (String)"\u4e1a\u52a1\u65b9\u8d26\u53f7 busAccount \u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
            String elsAccount = TenantContext.getTenant();
            if (!"100000".equals(elsAccount) && !busAccount.equals(elsAccount)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_sWuhWVImESCey_a65030e", (String)"\u53c2\u6570\u975e\u6cd5\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u65b9\u8d26\u53f7\uff01"));
            }
            this.setLoginUser(busAccount);
            String interfaceCode = param.getString("interfaceCode");
            if (StrUtil.isBlank((CharSequence)interfaceCode)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yVAoWWWWWWWWWWWWWWWxOLVW_61a79d80", (String)"\u63a5\u53e3\u7f16\u7801 interfaceCode \u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
            String dianchiPurchaseAccount = (String)((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig().get("dianchiPurchaseAccount");
            if (elsAccount.equals(dianchiPurchaseAccount)) {
                DynamicDataSourceContextHolder.push((String)"dianchi");
            } else {
                DynamicDataSourceContextHolder.push((String)"master");
            }
            log.info("invokeSrm  current data source: {}", (Object)DynamicDataSourceContextHolder.peek());
            if (!((InvokeAccountRpcService)SpringContextUtils.getBean(InvokeAccountRpcService.class)).checkAppPermission(elsAccount, AppContext.getAppId(), interfaceCode).booleanValue()) {
                throw new ELSBootException("\u63a5\u53e3\u4e0d\u5b58\u5728\u6216\u8005\u6ca1\u6709\u5f00\u901a\u8c03\u7528\u6743\u9650\uff01");
            }
            JSONObject data = param.getJSONObject("data");
            String simpleFlag = param.getString("simpleFlag");
            if ("1".equals(simpleFlag)) {
                SimpleOpenApiRpcService simpleOpenApiRpcService = ((InvokeOpenApiRpcService)SpringContextUtils.getBean(InvokeOpenApiRpcService.class)).getSimpleOpenApiRpcService(interfaceCode);
                if (simpleOpenApiRpcService == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yVAoWWWWWWWxMKW_90eb7597", (String)"\u63a5\u53e3\u7f16\u7801  ${0} \u4e0d\u5b58\u5728\uff01", (String[])new String[]{interfaceCode}));
                }
                Result result = Result.ok((Object)simpleOpenApiRpcService.invoke(data));
                return result;
            }
            this.service = ((InvokeOpenApiRpcService)SpringContextUtils.getBean(InvokeOpenApiRpcService.class)).getOpenApiRpcService(interfaceCode);
            if (this.service == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yVAoWWWWWWWxMKW_90eb7597", (String)"\u63a5\u53e3\u7f16\u7801  ${0} \u4e0d\u5b58\u5728\uff01", (String[])new String[]{interfaceCode}));
            }
            Result result = Result.ok((Object)this.invoke(data));
            return result;
        }
        finally {
            DynamicDataSourceContextHolder.clear();
        }
    }

    private void setLoginUser(String elsAccount) {
        LoginUser loginUser = new LoginUser();
        loginUser.setElsAccount(elsAccount);
        loginUser.setSubAccount(AppContext.getAppId());
        loginUser.setRealname("interface");
        LoginUserContext.setUser((LoginUser)loginUser);
        TenantContext.setTenant((String)elsAccount);
    }

    @AutoLog(value="\u5f00\u653e\u63a5\u53e3-IPaaS\u8c03\u7528SRM")
    @ApiOperation(value="IPaaS\u8c03\u7528SRM", notes="IPaaS\u8c03\u7528SRM")
    @PostMapping(value={"/iPaaSInvoke"})
    public Result<?> iPaaSInvoke(@RequestBody String paramStr) {
        if (paramStr == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yVNsxOLVW_51d52976", (String)"\u63a5\u53e3\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        JSONObject param = JSONObject.parseObject((String)paramStr);
        String busAccount = param.getString("busAccount");
        if (StrUtil.isBlank((CharSequence)busAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ESCeyWWWWWWWWWWWWxOLV_1093fc86", (String)"\u4e1a\u52a1\u65b9\u8d26\u53f7 busAccount \u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        TenantContext.setTenant((String)busAccount);
        String interfaceCode = param.getString("interfaceCode");
        if (StrUtil.isBlank((CharSequence)interfaceCode)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yVAoWWWWWWWWWWWWWWWxOLVW_61a79d80", (String)"\u63a5\u53e3\u7f16\u7801 interfaceCode \u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        JSONObject data = param.getJSONObject("data");
        SimpleOpenApiRpcService simpleOpenApiRpcService = ((InvokeOpenApiRpcService)SpringContextUtils.getBean(InvokeOpenApiRpcService.class)).getSimpleOpenApiRpcService(interfaceCode);
        if (simpleOpenApiRpcService == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yVAoWWWWWWWxMKW_90eb7597", (String)"\u63a5\u53e3\u7f16\u7801  ${0} \u4e0d\u5b58\u5728\uff01", (String[])new String[]{interfaceCode}));
        }
        return Result.ok((Object)simpleOpenApiRpcService.invoke(data));
    }

    private TemplateHead getTemplateHead() {
        String elsAccount = TenantContext.getTenant();
        if (CharSequenceUtil.isBlank((CharSequence)elsAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jDUiLV_7a9d5083", (String)"\u7528\u6237\u51ed\u8bc1\u4e3a\u7a7a\uff01"));
        }
        List<TemplateHead> list = this.templateHeadService.getAllByAccountAndType(elsAccount, this.getBusinessType());
        if (list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_businessTemplate", (String)"\u672a\u914d\u7f6e\u4e1a\u52a1\u6a21\u677f\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        return list.get(0);
    }

    private JSONObject invoke(JSONObject param) {
        TemplateHead templateHead = this.getTemplateHead();
        List<TemplateConfigHead> configHeadList = this.templateConfigHeadService.selectByMainId(templateHead.getId());
        List<TemplateConfigItem> configItemList = this.templateConfigItemService.selectByMainId(templateHead.getId());
        JSONArray array = param.getJSONArray("headList");
        if (null == array || array.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u63a5\u53e3param\u53c2\u6570\u4e2dheadList\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        HashMap<String, String> defaultHeadMap = new HashMap<String, String>();
        for (TemplateConfigHead configHead : configHeadList) {
            if (!CharSequenceUtil.isNotBlank((CharSequence)configHead.getDefaultValue())) continue;
            defaultHeadMap.put(configHead.getFieldName(), configHead.getDefaultValue());
        }
        HashMap<String, String> defaultItemMap = new HashMap<String, String>();
        for (TemplateConfigItem configItem : configItemList) {
            if (!CharSequenceUtil.isNotBlank((CharSequence)configItem.getDefaultValue())) continue;
            defaultItemMap.put(configItem.getFieldName(), configItem.getDefaultValue());
        }
        this.commonParamCheck(array, templateHead, defaultHeadMap, defaultItemMap, configHeadList, configItemList);
        return this.doCreateInvoke(array, templateHead, defaultHeadMap, defaultItemMap);
    }

    private void commonParamCheck(JSONArray array, TemplateHead templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHead> configHeadList, List<TemplateConfigItem> configItemList) {
        List<String> headRequiredFieldList = configHeadList.stream().filter(x -> "1".equals(x.getRequired())).map(TemplateConfigHead::getFieldName).collect(Collectors.toList());
        List<String> itemRequiredFieldList = configItemList.stream().filter(x -> "1".equals(x.getRequired())).map(TemplateConfigItem::getFieldName).collect(Collectors.toList());
        headRequiredFieldList.removeAll(defaultHeadMap.keySet());
        itemRequiredFieldList.removeAll(defaultItemMap.keySet());
        if (CollUtil.isNotEmpty(headRequiredFieldList)) {
            for (int index = 0; index < array.size(); ++index) {
                JSONObject head = (JSONObject)Convert.convert(JSONObject.class, (Object)array.get(index));
                if (null == head || head.size() == 0) continue;
                this.containAndHaveValueCheck(headRequiredFieldList, head, index, 0, "headList");
                this.checkItemRequiredParam(head, itemRequiredFieldList, index);
            }
        } else {
            for (int index = 0; index < array.size(); ++index) {
                JSONObject head = (JSONObject)Convert.convert(JSONObject.class, (Object)array.get(index));
                if (null == head || head.size() == 0) continue;
                this.checkItemRequiredParam(head, itemRequiredFieldList, index);
            }
        }
        this.doParamCheck(array, templateHead, defaultHeadMap, defaultItemMap, configHeadList, configItemList);
    }

    private void checkItemRequiredParam(JSONObject head, List<String> itemRequiredFieldList, int headIndex) {
        if (CollUtil.isEmpty(itemRequiredFieldList)) {
            return;
        }
        List supportItemList = this.service.supportItemList();
        if (null != supportItemList && !supportItemList.isEmpty()) {
            for (String itemType : supportItemList) {
                if (!head.containsKey((Object)itemType)) continue;
                JSONArray arrayParam = head.getJSONArray(itemType);
                if (null == arrayParam || arrayParam.isEmpty()) {
                    return;
                }
                for (int itemIndex = 0; itemIndex < arrayParam.size(); ++itemIndex) {
                    JSONObject object = (JSONObject)Convert.convert(JSONObject.class, (Object)arrayParam.get(itemIndex));
                    this.containAndHaveValueCheck(itemRequiredFieldList, object, headIndex, itemIndex, itemType);
                }
            }
        } else {
            if (!head.containsKey((Object)"itemList")) {
                return;
            }
            JSONArray arrayParam = head.getJSONArray("itemList");
            if (null == arrayParam || arrayParam.isEmpty()) {
                return;
            }
            for (int itemIndex = 0; itemIndex < arrayParam.size(); ++itemIndex) {
                JSONObject object = (JSONObject)Convert.convert(JSONObject.class, (Object)arrayParam.get(itemIndex));
                this.containAndHaveValueCheck(itemRequiredFieldList, object, headIndex, itemIndex, "itemList");
            }
        }
    }

    private void containAndHaveValueCheck(List<String> requiredFieldNameList, JSONObject object, int headIndex, int itemIndex, String paramItem) {
        for (String fieldName : requiredFieldNameList) {
            String string = paramItem = "itemList".equals(paramItem) ? String.format("headList[%s].itemList[%s]", headIndex + 1, itemIndex + 1) : String.format("headList[%s]", headIndex + 1);
            if (!object.containsKey((Object)fieldName)) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)String.format("\u53c2\u6570%s\u7f3a\u5c11\u5fc5\u586b\u5b57\u6bb5\u53c2\u6570\u5b57\u6bb5:%s", paramItem, fieldName)));
            }
            Object fieldValue = object.get((Object)fieldName);
            boolean flag = null == fieldValue || fieldValue instanceof String && CharSequenceUtil.isBlank((CharSequence)((String)fieldValue));
            if (!flag) continue;
            throw new ELSBootException(I18nUtil.translate((String)"", (String)String.format("\u53c2\u6570%s\u5b57\u6bb5:%s\u503c\u4e0d\u80fd\u4e3a\u7a7a", paramItem, fieldName)));
        }
    }

    private void doParamCheck(JSONArray array, TemplateHead templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHead> configHeadList, List<TemplateConfigItem> configItemList) {
        TemplateHeadDTO dto = new TemplateHeadDTO();
        BeanUtils.copyProperties((Object)((Object)templateHead), (Object)dto);
        ArrayList configHeadDTOList = SysUtil.copyProperties(configHeadList, TemplateConfigHeadDTO.class);
        ArrayList configItemDTOList = SysUtil.copyProperties(configItemList, TemplateConfigItemDTO.class);
        this.service.doParamCheck(array, dto, defaultHeadMap, defaultItemMap, (List)configHeadDTOList, (List)configItemDTOList);
    }

    private JSONObject doCreateInvoke(JSONArray array, TemplateHead templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap) {
        TemplateHeadDTO dto = new TemplateHeadDTO();
        BeanUtils.copyProperties((Object)((Object)templateHead), (Object)dto);
        return this.service.doCreateInvoke(array, dto, defaultHeadMap, defaultItemMap);
    }

    private String getBusinessType() {
        return this.service.getBusinessType();
    }

    @AutoLog(value="\u5f00\u653e\u63a5\u53e3-\u5916\u90e8\u7cfb\u7edf\u8c03\u7528SRM\u53c2\u6570")
    @ApiOperation(value="\u5916\u90e8\u7cfb\u7edf\u8c03\u7528SRM\u53c2\u6570\u67e5\u8be2", notes="\u5916\u90e8\u7cfb\u7edf\u8c03\u7528SRM\u53c2\u6570\u67e5\u8be2")
    @GetMapping(value={"/invokeSrmParam/{interfaceCode}"})
    public Result<?> invokeSrmParam(@PathVariable(value="interfaceCode") String interfaceCode) {
        if (StrUtil.isEmpty((CharSequence)interfaceCode)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yVNsxOLVW_51d52976", (String)"\u63a5\u53e3\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        OpenApiRpcService openApiRpcService = ((InvokeOpenApiRpcService)SpringContextUtils.getBean(InvokeOpenApiRpcService.class)).getOpenApiRpcService(interfaceCode);
        if (null == openApiRpcService) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yVAoWWWWWWWxMKW_90eb7597", (String)"\u63a5\u53e3\u7f16\u7801  ${0} \u4e0d\u5b58\u5728\uff01", (String[])new String[]{interfaceCode}));
        }
        String elsAccount = TenantContext.getTenant();
        if (CharSequenceUtil.isBlank((CharSequence)elsAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u7528\u6237\u51ed\u8bc1\u4e3a\u7a7a\uff01"));
        }
        List<TemplateHead> list = this.templateHeadService.getAllByAccountAndType("100000", openApiRpcService.getBusinessType());
        if (list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u914d\u7f6e\u9ed8\u8ba4\u4e1a\u52a1\u6a21\u677f\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        TemplateHead templateHead = list.get(0);
        List<TemplateConfigHead> configHeadList = this.templateConfigHeadService.selectByMainId(templateHead.getId());
        List<TemplateGroup> groupList = this.templateGroupService.selectByMainId(templateHead.getId());
        List<TemplateConfigItem> configItemList = this.templateConfigItemService.selectByMainId(templateHead.getId());
        if (CollUtil.isEmpty(configHeadList)) {
            return Result.ok();
        }
        List needGroupList = groupList.stream().filter(x -> x.getGroupType().equals("item")).collect(Collectors.toList());
        List needHeadList = configHeadList.stream().filter(x -> "1".equals(x.getPurchaseShow())).collect(Collectors.toList());
        List needItemList = configItemList.stream().filter(x -> "1".equals(x.getPurchaseShow())).collect(Collectors.toList());
        List businessClass = openApiRpcService.getBusinessClass();
        Map columnDTOMap = businessClass.stream().collect(Collectors.toMap(ExcelExportClassColumnDTO::getFileName, Function.identity()));
        JSONObject allResult = new JSONObject();
        JSONObject descResult = new JSONObject();
        JSONObject data = new JSONObject();
        JSONObject baseForm = new JSONObject();
        descResult.put("data", (Object)Lists.newArrayList((Object[])new JSONObject[]{data}));
        descResult.put("interfaceCode", (Object)interfaceCode);
        descResult.put("busAccount", (Object)"");
        data.put("headList", (Object)Lists.newArrayList((Object[])new JSONObject[]{baseForm}));
        allResult.put("paramDesc", (Object)descResult);
        JSONObject eg = new JSONObject();
        JSONObject noDescResult = new JSONObject();
        JSONObject baseFormEg = new JSONObject();
        eg.put("data", (Object)Lists.newArrayList((Object[])new JSONObject[]{noDescResult}));
        noDescResult.put("interfaceCode", (Object)interfaceCode);
        noDescResult.put("busAccount", (Object)TenantContext.getTenant());
        noDescResult.put("headList", (Object)Lists.newArrayList((Object[])new JSONObject[]{baseFormEg}));
        allResult.put("eg", (Object)eg);
        for (TemplateConfigHead form : needHeadList) {
            ExcelExportClassColumnDTO columnDTO = (ExcelExportClassColumnDTO)columnDTOMap.get(form.getFieldName());
            if (null == columnDTO) continue;
            ApiParamVo vo = new ApiParamVo();
            String dictCode = form.getDictCode();
            boolean isDict = StrUtil.isNotBlank((CharSequence)dictCode) && null != columnDTO.getDict();
            vo.setIsDict(isDict);
            if (isDict) {
                if (StrUtil.isNotEmpty((CharSequence)dictCode)) {
                    vo.setDicCode(dictCode);
                } else {
                    vo.setDictTable(columnDTO.getDict().getDictTable());
                    vo.setDicCode(columnDTO.getDict().getDicCode());
                    vo.setDicText(columnDTO.getDict().getDicText());
                }
            }
            vo.setDesc(form.getFieldLabel());
            vo.setRequired("1".equals(form.getRequired()));
            vo.setType(columnDTO.getFileType());
            baseForm.put(form.getFieldName(), (Object)vo);
            baseFormEg.put(form.getFieldName(), (Object)"");
        }
        for (TemplateGroup group : needGroupList) {
            Boolean collection;
            String groupCode = group.getGroupCode();
            ExcelExportClassColumnDTO groupColumn = (ExcelExportClassColumnDTO)columnDTOMap.get(groupCode);
            if (null == groupColumn || !BooleanUtil.isTrue((Boolean)(collection = groupColumn.getCollection()))) continue;
            List childrenList = groupColumn.getChildren();
            Map childColumnDTOMap = childrenList.stream().collect(Collectors.toMap(ExcelExportClassColumnDTO::getFileName, Function.identity()));
            JSONObject itemForm = new JSONObject();
            JSONObject itemFormEg = new JSONObject();
            baseForm.put(groupCode, (Object)Lists.newArrayList((Object[])new JSONObject[]{itemForm}));
            baseFormEg.put(groupCode, (Object)Lists.newArrayList((Object[])new JSONObject[]{itemFormEg}));
            for (TemplateConfigItem form : needItemList) {
                ExcelExportClassColumnDTO columnDTO;
                if (!form.getGroupCode().equals(groupCode) || null == (columnDTO = (ExcelExportClassColumnDTO)childColumnDTOMap.get(form.getFieldName()))) continue;
                ApiParamVo vo = new ApiParamVo();
                String dictCode = form.getDictCode();
                boolean isDict = StrUtil.isNotBlank((CharSequence)dictCode) && null != columnDTO.getDict();
                vo.setIsDict(isDict);
                if (isDict) {
                    if (StrUtil.isNotEmpty((CharSequence)dictCode)) {
                        vo.setDicCode(dictCode);
                    } else {
                        vo.setDictTable(columnDTO.getDict().getDictTable());
                        vo.setDicCode(columnDTO.getDict().getDicCode());
                        vo.setDicText(columnDTO.getDict().getDicText());
                    }
                }
                vo.setDesc(form.getFieldLabel());
                vo.setRequired("1".equals(form.getRequired()));
                vo.setType(columnDTO.getFileType());
                itemForm.put(form.getFieldName(), (Object)vo);
                itemFormEg.put(form.getFieldName(), (Object)"");
            }
        }
        return Result.ok((Object)allResult);
    }
}

