/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ipaas.controller;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HtmlUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.ServiceAddressUtil;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.modules.integration.service.SrmToIPaasService;
import com.els.modules.ipaas.entity.OrderEntity;
import com.els.modules.system.service.ElsIpaasConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(tags={"SRM\u8c03\u7528iPaas\u5e73\u53f0"})
@RestController
@RequestMapping(value={"/ipaas/srmToIPaas"})
public class SrmToIPaasController {
    private static final Logger log = LoggerFactory.getLogger(SrmToIPaasController.class);
    @Autowired
    private SrmToIPaasService srmToIPaasService;
    @Autowired
    private StaticConfig staticConfig;
    @Autowired
    private ElsIpaasConfigService elsIpaasConfigService;

    @ApiOperation(value="\u670d\u52a1\u5305\u67e5\u8be2", notes="\u670d\u52a1\u5305\u67e5\u8be2")
    @GetMapping(value={"/servicePackList"})
    @RequiresPermissions(value={"ipaas#srmToIPaas:servicePackList"})
    public Result<?> servicePackList(@RequestParam(name="pageNo", required=false) Integer pageNo, @RequestParam(name="pageSize", required=false) Integer pageSize, @RequestParam(name="serviceType", required=false) String serviceType) {
        JSONObject data = new JSONObject();
        data.put("source", (Object)"0");
        data.put("pageNo", (Object)pageNo);
        data.put("pageSize", (Object)pageSize);
        data.put("serviceType", (Object)serviceType);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "servicePack");
        return result.getBoolean("success") != false ? Result.ok((Object)result) : Result.error((String)result.getString("message"));
    }

    @ApiOperation(value="\u670d\u52a1\u5957\u9910\u67e5\u8be2", notes="\u670d\u52a1\u5957\u9910\u67e5\u8be2")
    @GetMapping(value={"/selectServiceCombo"})
    @RequiresPermissions(value={"ipaas#srmToIPaas:selectServiceCombo"})
    public Result<?> selectServiceCombo(@RequestParam(value="servicePackId") String servicePackId, @RequestParam(value="priceType") String priceType) {
        JSONObject data = new JSONObject();
        data.put("servicePackId", (Object)servicePackId);
        data.put("priceType", (Object)priceType);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "serviceCombo");
        return result.getBoolean("success") != false ? Result.ok((Object)result) : Result.error((String)result.getString("message"));
    }

    @ApiOperation(value="\u5145\u503c\u8bb0\u5f55", notes="\u5145\u503c\u8bb0\u5f55")
    @GetMapping(value={"/rechargeRecordList"})
    @RequiresPermissions(value={"ipaas#srmToIPaas:rechargeRecordList"})
    public Result<?> rechargeRecordList(@RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        JSONObject data = new JSONObject();
        data.put("pageNo", (Object)pageNo);
        data.put("pageSize", (Object)pageSize);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "orderList");
        return result.getBoolean("success") != false ? Result.ok((Object)result) : Result.error((String)result.getString("message"));
    }

    @ApiOperation(value="\u5f00\u901a\u8bb0\u5f55", notes="\u5f00\u901a\u8bb0\u5f55")
    @GetMapping(value={"/activationRecordList"})
    @RequiresPermissions(value={"ipaas#srmToIPaas:activationRecordList"})
    public Result<?> activationRecordList(@RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        JSONObject data = new JSONObject();
        data.put("pageNo", (Object)pageNo);
        data.put("pageSize", (Object)pageSize);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "qualificationList");
        return result.getBoolean("success") != false ? Result.ok((Object)result) : Result.error((String)result.getString("message"));
    }

    @ApiOperation(value="\u6d88\u8d39\u8bb0\u5f55", notes="\u6d88\u8d39\u8bb0\u5f55")
    @GetMapping(value={"/expensesRecordList"})
    @RequiresPermissions(value={"ipaas#srmToIPaas:expensesRecordList"})
    public Result<?> expensesRecordList(@RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        JSONObject data = new JSONObject();
        data.put("pageNo", (Object)pageNo);
        data.put("pageSize", (Object)pageSize);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "expensesList");
        return result.getBoolean("success") != false ? Result.ok((Object)result) : Result.error((String)result.getString("message"));
    }

    @ApiOperation(value="\u5145\u503c\u521b\u5efa\u8ba2\u5355", notes="\u5145\u503c\u521b\u5efa\u8ba2\u5355")
    @GetMapping(value={"/rechargeCreateOrder"})
    @RequiresPermissions(value={"ipaas#srmToIPaas:rechargeCreateOrder"})
    public Result<?> rechargeCreateOrder(@RequestParam(value="rechargeType") String rechargeType, @RequestParam(value="orderType") String orderType, @RequestParam(value="rechargeAmount") BigDecimal rechargeAmount) {
        JSONObject data = new JSONObject();
        LoginUser loginUser = SysUtil.getLoginUser();
        data.put("customerAccount", (Object)loginUser.getElsAccount());
        data.put("customerName", (Object)loginUser.getEnterpriseName());
        data.put("orderType", (Object)orderType);
        data.put("rechargeAmount", (Object)rechargeAmount);
        data.put("mail", (Object)loginUser.getEmail());
        JSONObject createResult = this.srmToIPaasService.callIPaasInterface(data, "createOrder", "recharge");
        if (createResult.getBoolean("success").booleanValue()) {
            String orderId = createResult.getJSONObject("data").getString("orderId");
            JSONObject toPayResult = this.commonPayService(rechargeType, orderId, rechargeAmount, "\u5145\u503c", new Date());
            return toPayResult.getBoolean("success") != false ? Result.ok((String)HtmlUtil.unescape((String)toPayResult.getJSONObject("data").getString("data")), (Object)orderId) : Result.error((String)("\u8ba2\u5355\u521b\u5efa\u6210\u529f\uff0c\u652f\u4ed8\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + toPayResult.getString("message")));
        }
        return Result.error((String)(I18nUtil.translate((String)"i18n_alert_cIVRItKm_a162ce5d", (String)"\u521b\u5efa\u5145\u503c\u8ba2\u5355\u5931\u8d25\uff1a") + createResult.getString("message")));
    }

    @ApiOperation(value="\u670d\u52a1\u5957\u9910\u521b\u5efa\u8ba2\u5355", notes="\u670d\u52a1\u5957\u9910\u521b\u5efa\u8ba2\u5355")
    @GetMapping(value={"/comboCreateOrder"})
    @RequiresPermissions(value={"ipaas#srmToIPaas:comboCreateOrder"})
    public Result<?> comboCreateOrder(@RequestParam(value="rechargeType") String rechargeType, @RequestParam(value="serviceComboId") String serviceComboId, @RequestParam(value="orderType") String orderType, @RequestParam(value="orderPrice") BigDecimal orderPrice, @RequestParam(value="comboQualification") Integer comboQualification, @RequestParam(value="serviceComboName") String serviceComboName) {
        JSONObject data = new JSONObject();
        LoginUser loginUser = SysUtil.getLoginUser();
        data.put("serviceComboId", (Object)serviceComboId);
        data.put("customerAccount", (Object)loginUser.getElsAccount());
        data.put("customerName", (Object)loginUser.getEnterpriseName());
        data.put("orderType", (Object)orderType);
        data.put("orderPrice", (Object)orderPrice);
        data.put("comboQualification", (Object)comboQualification);
        data.put("fbk1", (Object)loginUser.getSubAccount());
        data.put("fbk2", (Object)loginUser.getPhone());
        data.put("fbk3", (Object)("1".equals(AdminFlagUtil.getAdminFlag()) ? "admin" : ""));
        JSONObject createResult = this.srmToIPaasService.callIPaasInterface(data, "createOrder", "combo");
        if (createResult.getBoolean("success").booleanValue()) {
            String orderId = createResult.getJSONObject("data").getString("orderId");
            JSONObject toPayResult = this.commonPayService(rechargeType, orderId, orderPrice, serviceComboName, new Date());
            return toPayResult.getBoolean("success") != false ? Result.ok((String)HtmlUtil.unescape((String)toPayResult.getJSONObject("data").getString("data")), (Object)orderId) : Result.error((String)("\u8ba2\u5355\u521b\u5efa\u6210\u529f\uff0c\u652f\u4ed8\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + toPayResult.getString("message")));
        }
        return Result.error((String)(I18nUtil.translate((String)"i18n_alert_cIVRItKm_a162ce5d", (String)"\u521b\u5efa\u5145\u503c\u8ba2\u5355\u5931\u8d25\uff1a") + createResult.getString("message")));
    }

    @ApiOperation(value="\u8ba2\u5355\u652f\u4ed8", notes="\u8ba2\u5355\u652f\u4ed8")
    @PostMapping(value={"/orderPayment"})
    @RequiresPermissions(value={"ipaas#srmToIPaas:orderPayment"})
    public Result<?> orderPayment(@RequestBody OrderEntity order) {
        String goodsName = StringUtils.isBlank((CharSequence)order.getServiceComboName()) ? "\u5145\u503c" : order.getServiceComboName();
        JSONObject toPayResult = this.commonPayService(order.getRechargeType(), order.getId(), order.getOrderPrice(), goodsName, order.getOrderDate());
        return toPayResult.getBoolean("success") != false ? Result.ok((String)HtmlUtil.unescape((String)toPayResult.getJSONObject("data").getString("data")), (Object)order.getId()) : Result.error((String)("\u652f\u4ed8\u5931\u8d25\uff1a" + toPayResult.getString("message")));
    }

    private JSONObject commonPayService(String rechargeType, String orderId, BigDecimal orderAmount, String goodsName, Date orderDate) {
        String serviceAddress = ServiceAddressUtil.getServiceAddress();
        JSONObject data = new JSONObject();
        data.put("rechargeType", (Object)rechargeType);
        data.put("businessTag", (Object)"SRM");
        data.put("orderId", (Object)orderId);
        data.put("orderAmt", (Object)orderAmount);
        data.put("orderDate", (Object)DateUtil.format((Date)orderDate, (String)"yyyyMMdd"));
        data.put("goodsName", (Object)goodsName);
        data.put("payType", (Object)"B2C");
        data.put("responseType", (Object)"HTML");
        data.put("pageNotifyUrl", (Object)(serviceAddress + "/srm/supplier/supplierValue"));
        data.put("backNotifyUrl", (Object)(serviceAddress + "/els/openApi/iPaaSInvoke"));
        return this.srmToIPaasService.callIPaasInterface(data, "commonPayService");
    }

    @ApiOperation(value="\u8ba2\u5355\u8be6\u60c5", notes="\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"/orderDetail"})
    @RequiresPermissions(value={"ipaas#srmToIPaas:orderDetail"})
    public Result<?> orderDetail(@RequestParam(value="id") String id) {
        JSONObject data = new JSONObject();
        data.put("orderId", (Object)id);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "orderDetail");
        return result.getBoolean("success") != false ? Result.ok((Object)result.getJSONObject("data")) : Result.error((String)result.getString("message"));
    }

    @ApiOperation(value="\u786e\u8ba4\u8ba2\u5355", notes="\u786e\u8ba4\u8ba2\u5355")
    @GetMapping(value={"/confirmOrder"})
    @RequiresPermissions(value={"ipaas#srmToIPaas:confirmOrder"})
    public Result<?> confirmOrder(@RequestParam(value="orderId") String orderId) {
        JSONObject data = new JSONObject();
        data.put("orderId", (Object)orderId);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "confirmOrder");
        return result.getBoolean("success") != false ? Result.ok((Object)result) : Result.error((String)result.getString("message"));
    }

    @ApiOperation(value="\u4f5c\u5e9f\u8ba2\u5355", notes="\u4f5c\u5e9f\u8ba2\u5355")
    @GetMapping(value={"/cancelOrder"})
    @RequiresPermissions(value={"ipaas#srmToIPaas:cancelOrder"})
    public Result<?> cancelOrder(@RequestParam(value="orderId") String orderId) {
        JSONObject data = new JSONObject();
        data.put("orderId", (Object)orderId);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "cancelOrder");
        return result.getBoolean("success") != false ? Result.ok((Object)result) : Result.error((String)result.getString("message"));
    }

    @ApiOperation(value="\u8ba2\u5355\u4e0a\u4f20\u6587\u4ef6", notes="\u8ba2\u5355\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/uploadOrderFile"})
    @RequiresPermissions(value={"ipaas#srmToIPaas:uploadOrderFile"})
    public Result<?> uploadOrderFile(HttpServletRequest request) {
        String headId = request.getParameter("headId");
        Assert.hasText((String)headId, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a"));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        try {
            Iterator iterator = fileMap.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entity = iterator.next();
                JSONObject data = new JSONObject();
                data.put("orderId", (Object)headId);
                data.put("fileString", (Object)Base64.encode((byte[])((MultipartFile)entity.getValue()).getBytes()));
                data.put("fileName", (Object)((MultipartFile)entity.getValue()).getOriginalFilename());
                JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "attachment", "upload");
                return result.getBoolean("success") != false ? Result.ok((Object)result) : Result.error((String)result.getString("message"));
            }
        }
        catch (IOException e) {
            log.error("\u4e0a\u4f20\u5931\u8d25:", (Throwable)e);
            return Result.error((String)I18nUtil.translate((String)"i18n_field_XVKm_24addeea", (String)"\u4e0a\u4f20\u5931\u8d25"));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_field_XVKm_24addeea", (String)"\u4e0a\u4f20\u5931\u8d25"));
    }

    @ApiOperation(value="\u8ba2\u5355\u4e0b\u8f7d\u6587\u4ef6", notes="\u8ba2\u5355\u4e0b\u8f7d\u6587\u4ef6")
    @GetMapping(value={"/downloadOrderFile"})
    @RequiresPermissions(value={"ipaas#srmToIPaas:downloadOrderFile"})
    public void downloadOrderFile(@RequestParam(name="fileId") String fileId, HttpServletResponse response) {
        JSONObject data = new JSONObject();
        data.put("fileId", (Object)fileId);
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "attachment", "download");
        if (result.getBoolean("success").booleanValue()) {
            String fileString = result.getJSONObject("data").getString("data");
            try (ServletOutputStream outputStream = response.getOutputStream();){
                response.addHeader("Content-Disposition", "attachment;fileName=" + new String("response".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
                Base64.decodeToStream((CharSequence)fileString, (OutputStream)outputStream, (boolean)false);
                outputStream.flush();
            }
            catch (Exception e) {
                log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25:", (Throwable)e);
            }
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5145\u503c/\u6d88\u8d39/\u5269\u4f59\u91d1\u989d", notes="\u83b7\u53d6\u5145\u503c/\u6d88\u8d39/\u5269\u4f59\u91d1\u989d")
    @GetMapping(value={"/getAmount"})
    @RequiresPermissions(value={"ipaas#srmToIPaas:getAmount"})
    public Result<?> getAmount() {
        JSONObject result = this.srmToIPaasService.callIPaasInterface(new JSONObject(), "getAmount");
        return result.getBoolean("success") != false ? Result.ok((Object)result.getJSONObject("data")) : Result.error((String)result.getString("message"));
    }

    @ApiOperation(value="\u65b0\u589e\u4f01\u4e1a\u76d1\u6d4b", notes="\u65b0\u589e\u4f01\u4e1a\u76d1\u6d4b")
    @GetMapping(value={"/addEnterpriseMonitoring"})
    @RequiresPermissions(value={"ipaas#srmToIPaas:addEnterpriseMonitoring"})
    public Result<?> addEnterpriseMonitoring(@RequestParam(value="companyName") String companyName) {
        JSONObject data = new JSONObject();
        data.put("opt_type", (Object)"1");
        data.put("companies", Collections.singletonList(companyName));
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "valueAddedApplication", this.elsIpaasConfigService.getIpaasInterfaceCode("add-monitoring"));
        if (result.getBoolean("success").booleanValue()) {
            JSONObject object = result.getJSONObject("data");
            if (object != null) {
                String status = object.getString("status");
                if ("200".equals(status)) {
                    return Result.ok();
                }
                return Result.error((String)object.getString("message"));
            }
            return Result.error((String)result.getString("message"));
        }
        return Result.error((String)result.getString("message"));
    }

    @ApiOperation(value="\u5220\u9664\u4f01\u4e1a\u76d1\u6d4b", notes="\u5220\u9664\u4f01\u4e1a\u76d1\u6d4b")
    @GetMapping(value={"/deleteEnterpriseMonitoring"})
    @RequiresPermissions(value={"ipaas#srmToIPaas:deleteEnterpriseMonitoring"})
    public Result<?> deleteEnterpriseMonitoring(@RequestParam(value="companyName") String companyName) {
        JSONObject data = new JSONObject();
        data.put("opt_type", (Object)"0");
        data.put("companies", Collections.singletonList(companyName));
        JSONObject result = this.srmToIPaasService.callIPaasInterface(data, "valueAddedApplication", this.elsIpaasConfigService.getIpaasInterfaceCode("add-monitoring"));
        if (result.getBoolean("success").booleanValue()) {
            JSONObject object = result.getJSONObject("data");
            if (object != null) {
                String status = object.getString("status");
                if ("200".equals(status)) {
                    return Result.ok();
                }
                return Result.error((String)object.getString("message"));
            }
            return Result.error((String)result.getString("message"));
        }
        return Result.error((String)result.getString("message"));
    }

    @ApiOperation(value="\u4f01\u4e1a\u76d1\u6d4b\u5217\u8868\u67e5\u8be2", notes="\u4f01\u4e1a\u76d1\u6d4b\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/enterpriseMonitoringList"})
    @RequiresPermissions(value={"ipaas#srmToIPaas:enterpriseMonitoringList"})
    public Result<?> enterpriseMonitoringList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        JSONObject result;
        JSONObject data = new JSONObject();
        data.put("pageNo", (Object)pageNo);
        data.put("pageSize", (Object)pageSize);
        String companyName = req.getParameter("companyName");
        String order = req.getParameter("order");
        String column = req.getParameter("column");
        if (StringUtils.isNotBlank((CharSequence)companyName)) {
            String[] companies = companyName.split(",");
            data.put("companies", Arrays.asList(companies));
        }
        if (StringUtils.isNotEmpty((CharSequence)column) && column.contains("_")) {
            column = column.split("_")[0];
        }
        if (StringUtils.isNotEmpty((CharSequence)order) && StringUtils.isNotEmpty((CharSequence)column)) {
            data.put("order", (Object)order);
            data.put("column", (Object)column);
        }
        return (result = this.srmToIPaasService.callIPaasInterface(data, "monitoringList")).getBoolean("success") != false ? Result.ok((Object)result.getJSONObject("data")) : Result.error((String)result.getString("message"));
    }

    @ApiOperation(value="\u4f01\u4e1a\u76d1\u6d4b\u53d8\u66f4\u5217\u8868\u67e5\u8be2", notes="\u4f01\u4e1a\u76d1\u6d4b\u53d8\u66f4\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/enterpriseMonitoringChangeList"})
    @RequiresPermissions(value={"ipaas#srmToIPaas:enterpriseMonitoringChangeList"})
    public Result<?> enterpriseMonitoringChangeList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        JSONObject result;
        String companyName;
        JSONObject data = new JSONObject();
        data.put("pageNo", (Object)pageNo);
        data.put("pageSize", (Object)pageSize);
        String dimension = req.getParameter("dimension");
        if (StringUtils.isNotBlank((CharSequence)dimension)) {
            String[] dimensions = dimension.split(",");
            data.put("dimensions", Arrays.asList(dimensions));
        }
        if (StringUtils.isNotBlank((CharSequence)(companyName = req.getParameter("companyName")))) {
            String[] companies = companyName.split(",");
            data.put("companies", Arrays.asList(companies));
        }
        return (result = this.srmToIPaasService.callIPaasInterface(data, "monitoringChangeList")).getBoolean("success") != false ? Result.ok((Object)result.getJSONObject("data")) : Result.error((String)result.getString("message"));
    }
}

