/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.system.entity.ElsTax;
import com.els.modules.system.service.ElsTaxService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="taxImportImpl")
public class TaxImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    private static final Logger log = LoggerFactory.getLogger(TaxImportImpl.class);
    @Autowired
    private ElsTaxService elsTaxService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ArrayList dictCodeList = Lists.newArrayList();
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            String msg;
            Map data = (Map)iterator.next();
            String taxCode = (String)data.get("taxCode");
            if (CharSequenceUtil.isEmpty((CharSequence)taxCode)) {
                String msg2 = I18nUtil.translate((String)"i18n_alert_foxOLV_79b3243", (String)"\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg2, data);
                iterator.remove();
                continue;
            }
            String taxRate = (String)data.get("taxRate");
            if (CharSequenceUtil.isEmpty((CharSequence)taxRate)) {
                String msg3 = I18nUtil.translate((String)"i18n_alert_fIxOLV_c885fac9", (String)"\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg3, data);
                iterator.remove();
                continue;
            }
            BigDecimal taxRateDecimal = new BigDecimal(taxRate);
            if (BigDecimal.ZERO.compareTo(taxRateDecimal) > 0) {
                msg = I18nUtil.translate((String)"i18n_alert_fIRiTWNiiWSiXW_1b417813", (String)"\u7a0e\u7387\u53ea\u5141\u8bb8\u8f93\u5165\u6b63\u6574\u6570\u6216\u6b63\u5c0f\u6570");
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            if (taxRate.length() > 6) {
                msg = I18nUtil.translate((String)"i18n_alert_CcHzxOBRWmJB_febd80b0", (String)"\u5185\u5bb9\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc76\u4e2a\u5b57\u7b26");
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            if (dictCodeList.contains(taxCode + "_" + taxRate)) {
                msg = I18nUtil.translate((String)"i18n_alert_foWWWWWfIWWWWIMK_6d8f1fd0", (String)"\u7a0e\u7801${0}-\u7a0e\u7387${1}\u5df2\u5b58\u5728", (String[])new String[]{taxCode, taxRate});
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            dictCodeList.add(taxCode + "_" + taxRate);
        }
        if (CollUtil.isEmpty((Collection)dictCodeList)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        QueryWrapper wrapper1 = Wrappers.query();
        wrapper1.lambda().select(new SFunction[]{ElsTax::getTaxCode, ElsTax::getTaxRate});
        wrapper1.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        wrapper1.in((Object)"concat(tax_code,'_',tax_rate)", (Collection)dictCodeList);
        Map dbCodeMap = this.elsTaxService.list((Wrapper)wrapper1).stream().collect(Collectors.toMap(x -> x.getTaxCode() + "_" + x.getTaxRate(), Function.identity(), (v1, v2) -> v2));
        ArrayList<ElsTax> addList = new ArrayList<ElsTax>();
        for (Map data : dataList) {
            ElsTax entity = (ElsTax)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), ElsTax.class));
            if (dbCodeMap.containsKey(entity.getTaxCode() + "_" + entity.getTaxRate())) {
                this.errorAdd(excelImportDTO, I18nUtil.translate((String)"i18n_alert_foWWWWWfIWWWWIMK_6d8f1fd0", (String)"\u7a0e\u7801${0}-\u7a0e\u7387${1}\u5df2\u5b58\u5728", (String[])new String[]{entity.getTaxCode(), entity.getTaxRate() + ""}), data);
                continue;
            }
            entity.setElsAccount(TenantContext.getTenant());
            addList.add(entity);
        }
        if (CollectionUtil.isNotEmpty(addList)) {
            this.elsTaxService.saveBatch(addList);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

