/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.els.common.system.vo.DictModel;
import com.els.common.util.ConvertUtils;
import com.els.config.mybatis.TenantContext;
import com.els.framework.dict.service.AutoPoiDictServiceI;
import com.els.modules.system.mapper.DictMapper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutoPoiDictService
implements AutoPoiDictServiceI {
    private static final Logger log = LoggerFactory.getLogger(AutoPoiDictService.class);
    @Autowired
    private DictMapper sysDictMapper;

    @Override
    public String[] queryDict(String dicTable, String dicCode, String dicText) {
        ArrayList<String> dictReplaces = new ArrayList<String>();
        List<DictModel> dictList = null;
        if (ConvertUtils.isEmpty((Object)dicTable)) {
            dictList = this.sysDictMapper.queryDictItemsByCode(dicCode, TenantContext.getTenant());
        } else {
            try {
                dicText = ConvertUtils.getString((String)dicText, (String)dicCode);
                dictList = this.sysDictMapper.queryTableDictItemsByCode(dicTable, dicText, dicCode);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        for (DictModel t : dictList) {
            dictReplaces.add(t.getText() + "_" + t.getValue());
        }
        if (dictReplaces != null && dictReplaces.size() != 0) {
            log.info("---AutoPoi--Get_DB_Dict------" + ((Object)dictReplaces).toString());
            return dictReplaces.toArray(new String[dictReplaces.size()]);
        }
        return null;
    }
}

