/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.util;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.base.api.enumerate.ConnectorMappingTypeEnum;
import com.els.modules.third.vo.JSONConversionVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class JSONParsingUtil {
    public static List<JSONConversionVO> parsing(String json, String jsonGroupCode, String mappingGroupCode, String mappingTable) {
        List<JSONConversionVO> conversions = new ArrayList<JSONConversionVO>();
        mappingGroupCode = CharSequenceUtil.emptyToDefault((CharSequence)mappingGroupCode, (String)"");
        mappingTable = CharSequenceUtil.emptyToDefault((CharSequence)mappingTable, (String)ConnectorMappingTypeEnum.HEAD.getValue());
        JSONParsingUtil.conversion(jsonGroupCode, mappingGroupCode, JSONObject.parseObject((String)json), conversions, mappingTable);
        conversions = conversions.stream().sorted(Comparator.comparingInt(x -> CharSequenceUtil.split((CharSequence)x.getInterfaceFieldGroupCode(), (CharSequence)".").size())).sorted(Comparator.comparingInt(x -> x.getInterfaceFieldGroupCode().length())).collect(Collectors.toList());
        return conversions;
    }

    private static void conversion(String jsonGroupCode, String targetGroupCode, JSONObject object, List<JSONConversionVO> conversions, String mappingTable) {
        for (String fieldName : object.keySet()) {
            String loopGroupCode;
            Object o = object.get((Object)fieldName);
            if (o instanceof JSONObject) {
                String string = loopGroupCode = CharSequenceUtil.isEmpty((CharSequence)jsonGroupCode) ? fieldName + "." : jsonGroupCode + fieldName + ".";
                if (ConnectorMappingTypeEnum.ITEM.getValue().equals(mappingTable)) {
                    JSONParsingUtil.conversion(loopGroupCode, targetGroupCode, (JSONObject)o, conversions, ConnectorMappingTypeEnum.ITEM_OBJ_ITEM_OBJ.getValue());
                    continue;
                }
                JSONParsingUtil.conversion(loopGroupCode, targetGroupCode, (JSONObject)o, conversions, ConnectorMappingTypeEnum.OBJ.getValue());
                continue;
            }
            if (o instanceof Collection) {
                String string = loopGroupCode = CharSequenceUtil.isEmpty((CharSequence)jsonGroupCode) ? fieldName + "." : jsonGroupCode + fieldName + ".";
                List objectList = JSONArray.parseArray((String)JSON.toJSONString((Object)o), JSONObject.class);
                if (objectList.isEmpty()) continue;
                JSONObject jsonObject = (JSONObject)objectList.stream().sorted(Comparator.comparingInt(x -> x.keySet().size())).collect(Collectors.toList()).get(objectList.size() - 1);
                JSONParsingUtil.conversion(loopGroupCode, targetGroupCode, jsonObject, conversions, ConnectorMappingTypeEnum.ITEM.getValue());
                continue;
            }
            String temGroupCode = jsonGroupCode;
            if (jsonGroupCode.endsWith(".")) {
                temGroupCode = jsonGroupCode.substring(0, jsonGroupCode.length() - 1);
            }
            JSONConversionVO vo = new JSONConversionVO();
            vo.setInterfaceField(fieldName);
            vo.setInterfaceFieldGroupCode(temGroupCode);
            vo.setFieldType("string");
            vo.setMappingField(fieldName);
            vo.setMappingTable(mappingTable);
            if (CharSequenceUtil.isNotEmpty((CharSequence)targetGroupCode)) {
                vo.setMappingGroupCode(CharSequenceUtil.isEmpty((CharSequence)temGroupCode) ? targetGroupCode : targetGroupCode + "." + temGroupCode);
            } else {
                vo.setMappingGroupCode(temGroupCode);
            }
            vo.setConversion("1");
            vo.setRequired("0");
            vo.setUseDefault("0");
            conversions.add(vo);
        }
    }
}

