/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.history.rocketMq.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.els.common.util.SpringContextUtils;
import com.els.config.StaticConfig;
import com.els.modules.history.entity.ElsInitialTable;
import com.els.modules.history.service.ElsInitialTableService;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;

@Component
public class InitTableConsumer {
    private static final Logger log = LoggerFactory.getLogger(InitTableConsumer.class);
    @Autowired
    private ElsInitialTableService elsInitialTableService;

    @Bean(value={"inputInit"})
    public Consumer<Message<String>> receive() {
        return message -> {
            String msgBody = (String)message.getPayload();
            try {
                String dianchiPurchaseAccount;
                if (StringUtils.isBlank((CharSequence)msgBody)) {
                    return;
                }
                String mqElsAccount = (String)message.getHeaders().get((Object)"mqElsAccount");
                if (mqElsAccount.equals(dianchiPurchaseAccount = (String)((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig().get("dianchiPurchaseAccount"))) {
                    DynamicDataSourceContextHolder.push((String)"dianchi");
                } else {
                    DynamicDataSourceContextHolder.push((String)"master");
                }
                JSONObject body = JSONObject.parseObject((String)msgBody);
                ElsInitialTable table = (ElsInitialTable)((Object)((Object)JSONObject.toJavaObject((JSON)body, ElsInitialTable.class)));
                if (StringUtils.isNotBlank((CharSequence)table.getRelationId()) && StringUtils.isNotBlank((CharSequence)table.getBusinessInfoJson())) {
                    log.info("mqElsAccount:" + mqElsAccount + "msgBody: " + msgBody);
                    this.elsInitialTableService.saveElsInitialTable(table);
                }
            }
            catch (Exception e) {
                log.error("InitTableConsumer_receive_msgBody:" + msgBody, (Throwable)e);
                throw e;
            }
            finally {
                DynamicDataSourceContextHolder.clear();
            }
        };
    }
}

