/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.email;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.api.dto.ElsEmailConfigDTO;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.enumerate.MailProtocolType;
import com.els.modules.email.EmailSenderCacheExtendManager;
import com.els.modules.email.sender.CommonMailExtendSender;
import com.els.modules.email.sender.ElsMailExtendSender;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.credential.ExchangeCredentials;
import microsoft.exchange.webservices.data.credential.WebCredentials;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class ElsEmailExtendBuilder {
    private static final Logger log = LoggerFactory.getLogger(ElsEmailExtendBuilder.class);

    public static boolean sendEmail(ElsEmailConfigDTO config, String to, String subject, String content, String cc, boolean needCc) {
        config.setContent(content);
        config.setEmailCc(cc);
        config.setNeedCc(needCc);
        config.setSubject(subject);
        config.setTo(new String[]{to});
        LoginUser loginUser = SysUtil.getLoginUser();
        if (null != loginUser && CharSequenceUtil.isEmpty((CharSequence)config.getCurrentElsAccount())) {
            config.setCurrentElsAccount(loginUser.getElsAccount());
        }
        ElsMailExtendSender mailSender = ElsEmailExtendBuilder.buildElsMailSender(config, null, null);
        return mailSender.sendEmail(config, null);
    }

    public static void sendEmailWithEp(ElsEmailConfigDTO config, String to, String subject, String content, String cc, boolean needCc) {
        config.setContent(content);
        config.setEmailCc(cc);
        config.setNeedCc(needCc);
        config.setSubject(subject);
        config.setTo(new String[]{to});
        LoginUser loginUser = SysUtil.getLoginUser();
        if (null != loginUser && CharSequenceUtil.isEmpty((CharSequence)config.getCurrentElsAccount())) {
            config.setCurrentElsAccount(loginUser.getElsAccount());
        }
        ElsMailExtendSender mailSender = ElsEmailExtendBuilder.buildElsMailSender(config, null, null);
        mailSender.sendEmailWithThrowException(config, null);
    }

    public static ElsMailExtendSender buildElsMailSender(ElsEmailConfigDTO config, Properties properties, BiConsumer<ElsEmailConfigDTO, Object> enhanceBuilder) {
        String key;
        ElsMailExtendSender<MimeMessageHelper> sender;
        MailProtocolType protocolType = MailProtocolType.buildMailProtocolType((String)config.getType());
        if (null == protocolType) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u4e0d\u652f\u6301${0}\u90ae\u7bb1\u534f\u8bae\u914d\u7f6e", (String[])new String[]{config.getType()}));
        }
        HashMap<String, String> prop = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)config.getProps())) {
            JSONObject map = (JSONObject)JSON.parseObject((String)config.getProps(), JSONObject.class);
            prop = new HashMap();
            for (String k : map.keySet()) {
                prop.put(k, map.getString(k));
            }
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)config.getElsAccount()) && null == enhanceBuilder && null != (sender = EmailSenderCacheExtendManager.get(key = config.getElsAccount() + "_" + config.getEmailHost() + "_" + config.getEmailUsername() + "_" + protocolType.getType()))) {
            return sender;
        }
        switch (protocolType) {
            case imap: 
            case pop3: 
            case smtp: {
                sender = new CommonMailExtendSender(ElsEmailExtendBuilder.buildJavaMailSender(config, prop, enhanceBuilder));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u4e0d\u652f\u6301${0}\u90ae\u7bb1\u534f\u8bae\u914d\u7f6e", (String[])new String[]{config.getType()}));
            }
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)config.getElsAccount()) && null == enhanceBuilder) {
            key = config.getElsAccount() + "_" + config.getEmailHost() + "_" + config.getEmailUsername() + "_" + protocolType.getType();
            EmailSenderCacheExtendManager.put(key, sender);
        }
        return sender;
    }

    public static JavaMailSender buildJavaMailSender(ElsEmailConfigDTO config, Map<String, String> prop) {
        return ElsEmailExtendBuilder.buildJavaMailSender(config, prop, null);
    }

    public static JavaMailSender buildJavaMailSender(final ElsEmailConfigDTO config, Map<String, String> prop, BiConsumer<ElsEmailConfigDTO, Object> emailSenderEnhanceBuilder) {
        Properties defaultProperties = MailProtocolType.buildDefaultProperties((ElsEmailConfigDTO)config, (boolean)config.getType().equals(config.getProtocol() + "s"), null);
        for (String key : prop.keySet()) {
            defaultProperties.put(key, prop.get(key));
        }
        ElsEmailExtendBuilder.configCheck(config);
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setProtocol(CharSequenceUtil.isEmpty((CharSequence)config.getProtocol()) ? "stmp" : config.getProtocol());
        sender.setHost(config.getEmailHost());
        sender.setUsername(config.getEmailUsername());
        sender.setPassword(config.getEmailPassword());
        sender.setPort(null == config.getEmailPort() ? 25 : config.getEmailPort());
        sender.setDefaultEncoding("UTF-8");
        String userName = config.getEmailUsername();
        if (userName.contains("@cimc-raffles.com")) {
            userName = userName.substring(0, userName.indexOf("@"));
        }
        final String finalUserName = userName;
        log.info("finalUserName:" + finalUserName);
        Session session = Session.getInstance((Properties)defaultProperties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(finalUserName, config.getEmailPassword());
            }
        });
        session.setDebug(true);
        sender.setJavaMailProperties(defaultProperties);
        sender.setSession(session);
        if (null != emailSenderEnhanceBuilder) {
            emailSenderEnhanceBuilder.accept(config, sender);
        }
        return sender;
    }

    public static ExchangeService buildExchangeServiceSender(ElsEmailConfigDTO config, Map<String, String> prop) {
        return ElsEmailExtendBuilder.buildExchangeServiceSender(config, prop, null);
    }

    public static ExchangeService buildExchangeServiceSender(ElsEmailConfigDTO config, Map<String, String> prop, BiConsumer<ElsEmailConfigDTO, Object> emailSenderEnhanceBuilder) {
        ElsEmailExtendBuilder.configCheck(config);
        ExchangeVersion exchangeVersion = ExchangeVersion.Exchange2010;
        if (null != config.getExchangeVersion()) {
            exchangeVersion = ExchangeVersion.valueOf((String)config.getExchangeVersion().name());
        }
        try {
            ExchangeService exchangeService = new ExchangeService(exchangeVersion);
            WebCredentials exchangeCredentials = new WebCredentials(config.getEmailUsername(), config.getEmailPassword(), CharSequenceUtil.isEmpty((CharSequence)config.getDomain()) ? "" : config.getDomain());
            exchangeService.setCredentials((ExchangeCredentials)exchangeCredentials);
            exchangeService.setUrl(new URI("https://" + config.getEmailHost() + "/ews/Exchange.asmx"));
            if (null != emailSenderEnhanceBuilder) {
                emailSenderEnhanceBuilder.accept(config, exchangeService);
            }
            return exchangeService;
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage());
        }
    }

    private static void configCheck(ElsEmailConfigDTO config) {
        if (null == config) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u90ae\u4ef6\u53d1\u9001\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a))"));
        }
        if (StringUtils.isEmpty((CharSequence)config.getEmailUsername()) || StringUtils.isEmpty((CharSequence)config.getEmailPassword())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u90ae\u4ef6\u53d1\u9001\u8005\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a))"));
        }
        if (StringUtils.isEmpty((CharSequence)config.getEmailHost())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u90ae\u4ef6\u53d1\u9001host\u4e0d\u80fd\u4e3a\u7a7a))"));
        }
        if (StringUtils.isEmpty((CharSequence)config.getType())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u90ae\u4ef6\u53d1\u9001\u534f\u8baetype\u4e0d\u80fd\u4e3a\u7a7a))"));
        }
    }

    private static void applyProperties(MailProperties properties, JavaMailSenderImpl sender) {
        sender.setHost(properties.getHost());
        if (properties.getPort() != null) {
            sender.setPort(properties.getPort().intValue());
        }
        sender.setUsername(properties.getUsername());
        sender.setPassword(properties.getPassword());
        if (properties.getDefaultEncoding() != null) {
            sender.setDefaultEncoding(properties.getDefaultEncoding().name());
        }
        if (!properties.getProperties().isEmpty()) {
            sender.setJavaMailProperties(ElsEmailExtendBuilder.asProperties(properties.getProperties()));
        }
    }

    private static Properties asProperties(Map<String, String> source) {
        Properties properties = new Properties();
        properties.putAll(source);
        return properties;
    }

    public static void main(String[] args) {
        ElsMailExtendSender sender = ElsEmailExtendBuilder.buildElsMailSender(null, null, null);
    }
}

