/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.email.sender;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.els.api.dto.ElsEmailConfigDTO;
import com.els.common.exception.ELSBootException;
import com.els.modules.base.api.enumerate.MailProtocolType;
import com.els.modules.email.EmailSenderCacheExtendManager;
import com.els.modules.email.sender.AbstractElsMailExtendSender;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class CommonMailExtendSender
extends AbstractElsMailExtendSender<MimeMessageHelper> {
    private static final Logger log = LoggerFactory.getLogger(CommonMailExtendSender.class);
    private final JavaMailSender sender;

    @Override
    protected List<MailProtocolType> supportType() {
        return Lists.newArrayList((Object[])new MailProtocolType[]{MailProtocolType.smtp, MailProtocolType.pop3, MailProtocolType.imap});
    }

    public CommonMailExtendSender(JavaMailSender sender) {
        this.sender = sender;
    }

    @Override
    protected AbstractElsMailExtendSender.SendResult doSendEmail(ElsEmailConfigDTO config, BiFunction<ElsEmailConfigDTO, MimeMessageHelper, MimeMessageHelper> messageEnhancer) {
        AbstractElsMailExtendSender.SendResult sendResult;
        block2: {
            sendResult = new AbstractElsMailExtendSender.SendResult();
            try {
                this.doSendEmailWithThrowException(config, messageEnhancer);
                sendResult.setResult(true);
            }
            catch (Exception e) {
                sendResult.setResult(false);
                if (!CharSequenceUtil.isNotEmpty((CharSequence)config.getElsAccount()) || null != messageEnhancer) break block2;
                String key = config.getElsAccount() + "_" + config.getEmailHost() + "_" + config.getEmailUsername() + "_" + config.getType();
                EmailSenderCacheExtendManager.remove(key);
            }
        }
        return sendResult;
    }

    @Override
    protected void doSendEmailWithThrowException(ElsEmailConfigDTO config, BiFunction<ElsEmailConfigDTO, MimeMessageHelper, MimeMessageHelper> messageEnhancer) {
        MimeMessage message = this.sender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setTo(config.getTo());
            helper.setSubject(config.getSubject());
            helper.setFrom(config.getEmailUsername());
            log.info("\u6267\u884c\u91cd\u5199\u53d1\u9001email\u65b9\u6cd5\uff1adoSendEmailWithThrowException");
            if (BooleanUtil.isTrue((Boolean)config.isNeedCc()) && StrUtil.isNotEmpty((CharSequence)config.getEmailCc())) {
                helper.setCc(config.getEmailCc().split(","));
            }
            if (null != config.getBcc() && config.getBcc().length > 0) {
                helper.setBcc(config.getBcc());
            }
            if (null != config.getAttachmentFiles() && config.getAttachmentFiles().length > 0) {
                for (File file : config.getAttachmentFiles()) {
                    helper.addAttachment(file.getName(), file);
                }
            }
            if (CollUtil.isNotEmpty((Map)config.getInlineMap())) {
                for (String documentId : config.getInlineMap().keySet()) {
                    try {
                        helper.addInline(documentId, (File)config.getInlineMap().get(documentId));
                    }
                    catch (Exception e) {
                        throw new ELSBootException(e.getMessage());
                    }
                }
            }
            helper.setText(config.getContent(), true);
            if (null != messageEnhancer) {
                helper = messageEnhancer.apply(config, helper);
            }
            this.sender.send(message);
        }
        catch (Exception e) {
            log.error("CommonMailSender==>\u53d1\u9001\u90ae\u4ef6\u5931\u8d25:{}", (Object)e.getMessage());
            throw new ELSBootException(e.getMessage());
        }
    }
}

