/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.translate.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.translate.dto.TencentTranslateDto;
import com.tencentcloudapi.asr.v20190614.AsrClient;
import com.tencentcloudapi.asr.v20190614.models.SentenceRecognitionRequest;
import com.tencentcloudapi.asr.v20190614.models.SentenceRecognitionResponse;
import com.tencentcloudapi.common.AbstractModel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.jaudiotagger.audio.mp3.MP3File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class TencentUtils {
    private static final Logger log = LoggerFactory.getLogger(TencentUtils.class);
    private final AsrClient client;

    public TencentUtils(AsrClient asrClient) {
        this.client = asrClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int computeFileLength(MultipartFile uploadFile) {
        File temFile = null;
        try {
            temFile = this.transferToFile(uploadFile);
            if (null == temFile) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8bed\u97f3\u6587\u4ef6\u5f02\u5e38"));
            }
            MP3File file = new MP3File(temFile);
            MP3AudioHeader audioHeader = (MP3AudioHeader)file.getAudioHeader();
            int n = audioHeader.getTrackLength();
            return n;
        }
        catch (Exception e) {
            log.error(":::\u6587\u4ef6\u5f02\u5e38==>{}", (Object)e.getMessage());
            int n = 70;
            return n;
        }
        finally {
            if (null != temFile) {
                temFile.deleteOnExit();
            }
        }
    }

    private File transferToFile(MultipartFile multipartFile) {
        File file = null;
        try {
            String originalFilename = multipartFile.getOriginalFilename();
            String[] filename = originalFilename.split("\\.");
            file = File.createTempFile(filename[0], filename[1]);
            multipartFile.transferTo(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public String audioToText(String base64text, Integer dataLength, TencentTranslateDto translateDto) {
        String identificationResults = null;
        try {
            HashMap<String, Object> postParam = new HashMap<String, Object>();
            postParam.put("Action", "SentenceRecognition");
            postParam.put("Version", "2019-06-14");
            postParam.put("ProjectId", 0);
            postParam.put("SubServiceType", ObjectUtil.defaultIfNull((Object)translateDto.getSubServiceType(), (Object)2));
            postParam.put("EngSerViceType", StrUtil.blankToDefault((CharSequence)translateDto.getEngSerViceType(), (String)"16k_zh"));
            postParam.put("SourceType", 1);
            postParam.put("VoiceFormat", StrUtil.blankToDefault((CharSequence)translateDto.getVoiceFormat(), (String)"mp3"));
            postParam.put("UsrAudioKey", IdWorker.getIdStr());
            postParam.put("Data", base64text);
            postParam.put("DataLen", dataLength);
            postParam.put("FilterDirty", ObjectUtil.defaultIfNull((Object)translateDto.getFilterDirty(), (Object)0));
            postParam.put("FilterModal", ObjectUtil.defaultIfNull((Object)translateDto.getFilterModal(), (Object)0));
            postParam.put("FilterPunc", ObjectUtil.defaultIfNull((Object)translateDto.getFilterPunc(), (Object)0));
            postParam.put("ConvertNumMode", ObjectUtil.defaultIfNull((Object)translateDto.getConvertNumMode(), (Object)0));
            postParam.put("WordInfo", ObjectUtil.defaultIfNull((Object)translateDto.getWordInfo(), (Object)0));
            SentenceRecognitionRequest req = (SentenceRecognitionRequest)SentenceRecognitionRequest.fromJsonString((String)JSON.toJSONString(postParam), SentenceRecognitionRequest.class);
            SentenceRecognitionResponse resp = this.client.SentenceRecognition(req);
            identificationResults = SentenceRecognitionRequest.toJsonString((AbstractModel)resp);
        }
        catch (Exception e) {
            log.error(":::\u4e0a\u4f20\u6587\u4ef6\u8f6c\u8bed\u97f3\u51fa\u9519===>{}", (Object)e.getMessage());
        }
        return identificationResults;
    }
}

