/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.oss.service.impl;

import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.oss.service.IAttachmnetService;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.template.util.ConfigPageGeneJsUtil;
import com.els.modules.template.vo.TemplateHeadVO;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="localFileServiceImpl")
public class LocalFileServiceImpl
implements IAttachmnetService {
    private static final Logger log = LoggerFactory.getLogger(LocalFileServiceImpl.class);
    @Value(value="${els.path.upload}")
    private String uploadpath;
    private static final String STR_SPLIT = "_";
    private static final String STR_DOT = ".";
    private static final String STR_FORMAT = "yyyyMMdd";
    @Autowired
    private PurchaseAttachmentService purchaseAttachmentService;

    @Override
    public String uploadFile(MultipartFile uploadFile, String remotePath) throws IOException {
        String bizPath = "files";
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
        String nowDay = dtf.format(time);
        String elsAccount = TenantContext.getTenant();
        File file = new File(this.uploadpath + File.separator + bizPath + File.separator + elsAccount + File.separator + nowDay);
        if (!file.exists()) {
            file.mkdirs();
        }
        File savefile = new File(remotePath);
        FileCopyUtils.copy((byte[])uploadFile.getBytes(), (File)savefile);
        return remotePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFile(OutputStream outputStream, String filePath) throws Exception {
        File file = new File(filePath);
        Assert.isTrue((boolean)file.exists(), (String)I18nUtil.translate((String)"", (String)"\u9644\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664"));
        InputStream inputStream = null;
        try {
            int len;
            inputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                outputStream.write(buf, 0, len);
            }
            outputStream.flush();
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
        }
    }

    @Override
    public void delete(String id) {
    }

    @Override
    public void deleteBatch(List<String> ids) {
    }

    @Override
    public void generatorJs(String savePathDir, TemplateHeadVO headVO) {
        log.info("generatorJs in local------------");
        ConfigPageGeneJsUtil.generatorJs(savePathDir, headVO);
    }

    @Override
    public String uploadFile(byte[] bytes, String remothPath, String documentName) throws IOException {
        String bizPath = "files";
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
        String nowDay = dtf.format(time);
        String elsAccount = TenantContext.getTenant();
        File file = new File(this.uploadpath + File.separator + bizPath + File.separator + elsAccount + File.separator + nowDay);
        if (!file.exists()) {
            file.mkdirs();
        }
        File savefile = new File(remothPath);
        FileCopyUtils.copy((byte[])bytes, (File)savefile);
        return remothPath;
    }
}

