/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.template.util;

import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.template.util.FreeMarkerTemplateUtils;
import com.els.modules.template.vo.TemplateHeadVO;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.springframework.util.Assert;

public class ConfigPageGeneJsUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean generatorJs(String dirPath, TemplateHeadVO headVO) {
        FileOutputStream fosPur = null;
        FileOutputStream fosSup = null;
        try {
            File fileDir = new File(dirPath);
            if (!fileDir.exists()) {
                Assert.isTrue((boolean)fileDir.mkdirs(), (String)I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u521b\u5efa\u5931\u8d25"));
            }
            HashMap<String, TemplateHeadVO> map = new HashMap<String, TemplateHeadVO>(128);
            map.put("data", headVO);
            String filePurName = "purchase_" + headVO.getBusinessType() + "_" + headVO.getTemplateNumber() + "_" + headVO.getTemplateVersion() + ".js";
            File savePurFile = new File(dirPath + File.separator, FilenameUtils.getName((String)filePurName));
            if (savePurFile.exists()) {
                Assert.isTrue((boolean)savePurFile.delete(), (String)I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u5220\u9664\u5931\u8d25"));
            }
            Template purTemp = FreeMarkerTemplateUtils.getTemplate("js-code-pur.ftl");
            fosPur = new FileOutputStream(savePurFile);
            BufferedWriter bfwPur = new BufferedWriter(new OutputStreamWriter((OutputStream)fosPur, StandardCharsets.UTF_8));
            purTemp.process(map, (Writer)bfwPur);
            bfwPur.flush();
            String filePurAduitName = "purchase_aduit_" + headVO.getBusinessType() + "_" + headVO.getTemplateNumber() + "_" + headVO.getTemplateVersion() + ".js";
            File savePurAduitFile = new File(dirPath + File.separator, FilenameUtils.getName((String)filePurAduitName));
            if (savePurAduitFile.exists()) {
                Assert.isTrue((boolean)savePurAduitFile.delete(), (String)I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u5220\u9664\u5931\u8d25"));
            }
            Template purAduitTemp = FreeMarkerTemplateUtils.getTemplate("js-code-pur-aduit.ftl");
            fosPur = new FileOutputStream(savePurAduitFile);
            BufferedWriter bfwPurAduit = new BufferedWriter(new OutputStreamWriter((OutputStream)fosPur, StandardCharsets.UTF_8));
            purAduitTemp.process(map, (Writer)bfwPurAduit);
            bfwPurAduit.flush();
            String fileSupName = "sale_" + headVO.getBusinessType() + "_" + headVO.getTemplateNumber() + "_" + headVO.getTemplateVersion() + ".js";
            File saveSupFile = new File(dirPath + File.separator, FilenameUtils.getName((String)fileSupName));
            if (saveSupFile.exists()) {
                Assert.isTrue((boolean)saveSupFile.delete(), (String)I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u5220\u9664\u5931\u8d25"));
            }
            Template supTemp = FreeMarkerTemplateUtils.getTemplate("js-code-sup.ftl");
            try {
                fosSup = new FileOutputStream(saveSupFile);
                BufferedWriter bfwSup = new BufferedWriter(new OutputStreamWriter((OutputStream)fosSup, StandardCharsets.UTF_8));
                supTemp.process(map, (Writer)bfwSup);
                bfwSup.flush();
            }
            finally {
                if (null != fosSup) {
                    fosSup.close();
                }
            }
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)e.getMessage()));
        }
        finally {
            try {
                if (fosPur != null) {
                    fosPur.close();
                }
                if (fosSup != null) {
                    fosSup.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public static void main(String[] args) throws IOException, TemplateException {
        Template t = FreeMarkerTemplateUtils.getTemplate("js-code.ftl");
        HashMap<String, String> map = new HashMap<String, String>(128);
        map.put("table_name_small", "dd");
        t.process(map, (Writer)new OutputStreamWriter(System.out));
    }
}

