/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.storage.spi;

import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.spi.StorageSpi;
import com.qcloud.cos.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public abstract class AbstractStorageSpi
implements StorageSpi {
    private static final Logger log = LoggerFactory.getLogger(AbstractStorageSpi.class);
    public static final String BEAN_NAME_SUF = "StorageSpi";

    @Override
    public Resource loadAsResource(OutputStream outputStream, String filePath) {
        try {
            URL url;
            UrlResource resource;
            if (filePath.startsWith(File.separator)) {
                filePath = filePath.substring(1);
            }
            if ((resource = new UrlResource(url = new URL(this.getBaseUrl() + filePath))).exists() || resource.isReadable()) {
                return resource;
            }
            log.error(":::\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b[{}]\u6587\u4ef6{}\u4e0d\u5b58\u5728\u6216\u8005\u65e0\u53ef\u8bfb\u6743\u9650", (Object)this.type(), (Object)filePath);
            return resource;
        }
        catch (Exception e) {
            log.error(":::\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b[{}]\u8bfb\u53d6\u6587\u4ef6{}\u5f02\u5e38:{}", new Object[]{this.type(), filePath, e.getMessage()});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFileWithOutput(OutputStream outputStream, String filePath) {
        Resource resource = this.loadAsResource(outputStream, filePath);
        if (null == resource) {
            throw new ELSBootException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        try {
            InputStream inputStream = resource.getInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            outputStream.write(bytes, 0, bytes.length);
            outputStream.flush();
        }
        catch (Exception e) {
            log.error(":::\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                log.error(":::\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38:{}", (Object)e.getMessage());
            }
        }
    }

    public String contentType(String FilenameExtension) {
        if (FilenameExtension.contains("BMP") || FilenameExtension.contains("bmp")) {
            return "image/bmp";
        }
        if (FilenameExtension.contains("GIF") || FilenameExtension.contains("gif")) {
            return "image/gif";
        }
        if (FilenameExtension.contains("JPEG") || FilenameExtension.contains("jpeg") || FilenameExtension.contains("JPG") || FilenameExtension.contains("jpg") || FilenameExtension.contains("PNG") || FilenameExtension.contains("png")) {
            return "image/jpeg";
        }
        if (FilenameExtension.contains("HTML") || FilenameExtension.contains("html")) {
            return "text/html";
        }
        if (FilenameExtension.contains("TXT") || FilenameExtension.contains("txt")) {
            return "text/plain";
        }
        if (FilenameExtension.contains("VSD") || FilenameExtension.contains("vsd")) {
            return "application/vnd.visio";
        }
        if (FilenameExtension.contains("PPTX") || FilenameExtension.contains("pptx") || FilenameExtension.contains("PPT") || FilenameExtension.contains("ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (FilenameExtension.contains("DOCX") || FilenameExtension.contains("docx") || FilenameExtension.contains("DOC") || FilenameExtension.contains("doc")) {
            return "application/msword";
        }
        if (FilenameExtension.contains("XML") || FilenameExtension.contains("xml")) {
            return "text/xml";
        }
        if (FilenameExtension.contains("js") || FilenameExtension.contains("JS")) {
            return "application/x-javascript";
        }
        return "text/html";
    }

    @Override
    public String loadDownloadSafePath(StorageFileInfo fileInfo) {
        return this.loadDownloadPath(fileInfo.getPath());
    }

    @Override
    public InputStream downloadFileWithInputStream(String filePath) {
        try {
            URL url;
            UrlResource resource;
            if (filePath.startsWith(File.separator)) {
                filePath = filePath.substring(1);
            }
            if ((resource = new UrlResource(url = new URL(this.getBaseUrl() + filePath))).exists() || resource.isReadable()) {
                return resource.getInputStream();
            }
            log.error(":::\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b[{}]\u6587\u4ef6{}\u4e0d\u5b58\u5728\u6216\u8005\u65e0\u53ef\u8bfb\u6743\u9650", (Object)this.type(), (Object)filePath);
        }
        catch (Exception e) {
            log.error(":::\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b[{}]\u8bfb\u53d6\u6587\u4ef6{}\u5f02\u5e38:{}", new Object[]{this.type(), filePath, e.getMessage()});
        }
        throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38"));
    }
}

