/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.portal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseDTO;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.portal.entity.PurchasePortalManagement;
import com.els.modules.portal.mapper.PurchasePortalManagementMapper;
import com.els.modules.portal.service.PurchasePortalManagementService;
import com.els.modules.portal.vo.PurchasePortalManagementVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchasePortalManagementServiceImpl
extends BaseServiceImpl<PurchasePortalManagementMapper, PurchasePortalManagement>
implements PurchasePortalManagementService {
    @Resource
    private PurchasePortalManagementMapper purchasePortalManagementMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void savePurchasePortalManagement(PurchasePortalManagement purchasePortalManagement) {
        purchasePortalManagement.setDeleted(CommonConstant.DEL_FLAG_0);
        ((PurchasePortalManagementMapper)this.baseMapper).insert((Object)purchasePortalManagement);
    }

    @Override
    public void updatePurchasePortalManagement(PurchasePortalManagement purchasePortalManagement) {
        purchasePortalManagement.setDeleted(CommonConstant.DEL_FLAG_0);
        ((PurchasePortalManagementMapper)this.baseMapper).updateById((Object)purchasePortalManagement);
    }

    @Override
    public void delPurchasePortalManagement(String id) {
        ((PurchasePortalManagementMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchasePortalManagement(List<String> idList) {
        ((PurchasePortalManagementMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<PurchasePortalManagement> addBatch(PurchasePortalManagementVO purchasePortalManagementVO) {
        List<PurchasePortalManagement> list = purchasePortalManagementVO.getPortalManagementList();
        if (!CollectionUtils.isEmpty(list)) {
            List<PurchasePortalManagement> addList = list.stream().filter(var -> StringUtils.isBlank((CharSequence)var.getId())).collect(Collectors.toList());
            List<PurchasePortalManagement> updateList = list.stream().filter(var -> StringUtils.isNotBlank((CharSequence)var.getId())).collect(Collectors.toList());
            ArrayList<PurchasePortalManagement> allList = new ArrayList<PurchasePortalManagement>();
            List<Object> addIdList = new ArrayList();
            if (!CollectionUtils.isEmpty(addList)) {
                this.saveBatch(addList);
                addIdList = addList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                allList.addAll(addList);
            }
            if (!CollectionUtils.isEmpty(updateList)) {
                List idList = updateList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                idList.addAll(addIdList);
                if (!CollectionUtils.isEmpty(idList)) {
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.notIn(BaseEntity::getId, idList);
                    updateWrapper.set(BaseEntity::getDeleted, (Object)"1");
                    this.update((Wrapper)updateWrapper);
                    for (String deleteId : idList) {
                        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(deleteId);
                    }
                }
                addList.forEach(var -> var.setDeleted(CommonConstant.DEL_FLAG_0));
                updateList.forEach(var -> var.setDeleted(CommonConstant.DEL_FLAG_0));
                this.updateBatchById(updateList);
                allList.addAll(updateList);
            }
            if (!CollectionUtils.isEmpty(allList)) {
                for (PurchasePortalManagement var2 : allList) {
                    List<PurchaseAttachment> purchaseAttachmentList = var2.getAttachments();
                    if (CollectionUtils.isEmpty(purchaseAttachmentList)) continue;
                    ArrayList attachments = SysUtil.copyProperties(purchaseAttachmentList, PurchaseAttachmentDTO.class);
                    for (PurchaseAttachmentDTO attachment : attachments) {
                        attachment.setId(null);
                        attachment.setHeadId(var2.getId());
                        attachment.setRelationId(IdWorker.getIdStr());
                        attachment.setUploadElsAccount(var2.getElsAccount());
                        attachment.setBusinessType("portalManagement");
                        attachment.setSendStatus("0");
                        SysUtil.setSysParam((BaseDTO)attachment, (BaseEntity)var2);
                    }
                    this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn((List)attachments);
                }
            }
            return allList;
        }
        return null;
    }

    @Override
    public List<PurchasePortalManagement> listNoToken(QueryWrapper<PurchasePortalManagement> queryWrapper) {
        return this.purchasePortalManagementMapper.listNoToken(queryWrapper);
    }
}

