/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.dingtalkim_1_0.Client;
import com.aliyun.dingtalkim_1_0.models.SendRobotInteractiveCardHeaders;
import com.aliyun.dingtalkim_1_0.models.SendRobotInteractiveCardRequest;
import com.aliyun.dingtalkoauth2_1_0.models.GetAccessTokenRequest;
import com.aliyun.dingtalkoauth2_1_0.models.GetAccessTokenResponse;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import com.els.modules.order.api.service.ElsSubAccountNewRpcService;
import com.els.modules.system.enums.DINGInitializeAccountEnum;
import com.els.modules.system.enums.SrmInterfaceCodeEnum;
import com.els.modules.system.service.DINGInitializaAccountService;
import com.els.modules.system.util.SrmCallInterfaceUtil;
import com.els.modules.system.vo.DINGGInitializeAccountVo;
import com.els.modules.system.vo.ReturnSRMBaseVO;
import com.els.modules.system.vo.SRMRequestBaseVO;
import com.els.rpc.service.InvokeAccountRpcService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DINGInitializeAccount
implements DINGInitializaAccountService {
    private static final Logger log = LoggerFactory.getLogger(DINGInitializeAccount.class);
    @Value(value="${dingdingSetting.appKey}")
    private String appKey;
    @Value(value="${dingdingSetting.appSecret}")
    private String appSecret;
    @Value(value="${dingdingSetting.robotCode}")
    private String robotCode;
    @Autowired
    private SrmCallInterfaceUtil srmCallInterfaceUtil;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private ElsSubAccountNewRpcService elsSubAccountNewRpcService;

    public static Client createClient() throws Exception {
        Config config = new Config();
        config.protocol = "https";
        config.regionId = "central";
        return new Client(config);
    }

    public static com.aliyun.dingtalkoauth2_1_0.Client createClientT() throws Exception {
        Config config = new Config();
        config.protocol = "https";
        config.regionId = "central";
        return new com.aliyun.dingtalkoauth2_1_0.Client(config);
    }

    @Override
    public void sendMsgDingTalk(DINGGInitializeAccountVo dINGGInitializeAccountVo) throws Exception {
        block7: {
            Client client = DINGInitializeAccount.createClient();
            com.aliyun.dingtalkoauth2_1_0.Client clientT = DINGInitializeAccount.createClientT();
            GetAccessTokenRequest getAccessTokenRequest = new GetAccessTokenRequest().setAppKey(this.appKey).setAppSecret(this.appSecret);
            GetAccessTokenResponse getAccessTokenResponse = clientT.getAccessToken(getAccessTokenRequest);
            SendRobotInteractiveCardHeaders sendRobotInteractiveCardHeaders = new SendRobotInteractiveCardHeaders();
            sendRobotInteractiveCardHeaders.xAcsDingtalkAccessToken = getAccessTokenResponse.body.getAccessToken();
            SendRobotInteractiveCardRequest.SendRobotInteractiveCardRequestSendOptions sendOptions = new SendRobotInteractiveCardRequest.SendRobotInteractiveCardRequestSendOptions().setAtAll(Boolean.valueOf(false));
            HashMap<String, String> map = new HashMap<String, String>();
            String subAccount = dINGGInitializeAccountVo.getSubAccount();
            String purchaseAccount = dINGGInitializeAccountVo.getPurchaseAccount();
            String userId = this.elsSubAccountNewRpcService.findUserId(purchaseAccount, subAccount);
            if (StringUtils.isNotBlank((CharSequence)userId)) {
                map.put("userId", userId);
            } else {
                ReturnSRMBaseVO returnSRMBaseVO = this.callSAPInterFace(SrmInterfaceCodeEnum.FIND_SAPUSER_ID.getValue(), this.toJson(subAccount));
                String data = returnSRMBaseVO.getData();
                JSONObject jsonObject = JSONObject.parseObject((String)data);
                JSONArray tData = jsonObject.getJSONArray("T_DATA");
                if (null != tData && tData.size() > 0) {
                    JSONObject doc = JSONObject.parseObject((String)tData.get(0).toString());
                    userId = doc.getString("USERID");
                }
                map.put("userId", userId);
                this.elsSubAccountNewRpcService.updateUserId(purchaseAccount, subAccount, userId);
            }
            HashMap<String, String> mapDate = new HashMap<String, String>();
            mapDate.put("number", dINGGInitializeAccountVo.getNumber());
            mapDate.put("supplier", dINGGInitializeAccountVo.getSupplierName());
            SendRobotInteractiveCardRequest sendRobotInteractiveCardRequest = new SendRobotInteractiveCardRequest().setCardTemplateId(DINGInitializeAccountEnum.findByType(dINGGInitializeAccountVo.getType())).setSingleChatReceiver(JSONObject.toJSONString(map)).setCardBizId(dINGGInitializeAccountVo.getType() + dINGGInitializeAccountVo.getNumber()).setRobotCode(this.robotCode).setCardData(JSONObject.toJSONString(mapDate)).setSendOptions(sendOptions);
            try {
                client.sendRobotInteractiveCardWithOptions(sendRobotInteractiveCardRequest, sendRobotInteractiveCardHeaders, new RuntimeOptions());
            }
            catch (TeaException err) {
                if (!Common.empty((String)err.code) && !Common.empty((String)err.message)) {
                    log.info(err.message);
                }
            }
            catch (Exception _err) {
                TeaException err = new TeaException(_err.getMessage(), (Throwable)_err);
                if (Common.empty((String)err.code) || Common.empty((String)err.message)) break block7;
                log.info(err.message);
            }
        }
    }

    private String toJson(String subAccount) {
        HashMap all = new HashMap();
        HashMap<String, Object> T_DATA = new HashMap<String, Object>();
        ArrayList IT_ITEMList = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("JOB_NUMBER", subAccount);
        IT_ITEMList.add(map);
        T_DATA.put("tableFields0", IT_ITEMList);
        T_DATA.put("tableName", "T_DATA");
        all.put("T_DATA", T_DATA);
        String jsonString = JSON.toJSONString(all);
        return jsonString;
    }

    private ReturnSRMBaseVO callSAPInterFace(String businessType, String json) {
        SRMRequestBaseVO baseVO = new SRMRequestBaseVO();
        baseVO.setElsAccount("100000");
        baseVO.setBusinessType(businessType);
        baseVO.setData(json);
        return this.srmCallInterfaceUtil.srmCallInterface(baseVO);
    }

    public static void main(String[] args) throws Exception {
        Client client = DINGInitializeAccount.createClient();
        com.aliyun.dingtalkoauth2_1_0.Client clientT = DINGInitializeAccount.createClientT();
        GetAccessTokenRequest getAccessTokenRequest = new GetAccessTokenRequest().setAppKey("dingsrya2rme3avhpo9a").setAppSecret("zoKqDPIJG4S-zoQJIxDBOQ44HWX16kgT7XPbfkIOnbm9n_ciOdmAO-SCOUQG--Hf");
        GetAccessTokenResponse getAccessTokenResponse = clientT.getAccessToken(getAccessTokenRequest);
        SendRobotInteractiveCardHeaders sendRobotInteractiveCardHeaders = new SendRobotInteractiveCardHeaders();
        sendRobotInteractiveCardHeaders.xAcsDingtalkAccessToken = getAccessTokenResponse.body.getAccessToken();
        SendRobotInteractiveCardRequest.SendRobotInteractiveCardRequestSendOptions sendOptions = new SendRobotInteractiveCardRequest.SendRobotInteractiveCardRequestSendOptions().setAtAll(Boolean.valueOf(false));
        HashMap<String, String> map = new HashMap<String, String>();
        String userId = "054556046835583770";
        map.put("userId", userId);
        Date date = new Date();
        HashMap<String, String> mapDate = new HashMap<String, String>();
        mapDate.put("number", "DZ202307240002");
        mapDate.put("supplier", "\u5b89\u5fbd\u534e\u94c2\u518d\u751f\u8d44\u6e90\u79d1\u6280\u6709\u9650\u516c\u53f8112");
        SendRobotInteractiveCardRequest sendRobotInteractiveCardRequest = new SendRobotInteractiveCardRequest().setCardTemplateId("12200b96-a393-4db1-a5aa-6570160f3454.schema").setSingleChatReceiver(JSONObject.toJSONString(map)).setCardBizId("444").setRobotCode("dingsrya2rme3avhpo9a").setCardData(JSONObject.toJSONString(mapDate)).setSendOptions(sendOptions);
        try {
            client.sendRobotInteractiveCardWithOptions(sendRobotInteractiveCardRequest, sendRobotInteractiveCardHeaders, new RuntimeOptions());
            System.out.println("sss");
        }
        catch (TeaException err) {
            if (!Common.empty((String)err.code) && !Common.empty((String)err.message)) {
                System.out.println(err.message);
            }
        }
        catch (Exception _err) {
            TeaException err = new TeaException(_err.getMessage(), (Throwable)_err);
            if (Common.empty((String)err.code) || !Common.empty((String)err.message)) {
                // empty if block
            }
        }
    }
}

