/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.mapper.DictItemMapper;
import com.els.modules.system.service.DictItemService;
import com.els.modules.system.vo.DictItemNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictItemServiceImpl
extends ServiceImpl<DictItemMapper, DictItem>
implements DictItemService {
    @Autowired
    private DictItemMapper sysDictItemMapper;

    @Override
    public List<DictItem> selectItemsByMainId(String mainId) {
        return this.sysDictItemMapper.selectItemsByMainId(mainId);
    }

    @Override
    public Dict selectByDictId(String dict_id, String elsAccount) {
        Dict dict = this.sysDictItemMapper.selectDictByMainId(dict_id, elsAccount);
        if (dict == null) {
            dict = this.sysDictItemMapper.selectDictByMainId(dict_id, "100000");
        }
        return dict;
    }

    @Override
    public List<DictItemNode> loadDictItemTree(List<DictItem> itemList) {
        List<DictItemNode> nodes = itemList.stream().map(x -> {
            DictItemNode node = new DictItemNode();
            BeanUtils.copyProperties((Object)x, (Object)node);
            node.setId(x.getId());
            node.setKey(x.getId());
            node.setName(x.getItemText());
            node.setSortOrder(x.getSortOrder());
            node.setParentId(x.getItemParentValue());
            node.setTitle(x.getItemText());
            return node;
        }).collect(Collectors.toList());
        return this.buildTree(nodes, "0");
    }

    private List<DictItemNode> buildTree(List<DictItemNode> all, String rootId) {
        ArrayList parent = Lists.newArrayList();
        for (DictItemNode catalogue : all) {
            catalogue.setChildren(this.getChildren(catalogue, all));
            if (!rootId.equals(catalogue.getParentId()) || catalogue.getId().equals(catalogue.getParentId())) continue;
            parent.add(catalogue);
        }
        return parent;
    }

    private List<DictItemNode> getChildren(DictItemNode catalogueNode, List<DictItemNode> all) {
        ArrayList<DictItemNode> childList = new ArrayList<DictItemNode>(8);
        for (DictItemNode child : all) {
            if (!catalogueNode.getId().equals(child.getParentId()) || catalogueNode.getId().equals(catalogueNode.getParentId())) continue;
            child.setChildren(this.getChildren(child, all));
            childList.add(child);
        }
        return childList;
    }

    @Override
    public List<DictItem> queryParentNode(String id) {
        List<DictItem> list = ((DictItemMapper)this.baseMapper).queryParentNode(id);
        System.out.println(list);
        return null;
    }
}

