/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.DictModel;
import com.els.modules.system.entity.ElsCompanyBusinessRule;
import com.els.modules.system.mapper.ElsCompanyBusinessRuleMapper;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.ElsCompanyBusinessRuleService;
import com.els.modules.system.vo.DictModelVo;
import com.els.modules.system.vo.ElsCompanyBusinessRuleVO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsCompanyBusinessRuleServiceImpl
extends ServiceImpl<ElsCompanyBusinessRuleMapper, ElsCompanyBusinessRule>
implements ElsCompanyBusinessRuleService {
    @Autowired
    private DictService dictService;

    @Override
    public List<ElsCompanyBusinessRuleVO> findByElsAccount(String elsAccount) {
        return ((ElsCompanyBusinessRuleMapper)this.baseMapper).findList(elsAccount);
    }

    @Override
    public ElsCompanyBusinessRuleVO findByElsAccountAndBusinessTypeAndItemCode(String elsAccount, String businessType, String itemCode) {
        return ((ElsCompanyBusinessRuleMapper)this.baseMapper).findByElsAccountAndBusinessTypeAndItemCode(elsAccount, businessType, itemCode);
    }

    @Override
    public List<DictModelVo> findList(String elsAccount) {
        List<ElsCompanyBusinessRuleVO> businessRuleList = ((ElsCompanyBusinessRuleMapper)this.baseMapper).findList(elsAccount);
        businessRuleList.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getItemDescI18nKey()) && StringUtils.isNotBlank((CharSequence)item.getItemDesc())) {
                item.setItemDesc(I18nUtil.translate((String)item.getItemDescI18nKey(), (String)item.getItemDesc()));
            }
            if (StringUtils.isNotBlank((CharSequence)item.getItemNameI18nKey()) && StringUtils.isNotBlank((CharSequence)item.getItemName())) {
                item.setItemName(I18nUtil.translate((String)item.getItemNameI18nKey(), (String)item.getItemName()));
            }
        });
        List<DictModel> dictModelList = this.dictService.queryDictItemsByCode("srmBusinessType", elsAccount, "1");
        ArrayList list = SysUtil.copyProperties(dictModelList, DictModelVo.class);
        List<ElsCompanyBusinessRuleVO> ruleVOS = null;
        ArrayList<DictModelVo> modelVoList = new ArrayList<DictModelVo>();
        for (DictModelVo vo : list) {
            if ("all".equals(vo.getValue()) || (ruleVOS = businessRuleList.parallelStream().filter(o -> o.getBusinessType().equals(vo.getValue())).collect(Collectors.toList())).isEmpty() || ruleVOS.size() <= 0) continue;
            vo.setBusinessSetList(ruleVOS);
            modelVoList.add(vo);
        }
        return modelVoList;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public String save(List<ElsCompanyBusinessRuleVO> list) {
        String elsAccount = TenantContext.getTenant();
        List<String> businessTypes = list.parallelStream().map(ElsCompanyBusinessRule::getBusinessType).distinct().collect(Collectors.toList());
        ((ElsCompanyBusinessRuleMapper)this.baseMapper).deleteByAccountAndbusinessType(elsAccount, businessTypes);
        ArrayList<ElsCompanyBusinessRule> companyBusinessRuleList = new ArrayList<ElsCompanyBusinessRule>();
        for (ElsCompanyBusinessRuleVO vo : list) {
            ElsCompanyBusinessRule companyBusinessRule = new ElsCompanyBusinessRule();
            BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)companyBusinessRule));
            companyBusinessRule.setId(null);
            companyBusinessRule.setSystemId(vo.getId());
            companyBusinessRule.setElsAccount(elsAccount);
            companyBusinessRule.setBusinessType(vo.getBusinessType());
            companyBusinessRuleList.add(companyBusinessRule);
        }
        if (!companyBusinessRuleList.isEmpty()) {
            this.saveBatch(companyBusinessRuleList);
        }
        return null;
    }
}

