/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import com.alibaba.fastjson.JSONObject;
import com.els.modules.system.vo.ReturnSRMBaseVO;
import com.els.modules.system.vo.SRMRequestBaseVO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SrmCallInterfaceUtil {
    @Value(value="${interface.postURL}")
    private String postURL;
    @Value(value="${interface.appSecret}")
    private String appSecret;
    @Value(value="${interface.elsAccount}")
    private String elsAccount;
    @Value(value="${interface.appId}")
    private String appId;
    @Value(value="${interface.tokenUrl}")
    private String tokenUrl;

    public ReturnSRMBaseVO srmCallInterface(SRMRequestBaseVO baseVO) {
        ReturnSRMBaseVO returnSRMBaseVO = this.preCallStatus(baseVO);
        return returnSRMBaseVO;
    }

    public ReturnSRMBaseVO preCallStatus(SRMRequestBaseVO SRMRequestBaseVO2) {
        String accessToken = SrmCallInterfaceUtil.Get(this.tokenUrl, this.elsAccount, this.appId, this.appSecret);
        return SrmCallInterfaceUtil.postClient(this.postURL, this.elsAccount, accessToken, SRMRequestBaseVO2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReturnSRMBaseVO postClient(String postURL, String elsAccount, String accessToken, SRMRequestBaseVO SRMRequestBaseVO2) {
        ReturnSRMBaseVO returnSRMBaseVO = new ReturnSRMBaseVO();
        CloseableHttpClient client = null;
        try {
            client = HttpClients.createDefault();
            HttpPost request = new HttpPost(postURL);
            request.setHeader("accessToken", accessToken);
            request.setHeader("elsAccount", elsAccount);
            request.setHeader("Content-Type", "application/json");
            JSONObject jsonStu = (JSONObject)JSONObject.toJSON((Object)SRMRequestBaseVO2);
            StringEntity formEntity = new StringEntity(jsonStu.toString(), "utf-8");
            formEntity.setContentEncoding("UTF-8");
            formEntity.setContentType("application/json");
            request.setEntity((HttpEntity)formEntity);
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            StatusLine StatusLine2 = response.getStatusLine();
            int StatusCode = StatusLine2.getStatusCode();
            System.out.println("StatusCode:" + StatusCode);
            System.out.println("StatusLine:" + StatusLine2 + "\n");
            if (StatusCode == 200) {
                HttpEntity entity = response.getEntity();
                String content = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                ReturnSRMBaseVO returnSRMBaseVO2 = returnSRMBaseVO = (ReturnSRMBaseVO)JSONObject.parseObject((String)content, ReturnSRMBaseVO.class);
                return returnSRMBaseVO2;
            }
            returnSRMBaseVO.setStatus("E");
            returnSRMBaseVO.setMessage(StatusLine2.toString());
            ReturnSRMBaseVO returnSRMBaseVO3 = returnSRMBaseVO;
            return returnSRMBaseVO3;
        }
        catch (IOException e) {
            e.printStackTrace();
            returnSRMBaseVO.setStatus("E");
            returnSRMBaseVO.setMessage(e.getMessage());
            ReturnSRMBaseVO returnSRMBaseVO4 = returnSRMBaseVO;
            return returnSRMBaseVO4;
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String Get(String tokenUrl, String elsAccount, String appId, String appSecret) {
        try {
            String line;
            String realUrl = tokenUrl + elsAccount + "/" + appId + "/" + appSecret;
            URL url = new URL(realUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            conn.setConnectTimeout(10000);
            conn.setRequestMethod("GET");
            conn.setUseCaches(false);
            conn.connect();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String result = "";
            while ((line = reader.readLine()) != null) {
                result = result + line;
            }
            reader.close();
            conn.disconnect();
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            return jsonObject.getString("accessToken");
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (SocketTimeoutException socketTimeoutException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

