function getPageConfig ( Vue ) {
return {
editLayout: '${data.editLayout!}',
tempRole: 'purchase',
examineLayout: '${data.examineLayout!}',
groups: [
<#list data.templateGroupList as group>
    {
    groupName: '${group.groupName!}',
    groupNameI18nKey: '${group.groupNameI18nKey!}',
    groupCode: '${group.groupCode!}',
    groupType: '${group.groupType!}',
    sortOrder: '${group.sortOrder!}',
    <#if (group.extend)! !=''>
        extend: ${group.extend!}
    </#if>
    }<#if group_has_next>,</#if>
</#list>
],
formFields: [
<#list data.templateConfigHeadList as head>
    <#if head.purchaseShow=='1'>
        {
        groupCode: '${head.groupCode}',
        sortOrder: '${head.sortOrder}',
        fieldType: '${head.fieldType}',
        fieldLabel: '${head.fieldLabel}',
        fieldLabelI18nKey: '${head.fieldLabelI18nKey!}',
        fieldName: '${head.fieldName}',
        dictCode: '${head.dictCode!}',
        defaultValue: '${head.defaultValue!}',
        dataFormat: '${head.dataFormat!}',
        helpText: '${head.helpText!}',
        <#if (head.regex)! != ''>
            regex: ${head.regex!},
        </#if>
        alertMsg: '${head.alertMsg!}',
        <#if head.purchaseEdit!='1'>
            disabled: true,
        <#else>
            disabled: false,
        </#if>
        <#if head.showed=='1'>
            show: true,
        <#else>
            show: false,
        </#if>
        required:'${head.required}',
        <#if (head.fieldValidator)! !=''>
            fieldValidator: ${head.fieldValidator!},
        </#if>
        <#if (head.mobile)! != ''>
            mobile: ${head.mobile!},
        </#if>
        <#if (head.initFunction)! !=''>
            initFunction: ${head.initFunction},
        </#if>
        <#if (head.callback)! !=''>
            callback: ${head.callback},
        </#if>
        <#if (head.bindFunction)! !=''>
            bindFunction: ${head.bindFunction},
        </#if>
        <#if (head.extend)! !=''>
            extend: ${head.extend!},
        </#if>
        placeholder: '${head.placeholder!}'
        }<#if head_has_next>,</#if>
    </#if>
</#list>
],
itemColumns: [
<#list data.templateConfigItemList as item>
    <#if item.purchaseShow=='1'>
        {
        groupCode: '${item.groupCode!}',
        title: '${item.fieldLabel!}',
        fieldLabelI18nKey: '${item.fieldLabelI18nKey!}',
        fieldType: '${item.fieldType!}',
        field: '${item.fieldName!}',
        align: '${item.columnAlign!'center'}',
        headerAlign: 'center',
        dataFormat: '${item.dataFormat!}',
        defaultValue: '${item.defaultValue!}',
        <#if (item.columnWidth)! == ''>
            width: 150,
        <#else>
            width: '${item.columnWidth!'150'}',
        </#if>
        dictCode: '${item.dictCode!}',
        <#if (item.fixType)! != ''>
            fixType: '${item.fixType}',
        </#if>
        <#if (item.fold)! != ''>
            fold: '${item.fold}',
        </#if>
        <#if (item.formula)! != ''>
            formula: '${item.formula}',
        </#if>
        <#if (item.sum)! != ''>
            sum: '${item.sum}',
        </#if>
        <#if (item.compute)! != ''>
            computed: '${item.compute}',
        </#if>
        <#if (item.fieldValidator)! !=''>
            fieldValidator: ${item.fieldValidator!},
        </#if>
        <#if item.purchaseEdit!='1'>
            disabled: true,
        <#else>
            disabled: false,
        </#if>
        <#if item.showed=='1'>
            show: true,
        <#else>
            show: false,
        </#if>
        <#if (item.regex)! != ''>
            regex: ${item.regex!},
        </#if>
        alertMsg: '${item.alertMsg!}',
        <#if (item.dictCode)! != '' && item.purchaseEdit=='0'>
            slots: {default: 'renderDictLabel'},
        </#if>
        <#if (item.initFunction)! !=''>
            initFunction:${item.initFunction},
        </#if>
        <#if (head.callback)! !=''>
            callback: ${head.callback},
        </#if>
        <#if (item.bindFunction)! !=''>
            bindFunction:${item.bindFunction},
        </#if>
        <#if (item.extend)! !=''>
            extend: ${item.extend!},
        </#if>
        <#if item.purchaseEdit!='1' && item.fieldType =='currency'>
            slots: {default: 'renderCurrency'},
        </#if>
        required:'${item.required}',
        <#if (item.mobile)! != ''>
            mobile: ${item.mobile!},
        </#if>
        helpText: '${item.helpText!}'
        }<#if item_has_next>,</#if>
    </#if>
</#list>
]
}
}