/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.storage.spi;

import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.enumerate.FileTypeEnum;
import com.els.modules.attachment.storage.spi.StorageSpi;
import com.els.modules.template.util.ConfigPageGeneJsUtil;
import com.els.modules.template.vo.TemplateHeadVO;
import com.qcloud.cos.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public abstract class AbstractStorageSpi
implements StorageSpi {
    private static final Logger log = LoggerFactory.getLogger(AbstractStorageSpi.class);
    public static final String BEAN_NAME_SUF = "StorageSpi";

    @Override
    public Resource loadAsResource(OutputStream outputStream, String filePath) {
        try {
            URL url;
            UrlResource resource;
            if (filePath.startsWith(File.separator)) {
                filePath = filePath.substring(1);
            }
            if ((resource = new UrlResource(url = new URL(this.getBaseUrl() + filePath))).exists() || resource.isReadable()) {
                return resource;
            }
            log.error(":::\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b[{}]\u6587\u4ef6{}\u4e0d\u5b58\u5728\u6216\u8005\u65e0\u53ef\u8bfb\u6743\u9650", (Object)this.type(), (Object)filePath);
            return resource;
        }
        catch (Exception e) {
            log.error(":::\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b[{}]\u8bfb\u53d6\u6587\u4ef6{}\u5f02\u5e38:{}", new Object[]{this.type(), filePath, e.getMessage()});
            return null;
        }
    }

    @Override
    public InputStream downloadFileWithInputStream(String filePath) {
        try {
            URL url;
            UrlResource resource;
            if (filePath.startsWith(File.separator)) {
                filePath = filePath.substring(1);
            }
            if ((resource = new UrlResource(url = new URL(this.getBaseUrl() + filePath))).exists() || resource.isReadable()) {
                return resource.getInputStream();
            }
            log.error(":::\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b[{}]\u6587\u4ef6{}\u4e0d\u5b58\u5728\u6216\u8005\u65e0\u53ef\u8bfb\u6743\u9650", (Object)this.type(), (Object)filePath);
        }
        catch (Exception e) {
            log.error(":::\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b[{}]\u8bfb\u53d6\u6587\u4ef6{}\u5f02\u5e38:{}", new Object[]{this.type(), filePath, e.getMessage()});
        }
        throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFileWithOutput(HttpServletResponse response, OutputStream outputStream, String filePath) {
        Resource resource = this.loadAsResource(outputStream, filePath);
        if (null == resource) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIxMK_bbc974ee", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728"));
        }
        try {
            InputStream inputStream = resource.getInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            outputStream.write(bytes, 0, bytes.length);
            outputStream.flush();
        }
        catch (Exception e) {
            log.error(":::\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                log.error(":::\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38:{}", (Object)e.getMessage());
            }
        }
    }

    public String contentType(String name) {
        int indexOf = name.lastIndexOf(".");
        if (indexOf > 0) {
            String substring = name.substring(indexOf, name.length() - 1);
            return FileTypeEnum.getValue(substring);
        }
        if (name.contains("BMP") || name.contains("bmp")) {
            return "image/bmp";
        }
        if (name.contains("GIF") || name.contains("gif")) {
            return "image/gif";
        }
        if (name.contains("JPEG") || name.contains("jpeg") || name.contains("JPG") || name.contains("jpg") || name.contains("PNG") || name.contains("png")) {
            return "image/jpeg";
        }
        if (name.contains("HTML") || name.contains("html")) {
            return "text/html";
        }
        if (name.contains("TXT") || name.contains("txt")) {
            return "text/plain";
        }
        if (name.contains("VSD") || name.contains("vsd")) {
            return "application/vnd.visio";
        }
        if (name.contains("PPTX") || name.contains("pptx") || name.contains("PPT") || name.contains("ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (name.contains("DOCX") || name.contains("docx") || name.contains("DOC") || name.contains("doc")) {
            return "application/msword";
        }
        if (name.contains("XML") || name.contains("xml")) {
            return "text/xml";
        }
        if (name.contains("js") || name.contains("JS")) {
            return "application/x-javascript";
        }
        return "text/html";
    }

    @Override
    public String loadDownloadSafePath(StorageFileInfo fileInfo) {
        return this.loadDownloadPath(fileInfo.getPath());
    }

    @Override
    public void generatorJs(String savePathDir, TemplateHeadVO headVO) {
        ConfigPageGeneJsUtil.generatorJs(savePathDir, headVO);
    }
}

