/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.integrated.service.impl;

import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.common.constant.BusinessTypeForModule;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.integrated.api.dto.IntegratedDocumentDTO;
import com.els.modules.integrated.entity.IntegrateDataLinksTree;
import com.els.modules.integrated.entity.IntegratedBusinessData;
import com.els.modules.integrated.entity.IntegratedBusinessDataLinks;
import com.els.modules.integrated.entity.IntegratedNodes;
import com.els.modules.integrated.entity.IntegratedParamsHead;
import com.els.modules.integrated.entity.IntegratedParamsItem;
import com.els.modules.integrated.entity.IntegratedReportData;
import com.els.modules.integrated.entity.IntegratedSerachCondition;
import com.els.modules.integrated.enumerate.IntegratedDocumentEnum;
import com.els.modules.integrated.mapper.IntegratedReportDataMapper;
import com.els.modules.integrated.rpc.service.IntegratedInvokeContractRpcService;
import com.els.modules.integrated.rpc.service.IntegratedInvokeFinanceRpcService;
import com.els.modules.integrated.rpc.service.IntegratedInvokeInquiryRpcService;
import com.els.modules.integrated.rpc.service.IntegratedInvokeOrderRpcService;
import com.els.modules.integrated.service.IntegratedBusinessDataLinksService;
import com.els.modules.integrated.service.IntegratedBusinessDataService;
import com.els.modules.integrated.service.IntegratedDocumentService;
import com.els.modules.integrated.service.IntegratedNodesService;
import com.els.modules.integrated.service.IntegratedReportDataService;
import com.els.modules.integrated.util.ModulesDataHandleFactory;
import com.els.modules.integrated.vo.IntegratedNodesVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class IntegratedReportDataServiceImpl
extends BaseServiceImpl<IntegratedReportDataMapper, IntegratedReportData>
implements IntegratedReportDataService {
    @Autowired
    private IntegratedNodesService integratedNodesService;
    @Autowired
    private IntegratedBusinessDataService integratedBusinessDataService;
    @Autowired
    private IntegratedBusinessDataLinksService integratedBusinessDataLinksService;
    @Resource
    private IntegratedReportDataMapper integratedReportDataMapper;
    @Resource
    private IntegratedInvokeContractRpcService integratedInvokeContractRpcService;
    @Resource
    private IntegratedInvokeOrderRpcService integratedInvokeOrderRpcService;
    @Resource
    private IntegratedInvokeInquiryRpcService integratedInvokeInquiryRpcService;
    @Resource
    private IntegratedInvokeFinanceRpcService integratedInvokeFinanceRpcService;
    @Resource
    private IntegratedDocumentService integratedDocumentService;
    private static Map<String, IntegratedNodesVO> nodesVOMap;
    private List<String> pathList = new ArrayList<String>();

    @Override
    public void add(IntegratedReportData integratedReportData) {
        ((IntegratedReportDataMapper)this.baseMapper).insert((Object)integratedReportData);
    }

    @Override
    public void edit(IntegratedReportData integratedReportData) {
        int count = ((IntegratedReportDataMapper)this.baseMapper).updateById((Object)integratedReportData);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((IntegratedReportDataMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((IntegratedReportDataMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void refreshReportData() {
        this.assemblingReportHeadData();
        this.assemblingReportItemData();
    }

    @Override
    public void refreshNodesVO() {
        List<IntegratedNodesVO> integratedNodes = this.integratedNodesService.getIntegratedNodes();
        if (!CollectionUtils.isEmpty(integratedNodes)) {
            nodesVOMap = integratedNodes.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getBusinessType())).collect(Collectors.toMap(IntegratedNodes::getBusinessType, Function.identity(), (k1, k2) -> k2));
        }
    }

    @Override
    public List<Map<String, Object>> listByModule(IntegratedSerachCondition integratedSerachCondition) {
        String businessTypeCore = integratedSerachCondition.getBusinessTypeCore();
        if (StringUtils.isNotBlank((CharSequence)businessTypeCore)) {
            JSONArray objects = new JSONArray();
            BusinessTypeForModule businessTypeForModule = new BusinessTypeForModule();
            if (businessTypeForModule.getInquiryModules().contains(businessTypeCore)) {
                objects = this.integratedInvokeInquiryRpcService.getInquiryDataByIntegraSerach(integratedSerachCondition);
            }
            if (businessTypeForModule.getOrderModules().contains(businessTypeCore)) {
                objects = this.integratedInvokeOrderRpcService.getOrderDataByIntegraSerach(integratedSerachCondition);
            }
            if (businessTypeForModule.getFianceModules().contains(businessTypeCore)) {
                objects = this.integratedInvokeFinanceRpcService.getFinanceDataByIntegraSerach(integratedSerachCondition);
            }
            if (businessTypeForModule.getContractModules().contains(businessTypeCore)) {
                objects = this.integratedInvokeContractRpcService.getContractDataByIntegraSerach(integratedSerachCondition);
            }
            ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
            if (objects.size() > 0) {
                int legh = objects.size();
                for (int i = 0; i < legh; ++i) {
                    Object objJson = objects.get(i);
                    if (!(objJson instanceof JSONObject)) continue;
                    JSONObject jsonObject = (JSONObject)objJson;
                    String documentId = null;
                    String businessId = null;
                    if (jsonObject.containsKey((Object)"documentId")) {
                        documentId = jsonObject.getString("documentId");
                    }
                    if (jsonObject.containsKey((Object)"id")) {
                        businessId = jsonObject.getString("id");
                    }
                    IntegratedDocumentDTO integratedDocumentDTO = new IntegratedDocumentDTO();
                    integratedDocumentDTO.setId(documentId);
                    integratedDocumentDTO.setRootId(businessId);
                    try {
                        Map<String, Object> detail = this.integratedDocumentService.getDetail(integratedDocumentDTO);
                        if (detail.containsKey("nodes")) {
                            List nodes = (List)detail.get("nodes");
                            for (Map node : nodes) {
                                String businesType = (String)node.get("businesType");
                                JSONObject dataHandle = ModulesDataHandleFactory.getDataHandle(businesType, (String)node.get("id"));
                                IntegratedNodesVO integratedNodesVO = nodesVOMap.containsKey(businesType) ? nodesVOMap.get(businesType) : this.integratedNodesService.getIntegratedNodes(businesType);
                                node.put("data", dataHandle);
                                node.put("field", integratedNodesVO);
                            }
                            detail.put("nodes", nodes);
                            detail.put("rootData", jsonObject);
                        }
                        mapList.add(detail);
                        continue;
                    }
                    catch (ELSBootException e) {
                        List integratedBusinessDataLinks;
                        HashMap<String, Object> detail = new HashMap<String, Object>();
                        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.integratedBusinessDataService.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).isNotNull(IntegratedBusinessData::getDataJson)).eq(IntegratedBusinessData::getBusinessDataType, (Object)"head")).eq(IntegratedBusinessData::getIntegratedId, (Object)documentId)).last("limit 10000")).list();
                        detail.put("rootId", businessId);
                        detail.put("rootData", jsonObject);
                        if (!CollectionUtils.isEmpty((Collection)list)) {
                            ArrayList nodes = new ArrayList();
                            for (IntegratedBusinessData integratedBusinessData : list) {
                                HashMap<String, Object> node = new HashMap<String, Object>();
                                String businessType = integratedBusinessData.getBusinessType();
                                String dataBusinessId = integratedBusinessData.getBusinessId();
                                IntegratedNodesVO integratedNodesVO = nodesVOMap.containsKey(businessType) ? nodesVOMap.get(businessType) : this.integratedNodesService.getIntegratedNodes(businessType);
                                JSONObject dataHandle = ModulesDataHandleFactory.getDataHandle(businessType, dataBusinessId);
                                node.put("data", dataHandle);
                                node.put("field", (Object)integratedNodesVO);
                                node.put("id", dataBusinessId);
                                node.put("businesType", businessType);
                                node.put("url", IntegratedDocumentEnum.getUrlByType((String)businessType));
                                node.put("apiPath", IntegratedDocumentEnum.getApiPathByType((String)businessType));
                                nodes.add(node);
                            }
                            detail.put("nodes", nodes);
                        }
                        if (!CollectionUtils.isEmpty((Collection)(integratedBusinessDataLinks = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.integratedBusinessDataLinksService.lambdaQuery().eq(IntegratedBusinessDataLinks::getIntegratedId, (Object)documentId)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).isNotNull(IntegratedBusinessDataLinks::getIntegratedId)).ne(IntegratedBusinessDataLinks::getIntegratedId, (Object)"")).eq(IntegratedBusinessDataLinks::getBusinessDataType, (Object)"head")).list()))) {
                            JSONArray array = new JSONArray();
                            for (IntegratedBusinessDataLinks integratedBusinessDataLink : integratedBusinessDataLinks) {
                                JSONObject object = new JSONObject();
                                if (!StringUtils.isNotBlank((CharSequence)integratedBusinessDataLink.getBusinessParentId())) continue;
                                object.put("from", (Object)integratedBusinessDataLink.getBusinessParentId());
                                object.put("to", (Object)integratedBusinessDataLink.getBusinessId());
                                array.add((Object)object);
                            }
                            detail.put("links", array);
                        }
                        mapList.add(detail);
                    }
                }
            }
            return mapList;
        }
        return null;
    }

    private void assemblingReportHeadData() {
        List<IntegratedNodesVO> integratedNodes = this.integratedNodesService.getIntegratedNodes();
        Map<String, List> collect = integratedNodes.stream().collect(Collectors.toMap(IntegratedNodes::getBusinessType, p -> {
            ArrayList<String> strings = new ArrayList<String>();
            if (!CollectionUtils.isEmpty(p.getIntegratedParamsHeadList())) {
                strings.addAll(this.traveseHead(p.getIntegratedParamsHeadList(), p.getBusinessType()));
            }
            if (!CollectionUtils.isEmpty(p.getIntegratedParamsItemList())) {
                strings.addAll(this.traveseItem(p.getIntegratedParamsItemList(), p.getBusinessType()));
            }
            return strings;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }));
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.integratedBusinessDataService.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).isNotNull(IntegratedBusinessData::getDataJson)).eq(IntegratedBusinessData::getUsed, (Object)"0")).eq(IntegratedBusinessData::getBusinessDataType, (Object)"head")).last("limit 10000")).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new ELSBootException("\u627e\u4e0d\u5230\u8d26\u6237\u5355\u636e\u4fe1\u606f");
        }
        Map<String, Map> stringMap = list.stream().collect(Collectors.toMap(new Function<IntegratedBusinessData, String>(){

            @Override
            public String apply(IntegratedBusinessData p) {
                return p.getIntegratedId() + "_" + p.getBusinessType() + "_" + p.getBusinessId();
            }
        }, p -> {
            HashMap<String, String> strings = new HashMap<String, String>();
            JSONObject jsonObject = JSONObject.parseObject((String)p.getDataJson());
            return IntegratedReportDataServiceImpl.analysisJson2(jsonObject, p.getBusinessType() + "_baseForm", strings);
        }, (value1, value2) -> {
            value1.putAll(value2);
            return value1;
        }));
        ArrayList reportDataArrayList = new ArrayList();
        Map<String, Set<String>> map = this.listPathByBusinessData(list, "head");
        HashMap<String, JSONObject> jsonObjectHashMap = new HashMap<String, JSONObject>();
        if (!CollectionUtils.isEmpty(stringMap)) {
            Set<String> strings = map.keySet();
            for (String next : strings) {
                Set<String> strings1 = map.get(next);
                for (String s : strings1) {
                    if (!stringMap.containsKey(s)) continue;
                    Map stringStringMap = stringMap.get(s);
                    for (Map.Entry<String, List> entry : collect.entrySet()) {
                        JSONObject jsonObject;
                        String keyCollect = entry.getKey();
                        List value12 = entry.getValue();
                        if (!s.split("_")[1].equals(keyCollect)) continue;
                        if (jsonObjectHashMap.containsKey(next)) {
                            jsonObject = (JSONObject)jsonObjectHashMap.get(next);
                            value12.forEach(a -> {
                                if (stringStringMap.containsKey(a)) {
                                    jsonObject.put(a, stringStringMap.get(a));
                                }
                            });
                            jsonObjectHashMap.put(next, jsonObject);
                            continue;
                        }
                        jsonObject = new JSONObject();
                        value12.forEach(a -> {
                            if (stringStringMap.containsKey(a)) {
                                jsonObject.put(a, stringStringMap.get(a));
                            }
                        });
                        jsonObjectHashMap.put(next, jsonObject);
                    }
                }
            }
            if (!jsonObjectHashMap.isEmpty()) {
                jsonObjectHashMap.forEach((key, value) -> reportDataArrayList.add(new IntegratedReportData().setIntegratedId(key.split("_")[0]).setBusinessDataType("head").setDataJson(value.toJSONString())));
            }
            List stringList = stringMap.entrySet().stream().map(key -> ((String)key.getKey()).split("_")[0]).collect(Collectors.toList());
            List list1 = ((LambdaQueryChainWrapper)this.lambdaQuery().in(IntegratedReportData::getIntegratedId, stringList)).list();
            if (!CollectionUtils.isEmpty((Collection)list1)) {
                this.integratedReportDataMapper.deleteBatchIds(list1.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            }
            this.saveBatch(reportDataArrayList);
        }
        List collect1 = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.integratedBusinessDataService.lambdaUpdate().set(IntegratedBusinessData::getUsed, (Object)"1")).in(BaseEntity::getId, collect1)).update((Object)new IntegratedBusinessData());
    }

    private void assemblingReportItemData() {
        List<IntegratedNodesVO> integratedNodes = this.integratedNodesService.getIntegratedNodes();
        Map<String, List> collect = integratedNodes.stream().collect(Collectors.toMap(IntegratedNodes::getBusinessType, p -> {
            ArrayList<String> strings = new ArrayList<String>();
            if (!CollectionUtils.isEmpty(p.getIntegratedParamsHeadList())) {
                strings.addAll(this.traveseHead(p.getIntegratedParamsHeadList(), p.getBusinessType()));
            }
            if (!CollectionUtils.isEmpty(p.getIntegratedParamsItemList())) {
                strings.addAll(this.traveseItem2(p.getIntegratedParamsItemList(), p.getBusinessType()));
            }
            return strings;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }));
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.integratedBusinessDataService.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(IntegratedBusinessData::getUsed, (Object)"0")).eq(IntegratedBusinessData::getBusinessDataType, (Object)"item")).last("limit 10000")).list();
        if (list == null) {
            throw new ELSBootException("\u627e\u4e0d\u5230\u8d26\u6237\u5355\u636e\u4fe1\u606f");
        }
        Map stringMap = list.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getDataJson())).collect(Collectors.toMap(new Function<IntegratedBusinessData, String>(){

            @Override
            public String apply(IntegratedBusinessData p) {
                JSONObject jsonObject = JSONObject.parseObject((String)p.getDataJson());
                if (jsonObject.containsKey((Object)"headId")) {
                    return p.getBusinessType() + "_" + jsonObject.getString("headId");
                }
                return null;
            }
        }, Function.identity(), (k1, k2) -> k2));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(stringMap.keySet());
        List<IntegratedBusinessData> integratedBusinessDataList = this.integratedBusinessDataService.listHeadMsg(arrayList);
        Map integratedBusinessDataHeadList = integratedBusinessDataList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getDataJson())).collect(Collectors.toMap(n -> n.getBusinessType() + "_" + n.getBusinessId(), Function.identity(), (k1, k2) -> k2));
        Map<String, Map> stringMapNew = list.stream().collect(Collectors.toMap(new Function<IntegratedBusinessData, String>(){

            @Override
            public String apply(IntegratedBusinessData p) {
                return p.getIntegratedId() + "_" + p.getBusinessType() + "_" + p.getBusinessId();
            }
        }, p -> {
            HashMap<String, String> strings = new HashMap<String, String>();
            JSONObject jsonObject = JSONObject.parseObject((String)p.getDataJson());
            if (jsonObject.containsKey((Object)"headId") && integratedBusinessDataHeadList.containsKey(p.getBusinessType() + "_" + jsonObject.getString("headId"))) {
                IntegratedBusinessData headId = (IntegratedBusinessData)((Object)((Object)integratedBusinessDataHeadList.get(p.getBusinessType() + "_" + jsonObject.getString("headId"))));
                JSONObject objectHead = JSONObject.parseObject((String)headId.getDataJson());
                jsonObject.put(p.getBusinessType() + "_baseForm", (Object)objectHead);
            }
            return IntegratedReportDataServiceImpl.analysisJson(jsonObject, p.getBusinessType(), strings);
        }, (value1, value2) -> {
            value1.putAll(value2);
            return value1;
        }));
        Map<String, Set<String>> map = this.listPathByBusinessData(list, "item");
        ArrayList reportDataArrayList = new ArrayList();
        HashMap<String, JSONObject> jsonObjectHashMap = new HashMap<String, JSONObject>();
        if (!CollectionUtils.isEmpty(stringMapNew)) {
            Set<String> strings = map.keySet();
            for (String next : strings) {
                Set<String> strings1 = map.get(next);
                for (String key2 : strings1) {
                    if (!stringMapNew.containsKey(key2)) continue;
                    Map value3 = stringMapNew.get(key2);
                    for (Map.Entry<String, List> entry : collect.entrySet()) {
                        JSONObject jsonObject;
                        String keyCollect = entry.getKey();
                        List value12 = entry.getValue();
                        if (!key2.split("_")[1].equals(keyCollect)) continue;
                        if (jsonObjectHashMap.containsKey(next)) {
                            jsonObject = (JSONObject)jsonObjectHashMap.get(next);
                            value12.forEach(a -> {
                                if (value3.containsKey(a)) {
                                    jsonObject.put(a, value3.get(a));
                                }
                            });
                            jsonObjectHashMap.put(next, jsonObject);
                            continue;
                        }
                        jsonObject = new JSONObject();
                        value12.forEach(a -> {
                            if (value3.containsKey(a)) {
                                jsonObject.put(a, value3.get(a));
                            }
                        });
                        jsonObjectHashMap.put(next, jsonObject);
                    }
                }
            }
            if (!jsonObjectHashMap.isEmpty()) {
                jsonObjectHashMap.forEach((key, value) -> reportDataArrayList.add(new IntegratedReportData().setIntegratedId(key.split("_")[0]).setBusinessDataType("item").setDataJson(value.toJSONString())));
            }
            List stringList = stringMap.entrySet().stream().map(key -> ((String)key.getKey()).split("_")[0]).collect(Collectors.toList());
            List list1 = ((LambdaQueryChainWrapper)this.lambdaQuery().in(IntegratedReportData::getIntegratedId, stringList)).list();
            if (!CollectionUtils.isEmpty((Collection)list1)) {
                this.integratedReportDataMapper.deleteBatchIds(list1.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            }
            this.saveBatch(reportDataArrayList);
            List collect1 = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.integratedBusinessDataService.lambdaUpdate().set(IntegratedBusinessData::getUsed, (Object)"1")).in(BaseEntity::getId, collect1)).update((Object)new IntegratedBusinessData());
        }
    }

    private Map<String, Set<String>> listPathByBusinessData(List<IntegratedBusinessData> list, String dataType) {
        List collect1 = list.stream().map(IntegratedBusinessData::getIntegratedId).collect(Collectors.toList());
        List integratedBusinessDataLinks = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.integratedBusinessDataLinksService.lambdaQuery().in(IntegratedBusinessDataLinks::getIntegratedId, collect1)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).isNotNull(IntegratedBusinessDataLinks::getIntegratedId)).ne(IntegratedBusinessDataLinks::getIntegratedId, (Object)"")).eq(IntegratedBusinessDataLinks::getBusinessDataType, (Object)dataType)).list();
        if (CollectionUtils.isEmpty((Collection)integratedBusinessDataLinks)) {
            throw new ELSBootException("\u627e\u4e0d\u5230\u5355\u636e\u5bf9\u5e94\u7684links\u8282\u70b9\u4fe1\u606f");
        }
        Map dataLinksMap = integratedBusinessDataLinks.stream().collect(Collectors.toMap(n -> n.getIntegratedId() + "_" + n.getElsAccount() + "_" + n.getBusinessType() + "_" + n.getBusinessParentId() + "_" + n.getBusinessId() + "_" + n.getBusinessDataType(), Function.identity(), (k1, k2) -> k2));
        if (!CollectionUtils.isEmpty(dataLinksMap.values())) {
            Map<String, List> collect2 = dataLinksMap.values().stream().collect(Collectors.toMap(IntegratedBusinessDataLinks::getIntegratedId, p -> {
                ArrayList<IntegratedBusinessDataLinks> getNameList = new ArrayList<IntegratedBusinessDataLinks>();
                getNameList.add((IntegratedBusinessDataLinks)((Object)p));
                return getNameList;
            }, (value1, value2) -> {
                value1.addAll(value2);
                return value1;
            }));
            HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
            Set<String> stringSet = collect2.keySet();
            for (String next : stringSet) {
                List integratedBusinessDataLinks1 = collect2.get(next);
                List<IntegrateDataLinksTree> linksTrees = this.createTree(integratedBusinessDataLinks1, new ArrayList<IntegrateDataLinksTree>());
                for (IntegrateDataLinksTree integrateDataLinksTree : linksTrees) {
                    IntegratedBusinessDataLinks dataLinks = integrateDataLinksTree.getIntegratedBusinessDataLinks();
                    String key = dataLinks.getIntegratedId() + "_" + dataLinks.getBusinessType() + "_" + dataLinks.getBusinessId() + "_";
                    List<String> strings = this.listAllPathByRecursion(integrateDataLinksTree);
                    for (String string : strings) {
                        String[] split = string.split("->");
                        HashSet<String> strSet = new HashSet<String>(Arrays.asList(split));
                        map.put(dataLinks.getIntegratedId() + "_" + IdWorker.getIdStr(), strSet);
                    }
                }
            }
            return map;
        }
        return null;
    }

    private List<String> traveseHead(List<IntegratedParamsHead> integratedParamsHeadList, String businessType) {
        return integratedParamsHeadList.stream().map(p -> {
            if (StringUtils.isNotBlank((CharSequence)p.getFieldType()) && "dict".equals(p.getFieldType())) {
                return businessType + "_baseForm_" + p.getFieldName() + "_dictText";
            }
            if (StringUtils.isNotBlank((CharSequence)p.getFieldType()) && "date".equals(p.getFieldType())) {
                return businessType + "_baseForm_" + p.getFieldName();
            }
            return businessType + "_baseForm_" + p.getFieldName();
        }).collect(Collectors.toList());
    }

    private List<String> traveseItem(List<IntegratedParamsItem> integratedParamsItemList, String businessType) {
        return integratedParamsItemList.stream().map(p -> {
            if (StringUtils.isNotBlank((CharSequence)p.getFieldType()) && "dict".equals(p.getFieldType())) {
                return businessType + "_" + p.getGroupCode() + "_" + p.getFieldName() + "_dictText";
            }
            if (StringUtils.isNotBlank((CharSequence)p.getFieldType()) && "date".equals(p.getFieldType())) {
                return businessType + "_" + p.getGroupCode() + "_" + p.getFieldName();
            }
            return businessType + "_" + p.getGroupCode() + "_" + p.getFieldName();
        }).collect(Collectors.toList());
    }

    private List<String> traveseItem2(List<IntegratedParamsItem> integratedParamsItemList, String businessType) {
        return integratedParamsItemList.stream().map(p -> {
            if (StringUtils.isNotBlank((CharSequence)p.getFieldType()) && "dict".equals(p.getFieldType())) {
                return businessType + "_" + p.getFieldName() + "_dictText";
            }
            if (StringUtils.isNotBlank((CharSequence)p.getFieldType()) && "date".equals(p.getFieldType())) {
                return businessType + "_" + p.getFieldName();
            }
            return businessType + "_" + p.getFieldName();
        }).collect(Collectors.toList());
    }

    public static Map<String, String> analysisJson2(Object objJson, String flag, Map<String, String> paramMap) {
        if (objJson instanceof JSONArray) {
            JSONArray objArray = (JSONArray)objJson;
            for (int i = 0; i < objArray.size(); ++i) {
                paramMap.putAll(IntegratedReportDataServiceImpl.analysisJson2(objArray.get(i), flag, paramMap));
            }
        } else if (objJson instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)objJson;
            Iterator it = jsonObject.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                Object object = jsonObject.get((Object)key);
                if (object instanceof JSONArray) {
                    JSONArray objArray = (JSONArray)object;
                    String path = "";
                    path = StringUtils.isNotBlank((CharSequence)flag) ? flag.split("_")[0] + "_" + key : key;
                    paramMap.putAll(IntegratedReportDataServiceImpl.analysisJson2(objArray, path, paramMap));
                    continue;
                }
                if (object instanceof JSONObject) {
                    String path = "";
                    path = StringUtils.isNotBlank((CharSequence)flag) ? flag + "_" + key : key;
                    paramMap.putAll(IntegratedReportDataServiceImpl.analysisJson2((JSONObject)object, path, paramMap));
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)flag)) {
                    paramMap.put(flag + "_" + key, String.valueOf(object));
                    continue;
                }
                paramMap.put(key, String.valueOf(object));
            }
        } else {
            return paramMap;
        }
        return paramMap;
    }

    public static Map<String, String> analysisJson(Object objJson, String flag, Map<String, String> paramMap) {
        if (objJson instanceof JSONArray) {
            JSONArray objArray = (JSONArray)objJson;
            for (int i = 0; i < objArray.size(); ++i) {
                paramMap.putAll(IntegratedReportDataServiceImpl.analysisJson(objArray.get(i), flag, paramMap));
            }
        } else if (objJson instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)objJson;
            Iterator it = jsonObject.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                Object object = jsonObject.get((Object)key);
                if (object instanceof JSONArray) continue;
                if (object instanceof JSONObject) {
                    String path = key;
                    paramMap.putAll(IntegratedReportDataServiceImpl.analysisJson((JSONObject)object, path, paramMap));
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)flag)) {
                    paramMap.put(flag + "_" + key, String.valueOf(object));
                    continue;
                }
                paramMap.put(key, String.valueOf(object));
            }
        } else {
            return paramMap;
        }
        return paramMap;
    }

    private List<IntegrateDataLinksTree> createTree(List<IntegratedBusinessDataLinks> linksList, List<IntegrateDataLinksTree> treeList) {
        if (CollectionUtils.isEmpty(treeList)) {
            List<IntegratedBusinessDataLinks> collect = linksList.stream().filter(p -> StringUtils.isBlank((CharSequence)p.getBusinessParentId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                List collectNew = collect.stream().map(BaseEntity::getId).collect(Collectors.toList());
                collect.forEach(v -> {
                    IntegrateDataLinksTree integrateDataLinksTree = new IntegrateDataLinksTree();
                    integrateDataLinksTree.setIntegratedBusinessDataLinks((IntegratedBusinessDataLinks)((Object)v));
                    integrateDataLinksTree.setIntegrateDataLinksTreeList(new ArrayList<IntegrateDataLinksTree>());
                    treeList.add(integrateDataLinksTree);
                });
                Iterator<IntegratedBusinessDataLinks> iterator = linksList.iterator();
                while (iterator.hasNext()) {
                    IntegratedBusinessDataLinks next = iterator.next();
                    if (!collectNew.contains(next.getId())) continue;
                    iterator.remove();
                }
            } else {
                return new ArrayList<IntegrateDataLinksTree>();
            }
        }
        ArrayList strings = new ArrayList();
        for (IntegrateDataLinksTree integrateDataLinksTree : treeList) {
            integrateDataLinksTree = this.buildTree(linksList, integrateDataLinksTree);
        }
        return treeList;
    }

    private IntegrateDataLinksTree buildTree(List<IntegratedBusinessDataLinks> all, IntegrateDataLinksTree rootId) {
        IntegratedBusinessDataLinks integratedBusinessDataLinks = rootId.getIntegratedBusinessDataLinks();
        List<IntegrateDataLinksTree> integrateDataLinksTreeList = rootId.getIntegrateDataLinksTreeList();
        for (IntegratedBusinessDataLinks commentNode : all) {
            if (!integratedBusinessDataLinks.getBusinessId().equals(commentNode.getBusinessParentId())) continue;
            IntegrateDataLinksTree integrateDataLinksTree = new IntegrateDataLinksTree();
            integrateDataLinksTree.setIntegratedBusinessDataLinks(commentNode);
            integrateDataLinksTree.setIntegrateDataLinksTreeList(this.getChildren(integrateDataLinksTree, all));
            integrateDataLinksTreeList.add(integrateDataLinksTree);
        }
        rootId.setIntegrateDataLinksTreeList(integrateDataLinksTreeList);
        return rootId;
    }

    private List<IntegrateDataLinksTree> getChildren(IntegrateDataLinksTree commentNode, List<IntegratedBusinessDataLinks> all) {
        List<IntegrateDataLinksTree> childList = commentNode.getIntegrateDataLinksTreeList();
        if (childList == null) {
            childList = new ArrayList<IntegrateDataLinksTree>();
        }
        IntegratedBusinessDataLinks integratedBusinessDataLinks = commentNode.getIntegratedBusinessDataLinks();
        for (IntegratedBusinessDataLinks child : all) {
            if (!integratedBusinessDataLinks.getBusinessId().equals(child.getBusinessParentId())) continue;
            IntegrateDataLinksTree integrateDataLinksTree = new IntegrateDataLinksTree();
            integrateDataLinksTree.setIntegratedBusinessDataLinks(child);
            integrateDataLinksTree.setIntegrateDataLinksTreeList(this.getChildren(integrateDataLinksTree, all));
            childList.add(integrateDataLinksTree);
        }
        commentNode.setIntegrateDataLinksTreeList(childList);
        return childList;
    }

    public List<String> listAllPathByRecursion(IntegrateDataLinksTree tree) {
        this.pathList.clear();
        this.listPath(tree, "");
        return this.pathList;
    }

    public void listPath(IntegrateDataLinksTree root, String path) {
        if (root.getIntegrateDataLinksTreeList().isEmpty()) {
            IntegratedBusinessDataLinks integratedBusinessDataLinks = root.getIntegratedBusinessDataLinks();
            String key = integratedBusinessDataLinks.getIntegratedId() + "_" + integratedBusinessDataLinks.getBusinessType() + "_" + integratedBusinessDataLinks.getBusinessId();
            path = path + key;
            this.pathList.add(path);
            return;
        }
        IntegratedBusinessDataLinks integratedBusinessDataLinks = root.getIntegratedBusinessDataLinks();
        String key = integratedBusinessDataLinks.getIntegratedId() + "_" + integratedBusinessDataLinks.getBusinessType() + "_" + integratedBusinessDataLinks.getBusinessId();
        path = path + key + "->";
        List<IntegrateDataLinksTree> childs = root.getIntegrateDataLinksTreeList();
        ListIterator<IntegrateDataLinksTree> integrateDataLinksTreeListIterator = childs.listIterator();
        while (integrateDataLinksTreeListIterator.hasNext()) {
            IntegrateDataLinksTree next = integrateDataLinksTreeListIterator.next();
            this.listPath(next, path);
        }
    }

    @Test
    public void jsonTest() {
        ArrayList<IntegratedBusinessDataLinks> links = new ArrayList<IntegratedBusinessDataLinks>();
        IntegratedBusinessDataLinks integratedBusinessDataLinks = new IntegratedBusinessDataLinks();
        integratedBusinessDataLinks.setId(IdWorker.getIdStr());
        integratedBusinessDataLinks.setBusinessParentId(null);
        integratedBusinessDataLinks.setIntegratedId("9999");
        integratedBusinessDataLinks.setBusinessId("A");
        links.add(integratedBusinessDataLinks);
        IntegratedBusinessDataLinks integratedBusinessDataLinks2 = new IntegratedBusinessDataLinks();
        integratedBusinessDataLinks2.setId(IdWorker.getIdStr());
        integratedBusinessDataLinks2.setBusinessParentId(null);
        integratedBusinessDataLinks2.setIntegratedId("9999");
        integratedBusinessDataLinks2.setBusinessId("A1");
        links.add(integratedBusinessDataLinks2);
        IntegratedBusinessDataLinks integratedBusinessDataLinks3 = new IntegratedBusinessDataLinks();
        integratedBusinessDataLinks3.setId(IdWorker.getIdStr());
        integratedBusinessDataLinks3.setBusinessParentId(null);
        integratedBusinessDataLinks3.setIntegratedId("9999");
        integratedBusinessDataLinks3.setBusinessId("A2");
        links.add(integratedBusinessDataLinks3);
        IntegratedBusinessDataLinks integratedBusinessDataLinks4 = new IntegratedBusinessDataLinks();
        integratedBusinessDataLinks4.setId(IdWorker.getIdStr());
        integratedBusinessDataLinks4.setBusinessParentId("A");
        integratedBusinessDataLinks4.setIntegratedId("9999");
        integratedBusinessDataLinks4.setBusinessId("B");
        links.add(integratedBusinessDataLinks4);
        IntegratedBusinessDataLinks integratedBusinessDataLinks41 = new IntegratedBusinessDataLinks();
        integratedBusinessDataLinks41.setId(IdWorker.getIdStr());
        integratedBusinessDataLinks41.setBusinessParentId("A");
        integratedBusinessDataLinks41.setIntegratedId("9999");
        integratedBusinessDataLinks41.setBusinessId("B1");
        links.add(integratedBusinessDataLinks41);
        IntegratedBusinessDataLinks integratedBusinessDataLinks42 = new IntegratedBusinessDataLinks();
        integratedBusinessDataLinks42.setId(IdWorker.getIdStr());
        integratedBusinessDataLinks42.setBusinessParentId("A");
        integratedBusinessDataLinks42.setIntegratedId("9999");
        integratedBusinessDataLinks42.setBusinessId("B2");
        links.add(integratedBusinessDataLinks42);
        IntegratedBusinessDataLinks integratedBusinessDataLinks410 = new IntegratedBusinessDataLinks();
        integratedBusinessDataLinks410.setId(IdWorker.getIdStr());
        integratedBusinessDataLinks410.setBusinessParentId("B");
        integratedBusinessDataLinks410.setIntegratedId("9999");
        integratedBusinessDataLinks410.setBusinessId("C");
        links.add(integratedBusinessDataLinks410);
        IntegratedBusinessDataLinks integratedBusinessDataLinks411 = new IntegratedBusinessDataLinks();
        integratedBusinessDataLinks411.setId(IdWorker.getIdStr());
        integratedBusinessDataLinks411.setBusinessParentId("B1");
        integratedBusinessDataLinks411.setIntegratedId("9999");
        integratedBusinessDataLinks411.setBusinessId("C1");
        links.add(integratedBusinessDataLinks411);
        IntegratedBusinessDataLinks integratedBusinessDataLinks422 = new IntegratedBusinessDataLinks();
        integratedBusinessDataLinks422.setId(IdWorker.getIdStr());
        integratedBusinessDataLinks422.setBusinessParentId("B1");
        integratedBusinessDataLinks422.setIntegratedId("9999");
        integratedBusinessDataLinks422.setBusinessId("C2");
        links.add(integratedBusinessDataLinks422);
        IntegratedBusinessDataLinks integratedBusinessDataLinks45 = new IntegratedBusinessDataLinks();
        integratedBusinessDataLinks45.setId(IdWorker.getIdStr());
        integratedBusinessDataLinks45.setBusinessParentId("B1");
        integratedBusinessDataLinks45.setIntegratedId("9999");
        integratedBusinessDataLinks45.setBusinessId("C3");
        links.add(integratedBusinessDataLinks45);
        IntegratedBusinessDataLinks integratedBusinessDataLinks416 = new IntegratedBusinessDataLinks();
        integratedBusinessDataLinks416.setId(IdWorker.getIdStr());
        integratedBusinessDataLinks416.setBusinessParentId("A1");
        integratedBusinessDataLinks416.setIntegratedId("9999");
        integratedBusinessDataLinks416.setBusinessId("D1");
        links.add(integratedBusinessDataLinks416);
        IntegratedBusinessDataLinks integratedBusinessDataLinks421 = new IntegratedBusinessDataLinks();
        integratedBusinessDataLinks421.setId(IdWorker.getIdStr());
        integratedBusinessDataLinks421.setBusinessParentId("A1");
        integratedBusinessDataLinks421.setIntegratedId("9999");
        integratedBusinessDataLinks421.setBusinessId("D2");
        links.add(integratedBusinessDataLinks421);
        IntegratedBusinessDataLinks integratedBusinessDataLinks5 = new IntegratedBusinessDataLinks();
        integratedBusinessDataLinks5.setId(IdWorker.getIdStr());
        integratedBusinessDataLinks5.setBusinessParentId("C1");
        integratedBusinessDataLinks5.setIntegratedId("9999");
        integratedBusinessDataLinks5.setBusinessId("E");
        links.add(integratedBusinessDataLinks5);
        IntegratedBusinessDataLinks integratedBusinessDataLinks6 = new IntegratedBusinessDataLinks();
        integratedBusinessDataLinks6.setId(IdWorker.getIdStr());
        integratedBusinessDataLinks6.setBusinessParentId("C2");
        integratedBusinessDataLinks6.setIntegratedId("9999");
        integratedBusinessDataLinks6.setBusinessId("F");
        links.add(integratedBusinessDataLinks6);
        IntegratedBusinessDataLinks integratedBusinessDataLinks7 = new IntegratedBusinessDataLinks();
        integratedBusinessDataLinks7.setId(IdWorker.getIdStr());
        integratedBusinessDataLinks7.setBusinessParentId("D1");
        integratedBusinessDataLinks7.setIntegratedId("9999");
        integratedBusinessDataLinks7.setBusinessId("G");
        links.add(integratedBusinessDataLinks7);
        IntegratedBusinessDataLinks integratedBusinessDataLinks8 = new IntegratedBusinessDataLinks();
        integratedBusinessDataLinks8.setId(IdWorker.getIdStr());
        integratedBusinessDataLinks8.setBusinessParentId("E");
        integratedBusinessDataLinks8.setIntegratedId("9999");
        integratedBusinessDataLinks8.setBusinessId("H");
        links.add(integratedBusinessDataLinks8);
        IntegratedBusinessDataLinks integratedBusinessDataLinks9 = new IntegratedBusinessDataLinks();
        integratedBusinessDataLinks9.setId(IdWorker.getIdStr());
        integratedBusinessDataLinks9.setBusinessParentId("C2");
        integratedBusinessDataLinks9.setIntegratedId("9999");
        integratedBusinessDataLinks9.setBusinessId("L");
        links.add(integratedBusinessDataLinks9);
        List<IntegrateDataLinksTree> tree = this.createTree(links, new ArrayList<IntegrateDataLinksTree>());
        for (IntegrateDataLinksTree integrateDataLinksTree : tree) {
            List<String> strings = this.listAllPathByRecursion(integrateDataLinksTree);
            System.out.println(integrateDataLinksTree.getIntegratedBusinessDataLinks().getBusinessId() + ":" + strings);
        }
    }

    static {
        IntegratedNodesService bean = (IntegratedNodesService)SpringUtil.getBean(IntegratedNodesService.class);
        List<IntegratedNodesVO> integratedNodes = bean.getIntegratedNodes();
        if (!CollectionUtils.isEmpty(integratedNodes)) {
            nodesVOMap = integratedNodes.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getBusinessType())).collect(Collectors.toMap(IntegratedNodes::getBusinessType, Function.identity(), (k1, k2) -> k2));
        }
    }
}

