/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ConnectorInterfaceDTO;
import com.els.modules.third.entity.ConnectorConfig;
import com.els.modules.third.entity.ConnectorFieldMapping;
import com.els.modules.third.entity.ConnectorInterface;
import com.els.modules.third.mapper.ConnectorConfigMapper;
import com.els.modules.third.mapper.ConnectorFieldMappingMapper;
import com.els.modules.third.mapper.ConnectorInterfaceMapper;
import com.els.modules.third.service.ConnectorFieldMappingService;
import com.els.modules.third.service.ConnectorInterfaceService;
import com.els.modules.third.vo.ConnectorInterfaceVO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConnectorInterfaceServiceImpl
extends BaseServiceImpl<ConnectorInterfaceMapper, ConnectorInterface>
implements ConnectorInterfaceService {
    @Autowired
    private ConnectorConfigMapper connectorConfigMapper;
    @Autowired
    private ConnectorFieldMappingMapper connectorFieldMappingMapper;

    @Override
    @Transactional
    public void add(ConnectorInterface connectorInterface, List<ConnectorFieldMapping> connectorFieldMappingList) {
        ((ConnectorInterfaceMapper)this.baseMapper).insert((Object)connectorInterface);
        this.insertItemData(connectorInterface, connectorFieldMappingList);
    }

    @Override
    @Transactional
    public void edit(ConnectorInterface connectorInterface, List<ConnectorFieldMapping> connectorFieldMappingList) {
        ((ConnectorInterfaceMapper)this.baseMapper).updateById((Object)connectorInterface);
        this.connectorFieldMappingMapper.deleteByMainId(connectorInterface.getId());
        this.insertItemData(connectorInterface, connectorFieldMappingList);
    }

    @Override
    @Transactional
    public void delMain(String id) {
        ((ConnectorInterfaceMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.connectorFieldMappingMapper.deleteByMainId(id);
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> idList) {
        ((ConnectorInterfaceMapper)this.baseMapper).deleteBatchIds(idList);
        for (String id : idList) {
            this.connectorFieldMappingMapper.deleteByMainId(id);
        }
    }

    @Override
    public void addToEnterprise(String id) {
        ConnectorInterface anInterface = (ConnectorInterface)((Object)((ConnectorInterfaceMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ConnectorInterface::getSystemCode, (Object)anInterface.getSystemCode())).eq(ConnectorInterface::getSystemVersion, (Object)anInterface.getSystemVersion())).eq(ConnectorInterface::getSrmInterfaceCode, (Object)anInterface.getSrmInterfaceCode())).eq(ConnectorInterface::getInterfaceCode, (Object)anInterface.getInterfaceCode())).eq(ConnectorInterface::getImplementBean, (Object)anInterface.getImplementBean())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).last(" limit 1");
        Integer count = ((ConnectorInterfaceMapper)this.baseMapper).selectCount((Wrapper)wrapper);
        if (count > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APeyIIMKdeHeAoWHervWWWWCxyVAoWyVUEyVAoWKWWWWWjKyAER_429e4359", (String)"\u5f53\u524d\u8d26\u53f7\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7cfb\u7edf\u7f16\u7801\u3001\u7cfb\u7edf\u7248\u672c\u3001SRM\u5185\u90e8\u63a5\u53e3\u7f16\u7801\u3001\u63a5\u53e3\u5e73\u53f0\u63a5\u53e3\u7f16\u7801\u3001\u5b9e\u73b0bean\u7684\u8fde\u63a5\u5668\u914d\u7f6e"));
        }
        ConnectorConfig clone = null;
        if (CharSequenceUtil.isNotEmpty((CharSequence)anInterface.getSystemCode())) {
            ConnectorConfig config = (ConnectorConfig)((Object)this.connectorConfigMapper.selectById((Serializable)((Object)anInterface.getHeadId())));
            LambdaQueryWrapper wrapperConfig = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperConfig.eq(ConnectorConfig::getSystemCode, (Object)anInterface.getSystemCode())).eq(ConnectorConfig::getSystemVersion, (Object)anInterface.getSystemVersion())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).last(" limit 1");
            clone = (ConnectorConfig)((Object)this.connectorConfigMapper.selectOne((Wrapper)wrapperConfig));
            if (null == clone) {
                clone = (ConnectorConfig)((Object)ObjectUtil.clone((Object)((Object)config)));
                clone.setElsAccount(TenantContext.getTenant());
                clone.setId(IdWorker.getIdStr());
                clone.setCreateBy(null);
                clone.setCreateById(null);
                clone.setCreateBy(null);
                clone.setUpdateBy(null);
                clone.setUpdateById(null);
                clone.setUpdateTime(null);
                this.connectorConfigMapper.insert((Object)clone);
            }
        }
        List<ConnectorFieldMapping> connectorFieldMappings = this.connectorFieldMappingMapper.selectByMainId(id);
        ConnectorInterface connectorInterface = new ConnectorInterface();
        BeanUtils.copyProperties((Object)((Object)anInterface), (Object)((Object)connectorInterface));
        connectorInterface.setId(IdWorker.getIdStr());
        connectorInterface.setElsAccount(TenantContext.getTenant());
        if (null != clone) {
            connectorInterface.setHeadId(clone.getId());
        }
        connectorInterface.setEnable("0");
        this.save((Object)connectorInterface);
        if (CollectionUtil.isNotEmpty(connectorFieldMappings)) {
            ArrayList<ConnectorFieldMapping> list = new ArrayList<ConnectorFieldMapping>();
            for (ConnectorFieldMapping connectorFieldMapping : connectorFieldMappings) {
                ConnectorFieldMapping companyFieldMapping = new ConnectorFieldMapping();
                BeanUtils.copyProperties((Object)((Object)connectorFieldMapping), (Object)((Object)companyFieldMapping));
                companyFieldMapping.setId(null);
                companyFieldMapping.setElsAccount(TenantContext.getTenant());
                companyFieldMapping.setCreateBy(null);
                companyFieldMapping.setCreateById(null);
                companyFieldMapping.setCreateBy(null);
                companyFieldMapping.setUpdateBy(null);
                companyFieldMapping.setUpdateById(null);
                companyFieldMapping.setUpdateTime(null);
                companyFieldMapping.setHeadId(connectorInterface.getId());
                list.add(companyFieldMapping);
            }
            ((ConnectorFieldMappingService)SpringContextUtils.getBean(ConnectorFieldMappingService.class)).saveBatch(list);
        }
    }

    @Override
    public List<ConnectorInterface> selectByMainId(String id) {
        return ((ConnectorInterfaceMapper)this.baseMapper).selectByMainId(id);
    }

    private void insertItemData(ConnectorInterface connectorInterface, List<ConnectorFieldMapping> connectorFieldMappingList) {
        if (CollectionUtil.isNotEmpty(connectorFieldMappingList)) {
            for (ConnectorFieldMapping item : connectorFieldMappingList) {
                item.setHeadId(connectorInterface.getId());
                item.setSrmInterfaceCode(connectorInterface.getSrmInterfaceCode());
                item.setId(null);
                item.setInterfaceFieldGroupCode(CharSequenceUtil.emptyToDefault((CharSequence)item.getInterfaceFieldGroupCode(), (String)""));
                item.setMappingGroupCode(CharSequenceUtil.emptyToDefault((CharSequence)item.getMappingGroupCode(), (String)""));
                SysUtil.setSysParam((BaseEntity)item, (BaseEntity)connectorInterface);
            }
            connectorFieldMappingList.sort(Comparator.comparing(ConnectorFieldMapping::getMappingTable, Comparator.nullsFirst(String::compareTo)).thenComparing(ConnectorFieldMapping::getInterfaceField, Comparator.nullsFirst(String::compareTo)));
            ((ConnectorFieldMappingService)SpringContextUtils.getBean(ConnectorFieldMappingService.class)).saveBatch(connectorFieldMappingList);
        }
    }

    @Override
    @Transactional
    public List<ConnectorInterfaceVO> jsonImport(String json) {
        if (CharSequenceUtil.isBlank((CharSequence)json)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VuNWWWWWF_f5f40606", (String)"\u8bf7\u5bfc\u5165json\u6570\u636e"));
        }
        ConnectorInterfaceVO objData = null;
        List<ConnectorInterfaceVO> listObjData = Lists.newArrayList();
        try {
            objData = (ConnectorInterfaceVO)((Object)JSON.parseObject((String)json, ConnectorInterfaceVO.class));
        }
        catch (Exception e) {
            try {
                listObjData = JSON.parseArray((String)json, ConnectorInterfaceVO.class);
            }
            catch (Exception ee) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWyHNS_ca669dab", (String)"json\u89e3\u6790\u9519\u8bef"));
            }
        }
        if (null == objData && CollectionUtil.isEmpty((Collection)listObjData)) {
            return Lists.newArrayList();
        }
        if (null != objData) {
            listObjData.add(objData);
        }
        ArrayList<String> interfaceCodeList = new ArrayList<String>();
        ArrayList<String> code = new ArrayList<String>();
        for (int index = 0; index < listObjData.size(); ++index) {
            ConnectorInterfaceVO vo = (ConnectorInterfaceVO)((Object)listObjData.get(index));
            if (CharSequenceUtil.isEmpty((CharSequence)vo.getSrmInterfaceCode())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IdWWWWWWWCxyVAoxOLV_84b9f07e", (String)"\u5bf9\u8c61${0}SRM\u5185\u90e8\u63a5\u53e3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[]{index + ""}));
            }
            if (interfaceCodeList.contains(vo.getSrmInterfaceCode())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IdWWWWWWWCxyVAoIMK_db34de14", (String)"\u5bf9\u8c61${0}SRM\u5185\u90e8\u63a5\u53e3\u7f16\u7801\u5df2\u5b58\u5728", (String[])new String[]{index + ""}));
            }
            interfaceCodeList.add(vo.getSrmInterfaceCode());
            if (CharSequenceUtil.isEmpty((CharSequence)vo.getSystemCode())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IdWWWWHeAoxOLV_4f5ce16b", (String)"\u5bf9\u8c61${0}\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[]{index + ""}));
            }
            if (CharSequenceUtil.isEmpty((CharSequence)vo.getSystemVersion())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IdWWWWHervxOLV_887d7f24", (String)"\u5bf9\u8c61${0}\u7cfb\u7edf\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[]{index + ""}));
            }
            if (code.contains(vo.getSystemCode() + "," + vo.getSystemVersion())) continue;
            code.add(vo.getSystemCode() + "," + vo.getSystemVersion());
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.select(new SFunction[]{ConnectorInterface::getSrmInterfaceCode}).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(ConnectorInterface::getInterfaceCode, interfaceCodeList);
        List dbCodeList = this.list((Wrapper)wrapper).stream().map(ConnectorInterface::getInterfaceCode).distinct().collect(Collectors.toList());
        QueryWrapper wrapper1 = Wrappers.query();
        wrapper1.lambda().select(new SFunction[]{ConnectorConfig::getSystemCode, ConnectorConfig::getSystemVersion, BaseEntity::getId});
        wrapper1.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        wrapper1.in((Object)"concat(system_code,',',system_version)", code);
        Map dbCodeMap = this.connectorConfigMapper.selectList((Wrapper)wrapper1).stream().collect(Collectors.toMap(x -> x.getSystemCode() + "," + x.getSystemVersion(), Function.identity(), (v1, v2) -> v2));
        ArrayList data = Lists.newArrayList();
        ArrayList<ConnectorFieldMapping> allMappingList = new ArrayList<ConnectorFieldMapping>();
        for (int index = 0; index < listObjData.size(); ++index) {
            ConnectorInterfaceVO entity = (ConnectorInterfaceVO)((Object)listObjData.get(index));
            if (dbCodeList.contains(entity.getInterfaceCode())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IdWWWWWWWCxyVAoIMK_db34de14", (String)"\u5bf9\u8c61${0}SRM\u5185\u90e8\u63a5\u53e3\u7f16\u7801\u5df2\u5b58\u5728", (String[])new String[]{index + ""}));
            }
            if (!dbCodeMap.containsKey(entity.getSystemCode() + "," + entity.getSystemVersion())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IdWWWWxMKrHeAonHervjKyA_ae26ee0e", (String)"\u5bf9\u8c61${0}\u4e0d\u5b58\u5728\u8be5\u7cfb\u7edf\u7f16\u7801\u548c\u7cfb\u7edf\u7248\u672c\u7684\u8fde\u63a5\u5668", (String[])new String[]{index + ""}));
            }
            ConnectorConfig config = (ConnectorConfig)((Object)dbCodeMap.get(entity.getSystemCode() + "," + entity.getSystemVersion()));
            entity.setElsAccount(TenantContext.getTenant());
            entity.setHeadId(config.getId());
            if (CharSequenceUtil.isBlank((CharSequence)entity.getEnable())) {
                entity.setEnable("0");
            }
            ConnectorInterface connectorInterface = new ConnectorInterface();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)connectorInterface));
            connectorInterface.setId(IdWorker.getIdStr());
            List<ConnectorFieldMapping> mappingList = entity.getConnectorFieldMappingList();
            if (CollectionUtil.isNotEmpty(mappingList)) {
                long count = mappingList.stream().filter(x -> CharSequenceUtil.isEmpty((CharSequence)x.getInterfaceField()) || CharSequenceUtil.isEmpty((CharSequence)x.getMappingField()) || CharSequenceUtil.isEmpty((CharSequence)x.getMappingTable())).count();
                if (count > 0L) {
                    connectorInterface.setEnable("0");
                }
                for (ConnectorFieldMapping mapping : mappingList) {
                    mapping.setHeadId(connectorInterface.getId());
                    mapping.setUpdateBy(null);
                    mapping.setUpdateBy(null);
                    mapping.setUpdateTime(null);
                    mapping.setUseDefault(CharSequenceUtil.emptyToDefault((CharSequence)mapping.getUseDefault(), (String)"0"));
                    mapping.setInterfaceFieldGroupCode(CharSequenceUtil.emptyToDefault((CharSequence)mapping.getInterfaceFieldGroupCode(), (String)""));
                    mapping.setMappingGroupCode(CharSequenceUtil.emptyToDefault((CharSequence)mapping.getMappingGroupCode(), (String)""));
                    mapping.setConversion(CharSequenceUtil.emptyToDefault((CharSequence)mapping.getConversion(), (String)"1"));
                    mapping.setRequired(CharSequenceUtil.emptyToDefault((CharSequence)mapping.getConversion(), (String)"0"));
                    mapping.setFieldType("string");
                    mapping.setId(null);
                }
                allMappingList.addAll(mappingList);
            }
            data.add(connectorInterface);
        }
        if (CollectionUtil.isNotEmpty((Collection)data)) {
            this.saveBatch(data);
        }
        if (CollectionUtil.isNotEmpty(allMappingList)) {
            ((ConnectorFieldMappingService)SpringContextUtils.getBean(ConnectorFieldMappingService.class)).saveBatch(allMappingList);
        }
        return listObjData;
    }

    @Override
    public ConnectorInterfaceDTO loadConnectorInterface(String elsAccount, String systemCode, String systemVersion, String srmInterfaceCode, String interfaceCode) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ConnectorInterface::getSystemCode, (Object)systemCode)).eq(ConnectorInterface::getSystemVersion, (Object)systemVersion)).eq(ConnectorInterface::getSrmInterfaceCode, (Object)srmInterfaceCode)).eq(ConnectorInterface::getInterfaceCode, (Object)interfaceCode)).eq(ConnectorInterface::getEnable, (Object)"1")).eq(BaseEntity::getElsAccount, (Object)elsAccount);
        wrapper.orderByDesc(BaseEntity::getUpdateTime);
        wrapper.last(" limit 1");
        ConnectorInterface one = (ConnectorInterface)((Object)this.getOne((Wrapper)wrapper));
        if (null == one) {
            wrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ConnectorInterface::getSystemCode, (Object)systemCode)).eq(ConnectorInterface::getSystemVersion, (Object)systemVersion)).eq(ConnectorInterface::getSrmInterfaceCode, (Object)srmInterfaceCode)).eq(ConnectorInterface::getInterfaceCode, (Object)interfaceCode)).eq(ConnectorInterface::getEnable, (Object)"1")).eq(BaseEntity::getElsAccount, (Object)SysUtil.getPurchaseAccount());
            wrapper.orderByDesc(BaseEntity::getUpdateTime);
            wrapper.last(" limit 1");
            one = (ConnectorInterface)((Object)this.getOne((Wrapper)wrapper));
        }
        if (null == one) {
            return null;
        }
        return (ConnectorInterfaceDTO)Convert.convert(ConnectorInterfaceDTO.class, (Object)((Object)one));
    }
}

