/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.entity.PurchaseBarcodePoolHead;
import com.els.modules.barcode.entity.PurchaseBarcodePoolItem;
import com.els.modules.barcode.entity.PurchaseBarcodePoolRecord;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.execl.BarcodePoolHeadExportServiceImpl;
import com.els.modules.barcode.service.ElsBarcodeTemplateHeadService;
import com.els.modules.barcode.service.ElsBarcodeTemplateItemService;
import com.els.modules.barcode.service.PurchaseBarcodePoolHeadService;
import com.els.modules.barcode.service.PurchaseBarcodePoolItemService;
import com.els.modules.barcode.service.PurchaseBarcodePoolRecordService;
import com.els.modules.barcode.vo.BarcodeRecordVO;
import com.els.modules.barcode.vo.PurchaseBarcodePoolHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/base/barcode/purchaseBarcodePoolHead"})
@Api(tags={"\u91c7\u8d2d\u6761\u7801\u5e93\u5934\u8868"})
public class PurchaseBarcodePoolHeadController
extends BaseController<PurchaseBarcodePoolHead, PurchaseBarcodePoolHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseBarcodePoolHeadController.class);
    @Autowired
    private PurchaseBarcodePoolHeadService purchaseBarcodePoolHeadService;
    @Autowired
    private PurchaseBarcodePoolItemService purchaseBarcodePoolItemService;
    @Autowired
    private PurchaseBarcodePoolRecordService purchaseBarcodePoolRecordService;
    @Autowired
    private ElsBarcodeTemplateHeadService elsBarcodeTemplateHeadService;
    @Autowired
    private ElsBarcodeTemplateItemService elsBarcodeTemplateItemService;

    @RequiresPermissions(value={"barcode#pool:list"})
    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="barcodePool")
    public Result<?> queryPageList(PurchaseBarcodePoolHead purchaseBarcodePoolHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseBarcodePoolHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBarcodePoolHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @RequiresPermissions(value={"barcode#pool:delete"})
    @AutoLog(busModule="\u91c7\u8d2d\u6761\u7801\u5e93\u5934\u8868", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseBarcodePoolHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u72b6\u6001\u542f\u7528")
    @ApiOperation(value="\u72b6\u6001\u542f\u7528", notes="\u72b6\u6001\u542f\u7528")
    @PostMapping(value={"/changeEnabled"})
    @RequiresPermissions(value={"barcode#pool:enable"})
    public Result<?> changeEnabled(@RequestBody PurchaseBarcodePoolHeadVO purchaseBarcodePoolHeadVO) {
        purchaseBarcodePoolHeadVO.setStatus(SrmEnabledStatusEnum.ENABLED.getValue());
        PurchaseBarcodePoolHead purchaseBarcodePoolHead = new PurchaseBarcodePoolHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBarcodePoolHeadVO), (Object)((Object)purchaseBarcodePoolHead));
        this.purchaseBarcodePoolHeadService.updateById((Object)purchaseBarcodePoolHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u72b6\u6001\u7981\u7528")
    @ApiOperation(value="\u72b6\u6001\u7981\u7528", notes="\u72b6\u6001\u7981\u7528")
    @PostMapping(value={"/changeDisabled"})
    @RequiresPermissions(value={"barcode#pool:disabled"})
    public Result<?> changeDisabled(@RequestBody PurchaseBarcodePoolHeadVO purchaseBarcodePoolHeadVO) {
        purchaseBarcodePoolHeadVO.setStatus(SrmEnabledStatusEnum.DISABLED.getValue());
        PurchaseBarcodePoolHead purchaseBarcodePoolHead = new PurchaseBarcodePoolHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBarcodePoolHeadVO), (Object)((Object)purchaseBarcodePoolHead));
        this.purchaseBarcodePoolHeadService.updateById((Object)purchaseBarcodePoolHead);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"barcode#pool:detail"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseBarcodePoolHead purchaseBarcodePoolHead = (PurchaseBarcodePoolHead)((Object)this.purchaseBarcodePoolHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseBarcodePoolHeadVO purchaseBarcodePoolHeadVO = new PurchaseBarcodePoolHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseBarcodePoolHead), (Object)((Object)purchaseBarcodePoolHeadVO));
        List<PurchaseBarcodePoolItem> purchaseBarcodePoolItemList = this.purchaseBarcodePoolItemService.selectByMainId(id);
        purchaseBarcodePoolHeadVO.setPurchaseBarcodePoolItemList(purchaseBarcodePoolItemList);
        List<PurchaseBarcodePoolRecord> purchaseBarcodePoolRecordList = this.purchaseBarcodePoolRecordService.selectByMainId(id);
        purchaseBarcodePoolHeadVO.setPurchaseBarcodePoolRecordList(purchaseBarcodePoolRecordList);
        return Result.ok((Object)((Object)purchaseBarcodePoolHeadVO));
    }

    @RequiresPermissions(value={"barcode#pool:detail"})
    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u6761\u7801\u5e93\u5934\u8868id\u67e5\u8be2\u91c7\u8d2d\u6761\u7801\u5e93\u884c\u8868", notes="\u901a\u8fc7\u91c7\u8d2d\u6761\u7801\u5e93\u5934\u8868id\u67e5\u8be2\u91c7\u8d2d\u6761\u7801\u5e93\u884c\u8868")
    @GetMapping(value={"/queryPurchaseBarcodePoolItemByMainId"})
    public Result<?> queryPurchaseBarcodePoolItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseBarcodePoolItem> purchaseBarcodePoolItemList = this.purchaseBarcodePoolItemService.selectByMainId(id);
        return Result.ok(purchaseBarcodePoolItemList);
    }

    @RequiresPermissions(value={"barcode#pool:detail"})
    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u6761\u7801\u5e93\u5934\u8868id\u67e5\u8be2\u91c7\u8d2d\u6761\u7801\u5e93\u4f7f\u7528\u8bb0\u5f55\u8868", notes="\u901a\u8fc7\u91c7\u8d2d\u6761\u7801\u5e93\u5934\u8868id\u67e5\u8be2\u91c7\u8d2d\u6761\u7801\u5e93\u4f7f\u7528\u8bb0\u5f55\u8868")
    @GetMapping(value={"/queryPurchaseBarcodePoolRecordByMainId"})
    public Result<?> queryPurchaseBarcodePoolRecordListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseBarcodePoolRecord> purchaseBarcodePoolRecordList = this.purchaseBarcodePoolRecordService.selectByMainId(id);
        return Result.ok(purchaseBarcodePoolRecordList);
    }

    @RequiresPermissions(value={"barcode#pool:exportXls"})
    @PostMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, BarcodePoolHeadExportServiceImpl.class);
    }

    @RequiresPermissions(value={"barcode#pool:savePoolRecordByPrint"})
    @ApiOperation(value="\u56de\u5199\u6761\u7801\u8bb0\u5f55\u4fe1\u606f", notes="\u56de\u5199\u6761\u7801\u8bb0\u5f55\u4fe1\u606f")
    @PostMapping(value={"/savePoolRecordByPrint"})
    public Result<?> savePoolRecordByPrint(@RequestBody BarcodeRecordVO barcodeRecordVO) {
        if (StringUtils.isBlank((CharSequence)barcodeRecordVO.getTemplateId())) {
            return Result.error((String)I18nUtil.translate((String)"", (String)"templateId\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StringUtils.isBlank((CharSequence)barcodeRecordVO.getBusinessType())) {
            return Result.error((String)I18nUtil.translate((String)"", (String)"businessType\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        this.purchaseBarcodePoolRecordService.saveBatchByBarcode(barcodeRecordVO);
        return Result.ok(null);
    }

    @RequiresPermissions(value={"barcode#pool:saveBarcodeRecordByPrint"})
    @ApiOperation(value="\u56de\u5199\u6761\u7801\u8bb0\u5f55\u4fe1\u606f", notes="\u56de\u5199\u6761\u7801\u8bb0\u5f55\u4fe1\u606f")
    @PostMapping(value={"/saveBarcodeRecordByPrint"})
    public Result<?> saveBarcodeRecordByPrint(@RequestBody BarcodeRecordVO barcodeRecordVO) {
        if (StringUtils.isBlank((CharSequence)barcodeRecordVO.getTemplateId())) {
            return Result.error((String)I18nUtil.translate((String)"", (String)"templateId\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StringUtils.isBlank((CharSequence)barcodeRecordVO.getBusinessType())) {
            return Result.error((String)I18nUtil.translate((String)"", (String)"businessType\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        this.purchaseBarcodePoolRecordService.saveBatchBarcodeByPrint(barcodeRecordVO);
        return Result.ok(null);
    }
}

