/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.entity.ElsBarcodeRuleHead;
import com.els.modules.barcode.entity.ElsBarcodeRuleItem;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.service.ElsBarcodeRuleHeadService;
import com.els.modules.barcode.service.ElsBarcodeRuleItemService;
import com.els.modules.barcode.vo.ElsBarcodeRuleHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/barcode/elsBarcodeRuleHead"})
@Api(tags={"\u6761\u7801\u89c4\u5219\u914d\u7f6e\u5934"})
public class ElsBarcodeRuleHeadController
extends BaseController<ElsBarcodeRuleHead, ElsBarcodeRuleHeadService> {
    private static final Logger log = LoggerFactory.getLogger(ElsBarcodeRuleHeadController.class);
    @Autowired
    private ElsBarcodeRuleHeadService elsBarcodeRuleHeadService;
    @Autowired
    private ElsBarcodeRuleItemService elsBarcodeRuleItemService;

    @RequiresPermissions(value={"barcode#rule:list"})
    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ElsBarcodeRuleHead elsBarcodeRuleHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsBarcodeRuleHead), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsBarcodeRuleHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(busModule="\u6761\u7801\u89c4\u5219\u914d\u7f6e\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"barcode#rule:add"})
    public Result<?> add(@RequestBody ElsBarcodeRuleHeadVO elsBarcodeRuleHeadPage) {
        ElsBarcodeRuleHead elsBarcodeRuleHead = new ElsBarcodeRuleHead();
        BeanUtils.copyProperties((Object)((Object)elsBarcodeRuleHeadPage), (Object)((Object)elsBarcodeRuleHead));
        this.elsBarcodeRuleHeadService.saveMain(elsBarcodeRuleHead, elsBarcodeRuleHeadPage.getElsBarcodeRuleItemList());
        return Result.ok((Object)((Object)elsBarcodeRuleHead));
    }

    @SrmValidated
    @AutoLog(busModule="\u6761\u7801\u89c4\u5219\u914d\u7f6e\u5934", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"barcode#rule:edit"})
    public Result<?> edit(@RequestBody ElsBarcodeRuleHeadVO elsBarcodeRuleHeadPage) {
        ElsBarcodeRuleHead elsBarcodeRuleHead = new ElsBarcodeRuleHead();
        BeanUtils.copyProperties((Object)((Object)elsBarcodeRuleHeadPage), (Object)((Object)elsBarcodeRuleHead));
        this.elsBarcodeRuleHeadService.updateMain(elsBarcodeRuleHead, elsBarcodeRuleHeadPage.getElsBarcodeRuleItemList(), 1);
        return Result.ok((Object)((Object)elsBarcodeRuleHead));
    }

    @RequiresPermissions(value={"barcode#rule:submit"})
    @SrmValidated
    @AutoLog(busModule="\u6761\u7801\u89c4\u5219\u914d\u7f6e\u5934", value="\u63d0\u4ea4")
    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    public Result<?> submit(@RequestBody ElsBarcodeRuleHeadVO elsBarcodeRuleHeadPage) {
        ElsBarcodeRuleHead elsBarcodeRuleHead = new ElsBarcodeRuleHead();
        BeanUtils.copyProperties((Object)((Object)elsBarcodeRuleHeadPage), (Object)((Object)elsBarcodeRuleHead));
        this.elsBarcodeRuleHeadService.updateMain(elsBarcodeRuleHead, elsBarcodeRuleHeadPage.getElsBarcodeRuleItemList(), 2);
        return this.commonSuccessResult(3);
    }

    @RequiresPermissions(value={"barcode#rule:changeStatus"})
    @AutoLog(value="\u72b6\u6001\u53d8\u66f4")
    @ApiOperation(value="\u72b6\u6001\u53d8\u66f4", notes="\u72b6\u6001\u53d8\u66f4")
    @PostMapping(value={"/changeStatus"})
    public Result<?> changeStatus(@RequestBody ElsBarcodeRuleHeadVO elsBarcodeAttributeVO) {
        if ("1".equals(elsBarcodeAttributeVO.getStatusType())) {
            elsBarcodeAttributeVO.setRuleStatus(SrmEnabledStatusEnum.ENABLED.getValue());
        } else if ("2".equals(elsBarcodeAttributeVO.getStatusType())) {
            elsBarcodeAttributeVO.setRuleStatus(SrmEnabledStatusEnum.DISABLED.getValue());
        }
        ElsBarcodeRuleHead elsBarcodeRuleHead = new ElsBarcodeRuleHead();
        BeanUtils.copyProperties((Object)((Object)elsBarcodeAttributeVO), (Object)((Object)elsBarcodeRuleHead));
        this.elsBarcodeRuleHeadService.updateById((Object)elsBarcodeRuleHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u6761\u7801\u89c4\u5219\u914d\u7f6e\u5934", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"barcode#rule:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.elsBarcodeRuleHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"barcode#rule:detail"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ElsBarcodeRuleHead elsBarcodeRuleHead = (ElsBarcodeRuleHead)((Object)this.elsBarcodeRuleHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        ElsBarcodeRuleHeadVO elsBarcodeRuleHeadVO = new ElsBarcodeRuleHeadVO();
        BeanUtils.copyProperties((Object)((Object)elsBarcodeRuleHead), (Object)((Object)elsBarcodeRuleHeadVO));
        List<ElsBarcodeRuleItem> elsBarcodeRuleItemList = this.elsBarcodeRuleItemService.selectByMainId(id);
        elsBarcodeRuleHeadVO.setElsBarcodeRuleItemList(elsBarcodeRuleItemList);
        return Result.ok((Object)((Object)elsBarcodeRuleHeadVO));
    }

    @RequiresPermissions(value={"barcode#rule:detail"})
    @ApiOperation(value="\u901a\u8fc7\u6761\u7801\u89c4\u5219\u914d\u7f6e\u5934id\u67e5\u8be2\u6761\u7801\u89c4\u5219\u914d\u7f6e\u884c", notes="\u901a\u8fc7\u6761\u7801\u89c4\u5219\u914d\u7f6e\u5934id\u67e5\u8be2\u6761\u7801\u89c4\u5219\u914d\u7f6e\u884c")
    @GetMapping(value={"/queryElsBarcodeRuleItemByMainId"})
    public Result<?> queryElsBarcodeRuleItemListByMainId(@RequestParam(name="id") String id) {
        List<ElsBarcodeRuleItem> elsBarcodeRuleItemList = this.elsBarcodeRuleItemService.selectByMainId(id);
        return Result.ok(elsBarcodeRuleItemList);
    }

    @RequiresPermissions(value={"barcode#rule:list"})
    @ApiOperation(value="\u5206\u9875\u5934\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5934\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/enabledList"})
    public Result<?> enabledList(ElsBarcodeRuleHead elsBarcodeRuleHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsBarcodeRuleHead), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(ElsBarcodeRuleHead::getRuleStatus, (Object)SrmEnabledStatusEnum.ENABLED.getValue());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsBarcodeRuleHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @RequiresPermissions(value={"barcode#rule:detail"})
    @ApiOperation(value="\u5206\u9875\u884c\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u884c\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/itemList"})
    public Result<?> itemList(ElsBarcodeRuleItem elsBarcodeRuleItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsBarcodeRuleItem), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.lambda().eq(ElsBarcodeRuleItem::getHeadId, (Object)elsBarcodeRuleItem.getHeadId());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsBarcodeRuleItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }
}

