/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.CodeGenerator;
import com.els.modules.system.entity.CodeGeneratorDetail;
import com.els.modules.system.entity.CodeGeneratorSerial;
import com.els.modules.system.excel.CodeGeneratorExportServiceImpl;
import com.els.modules.system.service.CodeGeneratorDetailService;
import com.els.modules.system.service.CodeGeneratorSerialService;
import com.els.modules.system.service.CodeGeneratorService;
import com.els.modules.system.vo.CodeGeneratorVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/base/codeGenerator"})
@Api(tags={"\u7f16\u7801\u89c4\u5219"})
public class CodeGeneratorController
extends BaseController<CodeGenerator, CodeGeneratorService> {
    @Autowired
    private CodeGeneratorService codeGeneratorService;
    @Autowired
    private CodeGeneratorDetailService codeGeneratorDetailService;
    @Autowired
    private CodeGeneratorSerialService codeGeneratorSerialService;

    @ApiOperation(value="\u7f16\u7801\u89c4\u5219-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u7f16\u7801\u89c4\u5219-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"system#CodeGenerator:list"})
    public Result<?> queryPageList(CodeGenerator codeGenerator, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)codeGenerator), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.codeGeneratorService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u7f16\u7801\u89c4\u5219-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u7f16\u7801\u89c4\u5219-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/listSys"})
    @RequiresPermissions(value={"system#CodeGenerator:listSys"})
    public Result<?> querySysPageList(CodeGenerator codeGenerator, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)codeGenerator), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.codeGeneratorService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u7f16\u7801\u89c4\u5219-\u6dfb\u52a0", operateType=2)
    @ApiOperation(value="\u7f16\u7801\u89c4\u5219-\u6dfb\u52a0", notes="\u7f16\u7801\u89c4\u5219-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"system#CodeGenerator:add"})
    public Result<?> add(@RequestBody CodeGeneratorVO codeGeneratorPage) {
        Assert.notEmpty(codeGeneratorPage.getCodeGeneratorDetailList(), (String)I18nUtil.translate((String)"i18n_alert_AoLFRHxOLV_4eaf3048", (String)"\u7f16\u7801\u89c4\u5219\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a"));
        CodeGenerator codeGenerator = new CodeGenerator();
        BeanUtils.copyProperties((Object)((Object)codeGeneratorPage), (Object)((Object)codeGenerator));
        this.codeGeneratorService.saveMain(codeGenerator, codeGeneratorPage.getCodeGeneratorDetailList());
        return Result.ok((Object)((Object)codeGenerator));
    }

    @SrmValidated
    @AutoLog(value="\u7f16\u7801\u89c4\u5219-\u7f16\u8f91", operateType=3)
    @ApiOperation(value="\u7f16\u7801\u89c4\u5219-\u7f16\u8f91", notes="\u7f16\u7801\u89c4\u5219-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"system#CodeGenerator:edit"})
    public Result<?> edit(@RequestBody CodeGeneratorVO codeGeneratorPage) {
        Assert.notEmpty(codeGeneratorPage.getCodeGeneratorDetailList(), (String)I18nUtil.translate((String)"i18n_alert_AoLFRHxOLV_4eaf3048", (String)"\u7f16\u7801\u89c4\u5219\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a"));
        CodeGenerator codeGenerator = new CodeGenerator();
        BeanUtils.copyProperties((Object)((Object)codeGeneratorPage), (Object)((Object)codeGenerator));
        this.codeGeneratorService.updateMain(codeGenerator, codeGeneratorPage.getCodeGeneratorDetailList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7f16\u7801\u89c4\u5219-\u5c06100000\u53f7\u7684\u7f16\u7801\u89c4\u5219\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7", operateType=2)
    @ApiOperation(value="\u5c06100000\u53f7\u7684\u7f16\u7801\u89c4\u5219\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7-\u6dfb\u52a0", notes="\u5c06100000\u53f7\u7684\u7f16\u7801\u89c4\u5219\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7-\u6dfb\u52a0")
    @GetMapping(value={"/addToEnterprise"})
    @RequiresPermissions(value={"system#CodeGenerator:addToEnterprise"})
    public Result<?> addToEnterprise(@RequestParam(value="id") String id) {
        this.codeGeneratorService.addToEnterprise(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7f16\u7801\u89c4\u5219-\u901a\u8fc7id\u5220\u9664", operateType=4)
    @ApiOperation(value="\u7f16\u7801\u89c4\u5219-\u901a\u8fc7id\u5220\u9664", notes="\u7f16\u7801\u89c4\u5219-\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"system#CodeGenerator:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.codeGeneratorService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u7f16\u7801\u89c4\u5219-\u901a\u8fc7id\u67e5\u8be2", notes="\u7f16\u7801\u89c4\u5219-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"system#CodeGenerator:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        CodeGenerator codeGenerator = (CodeGenerator)((Object)this.codeGeneratorService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        CodeGeneratorVO generatorVO = new CodeGeneratorVO();
        BeanUtils.copyProperties((Object)((Object)codeGenerator), (Object)((Object)generatorVO));
        List<CodeGeneratorDetail> codeGeneratorDetailList = this.codeGeneratorDetailService.selectByMainId(id);
        List<CodeGeneratorSerial> codeGeneratorSerialList = this.codeGeneratorSerialService.selectByMainId(id);
        generatorVO.setCodeGeneratorDetailList(codeGeneratorDetailList);
        generatorVO.setCodeGeneratorSerialList(codeGeneratorSerialList);
        return Result.ok((Object)((Object)generatorVO));
    }

    @ApiOperation(value="\u7f16\u7801\u89c4\u5219-\u901a\u8fc7\u7f16\u7801\u89c4\u5219id\u67e5\u8be2\u7f16\u7801\u89c4\u5219\u660e\u7ec6", notes="\u7f16\u7801\u89c4\u5219-\u901a\u8fc7\u7f16\u7801\u89c4\u5219id\u67e5\u8be2\u7f16\u7801\u89c4\u5219\u660e\u7ec6")
    @GetMapping(value={"/queryCodeGeneratorDetailByMainId"})
    @RequiresPermissions(value={"system#CodeGenerator:queryById"})
    public Result<?> queryCodeGeneratorDetailListByMainId(@RequestParam(name="id") String id) {
        List<CodeGeneratorDetail> codeGeneratorDetailList = this.codeGeneratorDetailService.selectByMainId(id);
        return Result.ok(codeGeneratorDetailList);
    }

    @ApiOperation(value="\u7f16\u7801\u89c4\u5219-\u901a\u8fc7\u7f16\u7801\u89c4\u5219id\u67e5\u8be2\u7f16\u7801\u5e8f\u5217", notes="\u7f16\u7801\u89c4\u5219-\u901a\u8fc7\u7f16\u7801\u89c4\u5219id\u67e5\u8be2\u7f16\u7801\u5e8f\u5217")
    @GetMapping(value={"/queryCodeGeneratorSerialByMainId"})
    @RequiresPermissions(value={"system#CodeGenerator:queryById"})
    public Result<?> queryCodeGeneratorSerialListByMainId(@RequestParam(name="id") String id) {
        List<CodeGeneratorSerial> codeGeneratorSerialList = this.codeGeneratorSerialService.selectByMainId(id);
        return Result.ok(codeGeneratorSerialList);
    }

    @AutoLog(value="\u7f16\u7801\u89c4\u5219-\u5bfc\u51faExcel", operateType=6)
    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"system#CodeGenerator:exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, CodeGeneratorExportServiceImpl.class);
    }
}

