/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.groovy.EnhanceGroovyFactory;
import com.els.common.service.EnhanceService;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.EnhanceConfig;
import com.els.modules.system.mapper.EnhanceConfigMapper;
import com.els.modules.system.service.EnhanceConfigService;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class EnhanceConfigServiceImpl
extends BaseServiceImpl<EnhanceConfigMapper, EnhanceConfig>
implements EnhanceConfigService {
    private static final String REDIS_KEY = "sys:enhance:config:";
    @Resource
    private RedisUtil redisUtil;

    private String getRedisKey(String elsAccount, String enhancePoint) {
        StringBuilder redisKey = new StringBuilder(REDIS_KEY);
        redisKey.append(elsAccount);
        redisKey.append(enhancePoint);
        return redisKey.toString();
    }

    @Override
    public void saveEnhanceConfig(EnhanceConfig enhanceConfig) {
        ((EnhanceConfigMapper)this.baseMapper).insert((Object)enhanceConfig);
    }

    @Override
    public void updateEnhanceConfig(EnhanceConfig enhanceConfig) {
        ((EnhanceConfigMapper)this.baseMapper).updateById((Object)enhanceConfig);
    }

    @Override
    public void delEnhanceConfig(String id) {
        ((EnhanceConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public IPage<EnhanceConfig> findPageList(Page<EnhanceConfig> page, String elsAccount, QueryWrapper<EnhanceConfig> wrapper) {
        return ((EnhanceConfigMapper)this.baseMapper).findPageList(page, elsAccount, SysUtil.getPurchaseAccount(), wrapper);
    }

    @Override
    public void saveCompanyConfig(EnhanceConfig enhanceConfig) {
        if (StrUtil.isBlank((CharSequence)enhanceConfig.getCompanyId())) {
            EnhanceConfig config = new EnhanceConfig();
            BeanUtils.copyProperties((Object)((Object)enhanceConfig), (Object)((Object)config));
            config.setId(null);
            config.setElsAccount(TenantContext.getTenant());
            ((EnhanceConfigMapper)this.baseMapper).insert((Object)config);
        } else {
            enhanceConfig.setId(enhanceConfig.getCompanyId());
            ((EnhanceConfigMapper)this.baseMapper).updateById((Object)enhanceConfig);
        }
        this.redisUtil.del(new String[]{this.getRedisKey(TenantContext.getTenant(), enhanceConfig.getEnhancePoint())});
    }

    @Override
    public EnhanceConfig findEnhanceConfig(String elsAccount, String enhancePoint) {
        EnhanceConfig config = (EnhanceConfig)((Object)this.redisUtil.get(this.getRedisKey(elsAccount, enhancePoint)));
        if (config != null) {
            return config;
        }
        config = (EnhanceConfig)((Object)this.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"enhance_point", (Object)enhancePoint)));
        if (config != null) {
            this.redisUtil.set(this.getRedisKey(elsAccount, enhancePoint), (Object)config, 7200L);
        }
        return config;
    }

    @Override
    public void codeTest(EnhanceConfig config) {
        String code = config.getEnhanceBean();
        EnhanceService service = EnhanceGroovyFactory.getInstance().getEnhanceServiceFromCode(code);
        if (service == null) {
            throw new ELSBootException("\u7f16\u8bd1\u62a5\u9519\uff01");
        }
    }
}

