/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.util.I18nUtil;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.modules.system.service.ExcelItemExcelService;
import io.swagger.annotations.Api;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/base/excelByConfig"})
@Api(tags={"Excel\u914d\u7f6e"})
public class ExcelByConfigController {
    private static final Logger log = LoggerFactory.getLogger(ExcelByConfigController.class);
    @Autowired
    private ExcelItemExcelService service;

    @AutoLog(value="\u57fa\u4e8e\u914d\u7f6e\u5bfc\u5165\u5bfc\u51faExcel-\u4e0b\u8f7d\u6a21\u677f", operateType=6)
    @GetMapping(value={"/downloadTemplate"})
    @RequiresPermissions(value={"system#excelByConfig:downloadTemplate"})
    public void downloadTemplate(HttpServletRequest request, HttpServletResponse response) {
        String handlerName = request.getParameter("handlerName");
        Assert.hasText((String)handlerName, (String)I18nUtil.translate((String)"i18n_alert_empty_header_name", (String)"handlerName\u4e0d\u80fd\u4e3a\u7a7a"));
        ExcelByConfigDTO dto = new ExcelByConfigDTO();
        dto.setHeadId(request.getParameter("id"));
        dto.setTemplateAccount(request.getParameter("templateAccount"));
        dto.setTemplateNumber(request.getParameter("templateNumber"));
        dto.setTemplateVersion(request.getParameter("templateVersion"));
        dto.setGroupCode(request.getParameter("groupCode"));
        dto.setRoleCode(request.getParameter("roleCode"));
        dto.setHandlerName(handlerName);
        this.service.download(response, dto);
    }

    @AutoLog(value="\u57fa\u4e8e\u914d\u7f6e\u5bfc\u5165\u5bfc\u51faExcel-\u5bfc\u51fa", operateType=6)
    @GetMapping(value={"/exportExcel"})
    @RequiresPermissions(value={"system#excelByConfig:exportExcel"})
    public void exportExcel(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=false) Map<String, Object> object) {
        String headId = request.getParameter("id");
        String handlerName = request.getParameter("handlerName");
        Assert.hasText((String)headId, (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)handlerName, (String)I18nUtil.translate((String)"i18n_alert_empty_header_name", (String)"handlerName\u4e0d\u80fd\u4e3a\u7a7a"));
        ExcelByConfigDTO dto = new ExcelByConfigDTO();
        dto.setBusAccount(request.getParameter("busAccount"));
        dto.setHeadId(headId);
        dto.setHandlerName(handlerName);
        dto.setGroupCode(request.getParameter("groupCode"));
        dto.setRoleCode(request.getParameter("roleCode"));
        dto.setData(request.getParameter("data"));
        dto.setParamMap(request.getParameterMap());
        dto.setEntity(JSONObject.toJSONString(object));
        this.service.exportExcel(response, dto);
    }

    @AutoLog(value="\u57fa\u4e8e\u914d\u7f6e\u5bfc\u5165\u5bfc\u51faExcel-\u5bfc\u51fa", operateType=6)
    @GetMapping(value={"/exportDataExcel"})
    @RequiresPermissions(value={"system#excelByConfig:exportExcel"})
    public void exportDataExcel(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=false) Map<String, Object> object) {
        String headId = request.getParameter("id");
        String handlerName = request.getParameter("handlerName");
        ExcelByConfigDTO dto = new ExcelByConfigDTO();
        dto.setBusAccount(request.getParameter("busAccount"));
        dto.setHeadId(headId);
        dto.setHandlerName(handlerName);
        dto.setGroupCode(request.getParameter("groupCode"));
        dto.setRoleCode(request.getParameter("roleCode"));
        dto.setData(request.getParameter("data"));
        dto.setExcelTemplateType(request.getParameter("excelTemplateType"));
        dto.setExcelCode(request.getParameter("excelCode"));
        dto.setParamMap(request.getParameterMap());
        dto.setEntity(JSONObject.toJSONString(object));
        this.service.exportExcel(response, dto);
    }

    @AutoLog(value="\u57fa\u4e8e\u914d\u7f6e\u5bfc\u5165\u5bfc\u51faExcel-\u5bfc\u5165", operateType=5)
    @PostMapping(value={"/importExcel"})
    @RequiresPermissions(value={"system#excelByConfig:importExcel"})
    public Result<?> importExcel(HttpServletRequest request) {
        String headId = request.getParameter("id");
        String handlerName = request.getParameter("handlerName");
        Assert.hasText((String)handlerName, (String)I18nUtil.translate((String)"i18n_alert_empty_header_name", (String)"handlerName\u4e0d\u80fd\u4e3a\u7a7a"));
        ExcelByConfigDTO dto = new ExcelByConfigDTO();
        dto.setHeadId(headId);
        dto.setHandlerName(handlerName);
        dto.setTemplateAccount(request.getParameter("templateAccount"));
        dto.setTemplateNumber(request.getParameter("templateNumber"));
        dto.setTemplateVersion(request.getParameter("templateVersion"));
        dto.setGroupCode(request.getParameter("groupCode"));
        dto.setRoleCode(request.getParameter("roleCode"));
        dto.setExcelCode(request.getParameter("excelCode"));
        dto.setExcelName(request.getParameter("excelName"));
        dto.setExcelTemplateType(request.getParameter("excelTemplateType"));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Map<Object, Object> data = new HashMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            String fileSuffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
            if (!"xlsx".equals(fileSuffix) && !"xls".equals(fileSuffix)) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_ROuNWWWWWQI_974a414a", (String)"\u53ea\u80fd\u5bfc\u5165excel\u6587\u4ef6"));
            }
            data = this.service.importExcel(dto, file);
        }
        return Result.ok(data);
    }
}

