/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.third.entity.ConnectorConfig;
import com.els.modules.third.excel.ConnectorConfigExportServiceImpl;
import com.els.modules.third.service.ConnectorConfigService;
import com.els.modules.third.vo.CreateJsonStructureVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u5e73\u53f0\u8fde\u63a5\u5668"})
@RestController
@RequestMapping(value={"/base/connectorConfig"})
public class ConnectorConfigController
extends BaseController<ConnectorConfig, ConnectorConfigService> {
    private static final Logger log = LoggerFactory.getLogger(ConnectorConfigController.class);
    @Autowired
    private ConnectorConfigService connectorConfigService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"connector#connectorConfig:list"})
    public Result<?> queryPageList(ConnectorConfig connectorConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)connectorConfig), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        IPage pageList = this.connectorConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/sysList"})
    @RequiresPermissions(value={"connector#connectorConfig:sysList"})
    public Result<?> queryPageSysList(ConnectorConfig connectorConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)connectorConfig), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.connectorConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u8868-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"connector#connectorConfig:add"})
    public Result<?> add(@RequestBody ConnectorConfig connectorConfig) {
        this.connectorConfigService.add(connectorConfig);
        return Result.ok((Object)((Object)connectorConfig));
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u8868-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"connector#connectorConfig:edit"})
    public Result<?> edit(@RequestBody ConnectorConfig connectorConfig) {
        this.connectorConfigService.edit(connectorConfig);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u8868-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"connector#connectorConfig:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.connectorConfigService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u8868-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"connector#connectorConfig:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.connectorConfigService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"connector#connectorConfig:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ConnectorConfig connectorConfig = (ConnectorConfig)((Object)this.connectorConfigService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)connectorConfig));
    }

    @ApiOperation(value="\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7", notes="\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7")
    @GetMapping(value={"/addToEnterprise"})
    @RequiresPermissions(value={"connector#connectorConfig:addToEnterprise"})
    public Result<?> addToEnterprise(@RequestParam(name="id") String id) {
        this.connectorConfigService.addToEnterprise(id);
        return Result.ok((Object)2);
    }

    @AutoLog(value="\u8fde\u63a5\u5668\u63a5\u53e3\u8868-\u5bfc\u51fa")
    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"connector#connectorConfig:exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        object.put("sysAutoSetAccount", TenantContext.getTenant());
        return super.exportXls(request, object, ConnectorConfigExportServiceImpl.class);
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u63a5\u53e3\u8868-\u5bfc\u51fa")
    @PostMapping(value={"/sysExportXls"})
    @RequiresPermissions(value={"connector#connectorConfig:sysExportXls"})
    public ModelAndView sysExportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        object.put("sysAutoSetAccount", SysUtil.getPurchaseAccount());
        return super.exportXls(request, object, ConnectorConfigExportServiceImpl.class);
    }

    @AutoLog(value="\u8fde\u63a5\u5668\u63a5\u53e3\u8868-\u5bfc\u51fa")
    @PostMapping(value={"/jsonExport"})
    @RequiresPermissions(value={"connector#connectorConfig:jsonExport"})
    public Result<?> jsonExport(@RequestBody List<String> ids) {
        List list = this.connectorConfigService.listByIds(ids);
        list.forEach(this::clearData);
        JSONArray jsonArray = JSONArray.parseArray((String)JSON.toJSONString((Object)list));
        return Result.ok((Object)jsonArray);
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u63a5\u53e3\u8868-\u5bfc\u5165")
    @PostMapping(value={"/jsonImport"})
    @RequiresPermissions(value={"connector#connectorConfig:jsonImport"})
    public Result<?> jsonImport(@RequestBody CreateJsonStructureVO structureVO) throws Exception {
        this.connectorConfigService.jsonImport(structureVO.getJsonString());
        return Result.ok();
    }

    private void clearData(BaseEntity entity) {
        entity.setCreateBy(null);
        entity.setUpdateBy(null);
        entity.setCreateTime(null);
        entity.setUpdateTime(null);
        entity.setCreateById(null);
        entity.setUpdateById(null);
        entity.setDeleted(null);
    }
}

