/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.rocketMq.util;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.messaging.support.MessageBuilder;

public class InitPrintDataMqUtil {
    private static final Logger log = LoggerFactory.getLogger(InitPrintDataMqUtil.class);
    private static ExecutorService THREAD_POOL = new ThreadPoolExecutor(5, 20, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    public static void sendInitMsg(final String msg) {
        if (StrUtil.isBlank((CharSequence)msg)) {
            return;
        }
        final String key = IdWorker.getIdStr();
        final String elsAccount = TenantContext.getTenant();
        THREAD_POOL.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    InvokeBaseRpcService service = (InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class);
                    service.saveRecord(elsAccount, key, msg, "printMessage");
                    StreamBridge reportSource = (StreamBridge)SpringContextUtils.getBean(StreamBridge.class);
                    if (reportSource != null) {
                        reportSource.send("inputPrintReport-out-0", (Object)MessageBuilder.withPayload((Object)msg).setHeader("KEYS", (Object)IdWorker.getIdStr()).build());
                    }
                }
                catch (Exception e) {
                    log.error("sendBusMsg_failed:", (Throwable)e);
                }
            }
        });
    }
}

