/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.controller;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.enumerate.ConnectorMappingTypeEnum;
import com.els.modules.template.entity.TemplateConfigHead;
import com.els.modules.template.entity.TemplateConfigItem;
import com.els.modules.template.entity.TemplateGroup;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.enumerate.TemplateStatusEnum;
import com.els.modules.template.service.TemplateConfigHeadService;
import com.els.modules.template.service.TemplateConfigItemService;
import com.els.modules.template.service.TemplateGroupService;
import com.els.modules.template.service.TemplateHeadService;
import com.els.modules.third.entity.ConnectorFieldMapping;
import com.els.modules.third.service.ConnectorFieldMappingService;
import com.els.modules.third.util.JSONParsingUtil;
import com.els.modules.third.vo.ConnectorFieldTemplateMappingVO;
import com.els.modules.third.vo.CreateJsonStructureVO;
import com.els.modules.third.vo.JSONConversionVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.compress.utils.Lists;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e73\u53f0\u8fde\u63a5\u5668\u5b57\u6bb5\u6620\u5c04"})
@RestController
@RequestMapping(value={"/base/connectorFieldMapping"})
public class ConnectorFieldMappingController
extends BaseController<ConnectorFieldMapping, ConnectorFieldMappingService> {
    @Autowired
    private ConnectorFieldMappingService connectorFieldMappingService;
    @Autowired
    private TemplateHeadService templateHeadService;
    @Autowired
    private TemplateGroupService templateGroupService;
    @Autowired
    private TemplateConfigHeadService templateConfigHeadService;
    @Autowired
    private TemplateConfigItemService templateConfigItemService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"connector#connectorFieldMapping:list"})
    public Result<?> queryPageList(ConnectorFieldMapping connectorFieldMapping, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)connectorFieldMapping), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.connectorFieldMappingService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u5b57\u6bb5\u6620\u5c04\u8868-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"connector#connectorFieldMapping:add"})
    public Result<?> add(@RequestBody ConnectorFieldMapping connectorFieldMapping) {
        this.connectorFieldMappingService.add(connectorFieldMapping);
        return Result.ok((Object)((Object)connectorFieldMapping));
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u5b57\u6bb5\u6620\u5c04\u8868-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"connector#connectorFieldMapping:edit"})
    public Result<?> edit(@RequestBody ConnectorFieldMapping connectorFieldMapping) {
        this.connectorFieldMappingService.edit(connectorFieldMapping);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u5b57\u6bb5\u6620\u5c04\u8868-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"connector#connectorFieldMapping:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.connectorFieldMappingService.delete(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ConnectorFieldMapping connectorFieldMapping = (ConnectorFieldMapping)((Object)this.connectorFieldMappingService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)connectorFieldMapping));
    }

    @ApiOperation(value="\u89e3\u6790json\u7ed3\u6784", notes="\u89e3\u6790json\u7ed3\u6784")
    @PostMapping(value={"/importJson"})
    @RequiresPermissions(value={"connector#connectorFieldMapping:importJson"})
    public Result<?> importJson(@RequestBody CreateJsonStructureVO structureVO) {
        if (CharSequenceUtil.isEmpty((CharSequence)structureVO.getJsonString())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VuNWWWWWF_f5f40606", (String)"\u8bf7\u5bfc\u5165json\u6570\u636e"));
        }
        List<JSONConversionVO> list = JSONParsingUtil.parsing(structureVO);
        return Result.ok(list);
    }

    @GetMapping(value={"/queryTemplateForConnector/{businessType}"})
    @RequiresPermissions(value={"connector#connectorInterface:listField"})
    public Result<?> queryTemplateForConnector(@PathVariable(value="businessType") String businessType) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TemplateHead::getBusinessType, (Object)businessType)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(TemplateHead::getTemplateStatus, (Object)TemplateStatusEnum.GENERATED.getValue());
        wrapper.last(" limit 1");
        wrapper.orderByDesc(TemplateHead::getDefaultType);
        wrapper.orderByDesc(BaseEntity::getUpdateTime);
        TemplateHead one = (TemplateHead)((Object)this.templateHeadService.getOne((Wrapper)wrapper));
        if (null == one) {
            wrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TemplateHead::getBusinessType, (Object)businessType)).eq(BaseEntity::getElsAccount, (Object)"100000")).eq(TemplateHead::getTemplateStatus, (Object)TemplateStatusEnum.GENERATED.getValue());
            wrapper.last(" limit 1");
            wrapper.orderByDesc(TemplateHead::getDefaultType);
            wrapper.orderByDesc(BaseEntity::getUpdateTime);
            one = (TemplateHead)((Object)this.templateHeadService.getOne((Wrapper)wrapper));
        }
        if (null == one) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_ESIrxMKWShnMuESIrAWF_63c8e876", (String)"\u4e1a\u52a1\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u62c9\u53d6\u5230\u4e1a\u52a1\u6a21\u677f\u5217\u6570\u636e"));
        }
        return Result.ok((Object)((Object)one));
    }

    @GetMapping(value={"/queryTemplateColumnForConnectorById/{templateId}"})
    @RequiresPermissions(value={"connector#connectorInterface:listField"})
    public Result<?> queryTemplateColumnForConnectorById(@PathVariable(value="templateId") String templateId, @RequestParam(value="keyWord", defaultValue="") String keyWord, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        TemplateHead templateHead = (TemplateHead)((Object)this.templateHeadService.getById((Serializable)((Object)templateId)));
        if (null == templateHead) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_ESIrxMKWShnMuESIrAWF_63c8e876", (String)"\u4e1a\u52a1\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u62c9\u53d6\u5230\u4e1a\u52a1\u6a21\u677f\u5217\u6570\u636e"));
        }
        List<TemplateGroup> groupList = this.templateGroupService.selectByMainId(templateId);
        List<TemplateConfigHead> headItemList = this.templateConfigHeadService.selectByMainId(templateId);
        List<TemplateConfigItem> itemList = this.templateConfigItemService.selectByMainId(templateId);
        Map<String, String> groupMap = groupList.stream().filter(x -> "head".equals(x.getGroupType()) || "item".equals(x.getGroupType())).collect(Collectors.toMap(TemplateGroup::getGroupCode, x -> I18nUtil.translate((String)x.getGroupNameI18nKey(), (String)x.getGroupName()), (v1, v2) -> v2));
        List<Object> dataList = Lists.newArrayList();
        ArrayList finalDataList = dataList;
        headItemList.forEach(head -> {
            String name;
            ConnectorFieldTemplateMappingVO headVo = new ConnectorFieldTemplateMappingVO();
            headVo.setMappingField(head.getFieldName());
            headVo.setDefaultValue(headVo.getDefaultValue());
            headVo.setMappingFieldName(I18nUtil.translate((String)head.getFieldLabelI18nKey(), (String)head.getFieldLabel()));
            headVo.setRequired(head.getRequired());
            headVo.setFieldType("String");
            if (CharSequenceUtil.isEmpty((CharSequence)head.getDefaultValue())) {
                headVo.setUseDefault("0");
            } else {
                headVo.setUseDefault("1");
            }
            headVo.setConversion("1");
            headVo.setMappingTable(ConnectorMappingTypeEnum.HEAD.getValue());
            if (CharSequenceUtil.isNotEmpty((CharSequence)head.getGroupCode()) && CharSequenceUtil.isNotEmpty((CharSequence)(name = (String)groupMap.get(head.getGroupCode())))) {
                headVo.setMappingGroupName(name);
            }
            headVo.setMappingGroupCode("");
            finalDataList.add(headVo);
        });
        itemList.forEach(head -> {
            ConnectorFieldTemplateMappingVO headVo = new ConnectorFieldTemplateMappingVO();
            headVo.setMappingField(head.getFieldName());
            headVo.setDefaultValue(headVo.getDefaultValue());
            headVo.setMappingFieldName(I18nUtil.translate((String)head.getFieldLabelI18nKey(), (String)head.getFieldLabel()));
            headVo.setRequired(head.getRequired());
            headVo.setFieldType("String");
            if (CharSequenceUtil.isEmpty((CharSequence)head.getDefaultValue())) {
                headVo.setUseDefault("0");
            } else {
                headVo.setUseDefault("1");
            }
            headVo.setConversion("1");
            headVo.setMappingTable(ConnectorMappingTypeEnum.ITEM.getValue());
            if (CharSequenceUtil.isNotEmpty((CharSequence)head.getGroupCode())) {
                String name = (String)groupMap.get(head.getGroupCode());
                if (CharSequenceUtil.isNotEmpty((CharSequence)name)) {
                    headVo.setMappingGroupName(name);
                    headVo.setMappingGroupCode(head.getGroupCode());
                }
            } else {
                Optional<TemplateGroup> base = groupList.stream().filter(x -> "item".equals(x.getGroupType())).findAny();
                if (base.isPresent()) {
                    TemplateGroup group = base.get();
                    headVo.setMappingGroupName(I18nUtil.translate((String)group.getGroupNameI18nKey(), (String)group.getGroupName()));
                    headVo.setMappingGroupCode(group.getGroupCode());
                }
            }
            finalDataList.add(headVo);
        });
        dataList = dataList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ConnectorFieldTemplateMappingVO>(Comparator.comparing(x -> x.getMappingTable() + ";" + x.getMappingGroupCode() + ";" + x.getMappingField()))), ArrayList::new));
        if (CharSequenceUtil.isNotEmpty((CharSequence)keyWord)) {
            dataList = dataList.stream().filter(x -> x.getMappingFieldName().contains(keyWord) || x.getMappingField().contains(keyWord)).collect(Collectors.toList());
        }
        List pageList = dataList.stream().skip((long)(pageNo - 1) * (long)pageSize.intValue()).limit(pageSize.intValue()).collect(Collectors.toList());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        page.setRecords(pageList);
        page.setTotal((long)dataList.size());
        return Result.ok((Object)page);
    }

    @GetMapping(value={"/listTemplateByBusinessType"})
    @RequiresPermissions(value={"connector#connectorInterface:listField"})
    public Result<?> listTemplateByBusinessType(@RequestParam(value="businessType") String businessType, @RequestParam(value="keyWord", defaultValue="") String keyWord, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        TemplateHead head = new TemplateHead();
        head.setBusinessType(businessType);
        head.setKeyWord(keyWord);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(TemplateHead::getTemplateStatus, (Object)TemplateStatusEnum.GENERATED.getValue());
        IPage pageList = this.templateHeadService.page((IPage)page, (Wrapper)queryWrapper);
        if (pageList.getTotal() == 0L) {
            queryWrapper.clear();
            queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), (Map)req.getParameterMap());
            ((LambdaQueryWrapper)queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)"100000")).eq(TemplateHead::getTemplateStatus, (Object)TemplateStatusEnum.GENERATED.getValue());
            pageList = this.templateHeadService.page((IPage)page, (Wrapper)queryWrapper);
        }
        return Result.ok((Object)pageList);
    }
}

