/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.els.api.dto.PageData;
import com.els.api.dto.TableDefineColumnDto;
import com.els.api.dto.TableFieldDto;
import com.els.api.dto.TableIndexDto;
import com.els.api.dto.TableInfoDto;
import com.els.api.dto.TableInfoQueryDto;
import com.els.api.dto.TemplateCreateDto;
import com.els.common.api.service.ClassTypeRpcService;
import com.els.common.api.service.TableLoaderRpcService;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.enums.DubboServiceGroup;
import com.els.modules.system.enums.MySQLReservedKeyword;
import com.els.modules.system.enums.TableColumnDataType;
import com.els.modules.system.util.TableFieldUtil;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/t"})
public class TableController {
    private static final Logger log = LoggerFactory.getLogger(TableController.class);
    @Autowired
    private ClassTypeRpcService classTypeRpcService;
    @Resource(name="tableEntityRedisTemplate")
    private RedisTemplate<String, Object> tableEntityRedisTemplate;
    private static final String SINGLE_KEY = "singleTableLoaderServiceImpl";
    @Autowired
    private RedisUtil redisUtil;

    @ApiOperation(value="\u6dfb\u52a0\u8868\u5b57\u6bb5", notes="\u6dfb\u52a0\u8868\u5b57\u6bb5")
    @PostMapping(value={"/addColumn"})
    public Result<Object> addColumn(@RequestBody TemplateCreateDto dto) {
        if (!SysUtil.getPurchaseAccount().equals(TenantContext.getTenant()) || !"1".equals(AdminFlagUtil.getAdminFlag())) {
            throw new ELSBootException("\u65e0\u64cd\u4f5c\u6743\u9650");
        }
        if (!this.redisUtil.hHasKey("srm:length:table", dto.getHeadTable())) {
            throw new ELSBootException("\u5f53\u524d\u8868\u64cd\u4f5c\u8bf7\u524d\u5f80\u6570\u636e\u5e93\u64cd\u4f5c");
        }
        String serviceInstanceId = dto.getServiceInstanceId();
        String headTable = dto.getHeadTable();
        TableFieldDto column = dto.getColumn();
        if (CharSequenceUtil.isEmpty((CharSequence)serviceInstanceId) || CharSequenceUtil.isEmpty((CharSequence)headTable) || null == dto.getColumn()) {
            throw new ELSBootException("\u53c2\u6570\u4e0d\u6ee1\u8db3");
        }
        if (CharSequenceUtil.isEmpty((CharSequence)column.getColumnComment()) || CharSequenceUtil.isEmpty((CharSequence)column.getColumnName()) || CharSequenceUtil.isEmpty((CharSequence)column.getCharacterMaximumLength()) || CharSequenceUtil.isEmpty((CharSequence)column.getDataType())) {
            throw new ELSBootException("\u53c2\u6570\u4e0d\u6ee1\u8db3");
        }
        if (!TableColumnDataType.contains(column.getDataType())) {
            throw new ELSBootException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b[{}]", new String[]{column.getDataType()});
        }
        if (MySQLReservedKeyword.contains(column.getColumnName())) {
            throw new ELSBootException("\u4e0d\u652f\u6301\u7684\u5217\u540d[{}]", new String[]{column.getColumnName()});
        }
        Map rpcMap = this.classTypeRpcService.getExcelDataLoader((List)Lists.newArrayList((Object[])new String[]{dto.getServiceInstanceId()}));
        if (CollectionUtil.isEmpty((Map)rpcMap)) {
            throw new ELSBootException("\u5f53\u524d\u670d\u52a1\u4e0b\u8868\u4e0d\u5b58\u5728");
        }
        TableLoaderRpcService rpcService = (TableLoaderRpcService)rpcMap.get(serviceInstanceId);
        if (null == rpcService) {
            throw new ELSBootException("\u5f53\u524d\u670d\u52a1\u4e0b\u8868\u4e0d\u5b58\u5728");
        }
        List<TableFieldDto> tableField = this.rpcQueryTableField(rpcService, Collections.singletonList(dto.getHeadTable()));
        if (tableField.isEmpty()) {
            throw new ELSBootException("\u5f53\u524d\u670d\u52a1\u4e0b\u8868\u4e0d\u5b58\u5728");
        }
        long count = tableField.stream().filter(x -> column.getColumnName().equals(x.getColumnName())).count();
        if (count > 0L) {
            throw new ELSBootException("\u8868\u5b57\u6bb5\u5df2\u5b58\u5728");
        }
        StringBuilder sqlSb = new StringBuilder("");
        sqlSb.append("alter table ").append(headTable).append(" add column `").append(column.getColumnName()).append("` ").append(column.getDataType()).append(" ");
        if (TableColumnDataType.needLength(column.getDataType())) {
            sqlSb.append(" (").append(column.getCharacterMaximumLength()).append(") ");
        }
        if ("1".equals(column.getIsNullable())) {
            sqlSb.append("not null ");
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)column.getColumnDefault())) {
            sqlSb.append("default '").append(column.getColumnDefault()).append("' ");
        }
        sqlSb.append("comment '").append(column.getColumnComment()).append("'; ");
        try {
            rpcService.runModifyColumnSql(sqlSb.toString());
        }
        catch (Exception e) {
            if (e instanceof BadSqlGrammarException) {
                throw new ELSBootException(e.getCause().getMessage());
            }
            throw new ELSBootException(e.getMessage());
        }
        return Result.ok((Object)true);
    }

    @ApiOperation(value="\u53d8\u66f4\u8868\u5b57\u6bb5\u957f\u5ea6", notes="\u53d8\u66f4\u8868\u5b57\u6bb5\u957f\u5ea6")
    @PostMapping(value={"/modifyColumnDesc"})
    public Result<Object> modifyColumnDesc(@RequestBody TemplateCreateDto dto) {
        if (!SysUtil.getPurchaseAccount().equals(TenantContext.getTenant()) || !"1".equals(AdminFlagUtil.getAdminFlag())) {
            throw new ELSBootException("\u65e0\u64cd\u4f5c\u6743\u9650");
        }
        if (!this.redisUtil.hHasKey("srm:length:table", dto.getHeadTable())) {
            throw new ELSBootException("\u5f53\u524d\u8868\u64cd\u4f5c\u8bf7\u524d\u5f80\u6570\u636e\u5e93\u64cd\u4f5c");
        }
        String serviceInstanceId = dto.getServiceInstanceId();
        String headTable = dto.getHeadTable();
        List columnList = dto.getColumnList();
        String columnDesc = dto.getColumnDesc();
        if (CharSequenceUtil.isEmpty((CharSequence)serviceInstanceId) || CharSequenceUtil.isEmpty((CharSequence)headTable) || CollectionUtil.isEmpty((Collection)columnList) || CharSequenceUtil.isEmpty((CharSequence)columnDesc)) {
            throw new ELSBootException("\u53c2\u6570\u4e0d\u6ee1\u8db3");
        }
        Map rpcMap = this.classTypeRpcService.getExcelDataLoader((List)Lists.newArrayList((Object[])new String[]{serviceInstanceId}));
        if (CollectionUtil.isEmpty((Map)rpcMap)) {
            throw new ELSBootException("\u5f53\u524d\u670d\u52a1\u4e0b\u8868\u6216\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        TableLoaderRpcService rpcService = (TableLoaderRpcService)rpcMap.get(serviceInstanceId);
        if (null == rpcService) {
            throw new ELSBootException("\u5f53\u524d\u670d\u52a1\u4e0b\u8868\u6216\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        List<TableFieldDto> tableField = this.rpcQueryTableField(rpcService, Collections.singletonList(dto.getHeadTable()));
        if (tableField.isEmpty()) {
            throw new ELSBootException("\u5f53\u524d\u670d\u52a1\u4e0b\u8868\u6216\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        Map tableFieldMap = tableField.stream().filter(x -> columnList.contains(x.getColumnName())).collect(Collectors.toMap(TableFieldDto::getColumnName, Function.identity(), (v1, v2) -> v2));
        if (tableFieldMap.isEmpty()) {
            throw new ELSBootException("\u5f53\u524d\u670d\u52a1\u4e0b\u8868\u6216\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        StringBuilder sqlSb = new StringBuilder("");
        Set<String> strings = tableFieldMap.keySet();
        for (String field : strings) {
            TableFieldDto fieldDto = (TableFieldDto)tableFieldMap.get(field);
            sqlSb.append("alter table ").append(headTable).append(" modify column `").append(field).append("` ").append(fieldDto.getColumnType()).append(" ");
            if (CharSequenceUtil.isNotEmpty((CharSequence)fieldDto.getCharacterSetName())) {
                sqlSb.append("character set ").append(fieldDto.getCharacterSetName()).append(" ");
            }
            if (CharSequenceUtil.isNotEmpty((CharSequence)fieldDto.getCollationName())) {
                sqlSb.append("collate ").append(fieldDto.getCollationName()).append(" ");
            }
            if ("NO".equals(fieldDto.getIsNullable()) || "no".equals(fieldDto.getIsNullable())) {
                sqlSb.append("not null ");
            }
            if (null != fieldDto.getColumnDefault()) {
                sqlSb.append("default '").append(fieldDto.getColumnDefault()).append("' ");
            } else if (!"NO".equals(fieldDto.getIsNullable()) && !"no".equals(fieldDto.getIsNullable())) {
                sqlSb.append("default null ");
            }
            sqlSb.append("comment '").append(columnDesc).append("'; ");
        }
        try {
            rpcService.runModifyColumnSql(sqlSb.toString());
        }
        catch (Exception e) {
            if (e instanceof BadSqlGrammarException) {
                throw new ELSBootException(e.getCause().getMessage());
            }
            throw new ELSBootException(e.getMessage());
        }
        return Result.ok((Object)true);
    }

    @ApiOperation(value="\u53d8\u66f4\u8868\u5b57\u6bb5\u957f\u5ea6", notes="\u53d8\u66f4\u8868\u5b57\u6bb5\u957f\u5ea6")
    @PostMapping(value={"/modifyColumnLength"})
    public Result<Object> modifyColumnLength(@RequestBody TemplateCreateDto dto) {
        if (!SysUtil.getPurchaseAccount().equals(TenantContext.getTenant()) || !"1".equals(AdminFlagUtil.getAdminFlag())) {
            throw new ELSBootException("\u65e0\u64cd\u4f5c\u6743\u9650");
        }
        if (!this.redisUtil.hHasKey("srm:length:table", dto.getHeadTable())) {
            throw new ELSBootException("\u5f53\u524d\u8868\u64cd\u4f5c\u8bf7\u524d\u5f80\u6570\u636e\u5e93\u64cd\u4f5c");
        }
        String serviceInstanceId = dto.getServiceInstanceId();
        String headTable = dto.getHeadTable();
        List columnList = dto.getColumnList();
        Integer length = dto.getLength();
        if (CharSequenceUtil.isEmpty((CharSequence)serviceInstanceId) || CharSequenceUtil.isEmpty((CharSequence)headTable) || CollectionUtil.isEmpty((Collection)columnList) || null == length || length <= 0) {
            throw new ELSBootException("\u53c2\u6570\u4e0d\u6ee1\u8db3");
        }
        Map rpcMap = this.classTypeRpcService.getExcelDataLoader((List)Lists.newArrayList((Object[])new String[]{serviceInstanceId}));
        if (CollectionUtil.isEmpty((Map)rpcMap)) {
            throw new ELSBootException("\u5f53\u524d\u670d\u52a1\u4e0b\u8868\u6216\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        TableLoaderRpcService rpcService = (TableLoaderRpcService)rpcMap.get(serviceInstanceId);
        if (null == rpcService) {
            throw new ELSBootException("\u5f53\u524d\u670d\u52a1\u4e0b\u8868\u6216\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        List<TableFieldDto> tableField = this.rpcQueryTableField(rpcService, Collections.singletonList(dto.getHeadTable()));
        if (tableField.isEmpty()) {
            throw new ELSBootException("\u5f53\u524d\u670d\u52a1\u4e0b\u8868\u6216\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        Map tableFieldMap = tableField.stream().filter(x -> columnList.contains(x.getColumnName()) && "varchar".equals(x.getDataType())).collect(Collectors.toMap(TableFieldDto::getColumnName, Function.identity(), (v1, v2) -> v2));
        if (tableFieldMap.isEmpty()) {
            throw new ELSBootException("\u5f53\u524d\u670d\u52a1\u4e0b\u8868\u6216\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        Optional<TableFieldDto> max = tableFieldMap.values().stream().max(Comparator.comparingInt(x -> Integer.parseInt(x.getCharacterMaximumLength())));
        Integer maxLength = Integer.parseInt(max.get().getCharacterMaximumLength());
        if (length < maxLength) {
            throw new ELSBootException("\u66f4\u6539\u7684\u5b57\u6bb5\u957f\u5ea6\u4e0d\u5408\u9002\uff0c\u957f\u5ea6\u503c\u5fc5\u987b\u5927\u6216\u7b49\u4e8e\u6240\u9009\u5b57\u6bb5\u957f\u5ea6\u7684\u6700\u5927\u503c");
        }
        StringBuilder sqlSb = new StringBuilder("");
        Set<String> strings = tableFieldMap.keySet();
        for (String field : strings) {
            TableFieldDto fieldDto = (TableFieldDto)tableFieldMap.get(field);
            sqlSb.append("alter table ").append(headTable).append(" modify column `").append(field).append("` varchar(").append(length).append(") ");
            if (CharSequenceUtil.isNotEmpty((CharSequence)fieldDto.getCharacterSetName())) {
                sqlSb.append("character set ").append(fieldDto.getCharacterSetName()).append(" ");
            }
            if (CharSequenceUtil.isNotEmpty((CharSequence)fieldDto.getCollationName())) {
                sqlSb.append("collate ").append(fieldDto.getCollationName()).append(" ");
            }
            if ("NO".equals(fieldDto.getIsNullable()) || "no".equals(fieldDto.getIsNullable())) {
                sqlSb.append("not null ");
            }
            if (null != fieldDto.getColumnDefault()) {
                sqlSb.append("default '").append(fieldDto.getColumnDefault()).append("' ");
            } else if (!"NO".equals(fieldDto.getIsNullable()) && !"no".equals(fieldDto.getIsNullable())) {
                sqlSb.append("default null ");
            }
            sqlSb.append("comment '").append(fieldDto.getColumnComment()).append("'; ");
        }
        try {
            rpcService.runModifyColumnSql(sqlSb.toString());
            this.tableEntityRedisTemplate.convertAndSend("tableEntityRefresh", (Object)Lists.newArrayList((Object[])new String[]{headTable}));
        }
        catch (Exception e) {
            if (e instanceof BadSqlGrammarException) {
                throw new ELSBootException(e.getCause().getMessage());
            }
            throw new ELSBootException(e.getMessage());
        }
        return Result.ok((Object)true);
    }

    private Map<String, List<TableDefineColumnDto>> queryTableDefineColumn(List<TableInfoQueryDto> dtos) {
        List instanceIds = dtos.stream().map(TableInfoQueryDto::getServiceInstanceId).collect(Collectors.toList());
        Map rpcMap = this.classTypeRpcService.getExcelDataLoader(instanceIds);
        if (CollectionUtil.isEmpty((Map)rpcMap)) {
            throw new ELSBootException("\u5f53\u524d\u670d\u52a1\u4e0b\u8868\u6216\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        ArrayList<TableFieldDto> tableFieldBos = new ArrayList<TableFieldDto>();
        Map tableMap = dtos.stream().collect(Collectors.groupingBy(TableInfoQueryDto::getServiceInstanceId, Collectors.mapping(TableInfoQueryDto::getTableName, Collectors.toList())));
        for (String instance : tableMap.keySet()) {
            List<String> tableList = tableMap.get(instance);
            List<TableFieldDto> fieldDtoList = this.rpcQueryTableField((TableLoaderRpcService)rpcMap.get(instance), tableList);
            tableFieldBos.addAll(fieldDtoList);
        }
        Map<String, List<TableFieldDto>> groupByTableMap = tableFieldBos.stream().collect(Collectors.groupingBy(TableFieldDto::getTableName));
        HashMap<String, List<TableDefineColumnDto>> columnMap = new HashMap<String, List<TableDefineColumnDto>>();
        groupByTableMap.forEach((tableName, columns) -> {
            ArrayList result = Lists.newArrayList();
            for (TableFieldDto dto : columns) {
                TableDefineColumnDto columnDto = new TableDefineColumnDto();
                columnDto.setFieldName(TableFieldUtil.initialToCapital(dto.getColumnName().toLowerCase()));
                columnDto.setFieldDbName(dto.getColumnName());
                columnDto.setFieldType(TableFieldUtil.getFiledCodeType(dto.getDataType(), dto.getNumericPrecision(), dto.getNumericScale()));
                columnDto.setFieldDbType(TableFieldUtil.initialToCapital(dto.getDataType()));
                columnDto.setPrecision(dto.getNumericPrecision());
                columnDto.setScale(dto.getNumericScale());
                columnDto.setCharacterMaximumLength(dto.getCharacterMaximumLength());
                columnDto.setNullable(dto.getIsNullable());
                columnDto.setFiledComment(StrUtil.isBlank((CharSequence)dto.getColumnComment()) ? columnDto.getFieldName() : dto.getColumnComment());
                TableFieldUtil.initTableField2CodeField(columnDto);
                result.add(columnDto);
            }
            columnMap.put((String)tableName, result);
        });
        return columnMap;
    }

    @GetMapping(value={"/queryTableInfo"})
    public Result<?> queryTableInfo(TableInfoQueryDto tableInfoDto) {
        Map rpcMap = this.classTypeRpcService.getExcelDataLoader(DubboServiceGroup.GROUP_NAME);
        if (CollectionUtil.isEmpty((Map)rpcMap)) {
            return Result.ok((Object)Lists.newArrayList());
        }
        if (rpcMap.containsKey(SINGLE_KEY)) {
            PageData tableInfoDtos = ((TableLoaderRpcService)rpcMap.get(SINGLE_KEY)).queryTables(tableInfoDto);
            for (TableInfoDto dto : tableInfoDtos.getRecords()) {
                dto.setServiceInstanceId(SINGLE_KEY);
            }
            return Result.ok((Object)tableInfoDtos);
        }
        int pageNumber = tableInfoDto.getPageNo();
        Integer pageSize = tableInfoDto.getPageSize();
        List<Object> result = new ArrayList();
        for (String instanceId : rpcMap.keySet()) {
            TableLoaderRpcService rpcService = (TableLoaderRpcService)rpcMap.get(instanceId);
            PageData<TableInfoDto> tableInfoDtos = this.rpcQueryTables(rpcService, tableInfoDto);
            for (TableInfoDto dto : tableInfoDtos.getRecords()) {
                dto.setServiceInstanceId(instanceId);
            }
            result.addAll(tableInfoDtos.getRecords());
        }
        int size = result.size();
        result = result.stream().skip((long)(pageNumber - 1) * (long)pageSize.intValue()).limit(pageSize.intValue()).collect(Collectors.toList());
        return Result.ok((Object)new PageData(result, (long)size));
    }

    @PostMapping(value={"/queryTableField"})
    public Result<?> queryTableField(@RequestBody List<TableInfoQueryDto> dtos) {
        List instanceIds = dtos.stream().map(TableInfoQueryDto::getServiceInstanceId).collect(Collectors.toList());
        Map rpcMap = this.classTypeRpcService.getExcelDataLoader(instanceIds);
        if (CollectionUtil.isEmpty((Map)rpcMap)) {
            return Result.ok((Object)Lists.newArrayList());
        }
        ArrayList<TableFieldDto> result = new ArrayList<TableFieldDto>();
        Map tableMap = dtos.stream().collect(Collectors.groupingBy(TableInfoQueryDto::getServiceInstanceId, Collectors.mapping(TableInfoQueryDto::getTableName, Collectors.toList())));
        for (String instance : tableMap.keySet()) {
            List<String> tableList = tableMap.get(instance);
            List<TableFieldDto> fieldDtoList = this.rpcQueryTableField((TableLoaderRpcService)rpcMap.get(instance), tableList);
            result.addAll(fieldDtoList);
        }
        return Result.ok(result);
    }

    private PageData<TableInfoDto> rpcQueryTables(TableLoaderRpcService rpcService, TableInfoQueryDto tableInfoDto) {
        PageData tableInfoDtoPageData = new PageData((List)Lists.newArrayList(), 0L);
        try {
            tableInfoDtoPageData = rpcService.queryTables(tableInfoDto);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return tableInfoDtoPageData;
    }

    List<TableFieldDto> rpcQueryTableField(TableLoaderRpcService rpcService, List<String> tableName) {
        ArrayList<TableFieldDto> tableFieldDtos = new ArrayList();
        try {
            tableFieldDtos = rpcService.queryTableField(tableName);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return tableFieldDtos;
    }

    @PostMapping(value={"/queryTableIndex"})
    public Result<?> queryTableIndex(@RequestBody TableInfoQueryDto tableInfoDto) {
        if (CharSequenceUtil.isEmpty((CharSequence)tableInfoDto.getTableName())) {
            throw new ELSBootException("\u5f53\u524d\u670d\u52a1\u4e0b\u8868\u4e0d\u5b58\u5728");
        }
        if (!this.redisUtil.hHasKey("srm:length:table", tableInfoDto.getTableName())) {
            throw new ELSBootException("\u5f53\u524d\u8868\u64cd\u4f5c\u8bf7\u524d\u5f80\u6570\u636e\u5e93\u64cd\u4f5c");
        }
        Map rpcMap = this.classTypeRpcService.getExcelDataLoader((List)Lists.newArrayList((Object[])new String[]{tableInfoDto.getServiceInstanceId()}));
        if (CollectionUtil.isEmpty((Map)rpcMap)) {
            throw new ELSBootException("\u5f53\u524d\u670d\u52a1\u4e0b\u8868\u6216\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        TableLoaderRpcService rpcService = (TableLoaderRpcService)rpcMap.get(tableInfoDto.getServiceInstanceId());
        if (null == rpcService) {
            throw new ELSBootException("\u5f53\u524d\u670d\u52a1\u4e0b\u8868\u6216\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        List indexDtoList = rpcService.showTableIndex(tableInfoDto.getTableName());
        ArrayList allList = new ArrayList();
        Map<String, List<TableIndexDto>> schemaList = indexDtoList.stream().collect(Collectors.groupingBy(TableIndexDto::getTableSchema));
        for (String db : schemaList.keySet()) {
            List list = schemaList.get(db).stream().collect(Collectors.groupingBy(TableIndexDto::getKeyName)).values().stream().map(group -> {
                TableIndexDto tableIndex = (TableIndexDto)group.get(0);
                String name = group.stream().sorted(Comparator.comparingInt(TableIndexDto::getSeqInIndex)).map(TableIndexDto::getColumnName).collect(Collectors.joining(","));
                tableIndex.setSeqInIndex(Integer.valueOf(1));
                tableIndex.setColumnName(name);
                return tableIndex;
            }).collect(Collectors.toList());
            allList.addAll(list);
        }
        return Result.ok(allList);
    }
}

