/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.third.entity.ConnectorFieldMapping;
import com.els.modules.third.entity.ConnectorInterface;
import com.els.modules.third.excel.ConnectorInterfaceExportServiceImpl;
import com.els.modules.third.mapper.ConnectorInterfaceMapper;
import com.els.modules.third.service.ConnectorFieldMappingService;
import com.els.modules.third.service.ConnectorInterfaceService;
import com.els.modules.third.vo.ConnectorInterfaceVO;
import com.els.modules.third.vo.CreateJsonStructureVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u5e73\u53f0\u8fde\u63a5\u5668\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/base/connectorInterface"})
public class ConnectorInterfaceController
extends BaseController<ConnectorInterface, ConnectorInterfaceService> {
    private static final Logger log = LoggerFactory.getLogger(ConnectorInterfaceController.class);
    @Autowired
    private ConnectorInterfaceService connectorInterfaceService;
    @Autowired
    private ConnectorFieldMappingService connectorFieldMappingService;
    @Autowired
    private ConnectorInterfaceMapper connectorInterfaceMapper;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"connector#connectorInterface:list"})
    public Result<?> queryPageList(ConnectorInterface connectorInterface, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)connectorInterface), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.connectorInterfaceService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/sysList"})
    @RequiresPermissions(value={"connector#connectorInterface:sysList"})
    public Result<?> queryPageSysList(ConnectorInterface connectorInterface, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)connectorInterface), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.connectorInterfaceService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u63a5\u53e3\u8868-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"connector#connectorInterface:add"})
    public Result<?> add(@RequestBody ConnectorInterfaceVO connectorInterface) {
        ConnectorInterfaceVO head = new ConnectorInterfaceVO();
        BeanUtils.copyProperties((Object)((Object)connectorInterface), (Object)((Object)head));
        this.connectorInterfaceService.add(head, connectorInterface.getConnectorFieldMappingList());
        return Result.ok((Object)((Object)head));
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u63a5\u53e3\u8868-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"connector#connectorInterface:edit"})
    public Result<?> edit(@RequestBody ConnectorInterfaceVO connectorInterface) {
        ConnectorInterfaceVO head = new ConnectorInterfaceVO();
        BeanUtils.copyProperties((Object)((Object)connectorInterface), (Object)((Object)head));
        this.connectorInterfaceService.edit(head, connectorInterface.getConnectorFieldMappingList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u63a5\u53e3\u8868-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"connector#connectorInterface:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.connectorInterfaceService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"connector#connectorInterface:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ConnectorInterfaceVO connectorInterfaceVO = new ConnectorInterfaceVO();
        ConnectorInterface connectorInterface = (ConnectorInterface)((Object)this.connectorInterfaceService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        BeanUtils.copyProperties((Object)((Object)connectorInterface), (Object)((Object)connectorInterfaceVO));
        List<ConnectorFieldMapping> connectorFieldMappings = this.connectorFieldMappingService.selectByMainId(id);
        connectorInterfaceVO.setConnectorFieldMappingList(connectorFieldMappings);
        return Result.ok((Object)((Object)connectorInterfaceVO));
    }

    @ApiOperation(value="\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7", notes="\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7")
    @GetMapping(value={"/addToEnterprise"})
    @RequiresPermissions(value={"connector#connectorInterface:addToEnterprise"})
    public Result<?> addToEnterprise(@RequestParam(name="id") String id) {
        this.connectorInterfaceService.addToEnterprise(id);
        return Result.ok((Object)2);
    }

    @AutoLog(value="\u8fde\u63a5\u5668\u63a5\u53e3\u8868-\u5bfc\u51fa")
    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"connector#connectorInterface:exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        object.put("sysAutoSetAccount", TenantContext.getTenant());
        return super.exportXls(request, object, ConnectorInterfaceExportServiceImpl.class);
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u63a5\u53e3\u8868-\u5bfc\u51fa")
    @PostMapping(value={"/sysExportXls"})
    @RequiresPermissions(value={"connector#connectorInterface:sysExportXls"})
    public ModelAndView sysExportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        object.put("sysAutoSetAccount", SysUtil.getPurchaseAccount());
        return super.exportXls(request, object, ConnectorInterfaceExportServiceImpl.class);
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u63a5\u53e3\u8868-\u5bfc\u51fa")
    @PostMapping(value={"/jsonExport"})
    @RequiresPermissions(value={"connector#connectorInterface:jsonExport"})
    public Result<?> jsonExport(@RequestBody List<String> ids) {
        ArrayList<ConnectorInterfaceVO> list = new ArrayList<ConnectorInterfaceVO>();
        List interfaceList = this.connectorInterfaceService.listByIds(ids);
        interfaceList.forEach(this::clearData);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(ConnectorFieldMapping::getHeadId, ids);
        List mappingList = this.connectorFieldMappingService.list((Wrapper)wrapper);
        mappingList.forEach(this::clearData);
        Map<String, List<ConnectorFieldMapping>> mappingFiledMap = mappingList.stream().collect(Collectors.groupingBy(ConnectorFieldMapping::getHeadId));
        for (ConnectorInterface connectorInterface : interfaceList) {
            ConnectorInterfaceVO vo = new ConnectorInterfaceVO();
            BeanUtils.copyProperties((Object)((Object)connectorInterface), (Object)((Object)vo));
            vo.setConnectorFieldMappingList(mappingFiledMap.get(connectorInterface.getId()));
            list.add(vo);
        }
        JSONArray jsonArray = JSONArray.parseArray((String)JSON.toJSONString(list));
        return Result.ok((Object)jsonArray);
    }

    @AutoLog(value="\u5e73\u53f0\u8fde\u63a5\u5668\u63a5\u53e3\u8868-\u5bfc\u5165")
    @PostMapping(value={"/jsonImport"})
    @RequiresPermissions(value={"connector#connectorInterface:jsonImport"})
    public Result<?> jsonImport(@RequestBody CreateJsonStructureVO structureVO) throws Exception {
        this.connectorInterfaceService.jsonImport(structureVO.getJsonString());
        return Result.ok();
    }

    private void clearData(BaseEntity entity) {
        entity.setCreateBy(null);
        entity.setUpdateBy(null);
        entity.setCreateTime(null);
        entity.setUpdateTime(null);
        entity.setCreateById(null);
        entity.setUpdateById(null);
        entity.setDeleted(null);
    }
}

