/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.template.service.impl;

import com.alibaba.fastjson.JSON;
import com.els.common.api.service.InterfaceConverter;
import com.els.common.exception.ELSBootException;
import com.els.common.util.RedisUtil;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.service.TemplateHeadService;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="templateConverter")
public class TemplateConverter
implements InterfaceConverter {
    private static final Logger log = LoggerFactory.getLogger(TemplateConverter.class);
    private static final String REDIS_PREFIX = "srm:templateConverter_";
    @Autowired
    private RedisUtil redisUtil;
    @Lazy
    @Resource
    private TemplateHeadService templateHeadService;

    public Object convertData(Object data, Object obj, String ... args) {
        String inputData = (String)data;
        String templateCode = args[0];
        if (StringUtils.isNotBlank((CharSequence)templateCode)) {
            TemplateHead template = (TemplateHead)((Object)this.redisUtil.get(REDIS_PREFIX + templateCode));
            if (template == null && (template = this.templateHeadService.getDefaultTemplateByType(templateCode).get(0)) != null) {
                this.redisUtil.set(REDIS_PREFIX + templateCode, (Object)template, 300L);
            }
            if (template == null) {
                throw new ELSBootException("\u627e\u4e0d\u5230\u7c7b\u578b\u4e3a\u3010" + templateCode + "\u3011\u914d\u7f6e\u7684\u6a21\u7248\uff01");
            }
            Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)((Object)template)), Map.class);
            return map.get(inputData).toString();
        }
        throw new ELSBootException("\u627e\u4e0d\u5230\u7c7b\u578b\u4e3a\u3010" + templateCode + "\u3011\u914d\u7f6e\u7684\u6a21\u7248\uff01");
    }
}

