/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.translate.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.util.HttpRequestUtil;
import com.els.common.util.I18nUtil;
import com.els.modules.translate.dto.TencentTranslateDto;
import com.els.modules.translate.dto.TranslateDto;
import com.els.modules.translate.service.TranslateService;
import com.els.modules.translate.util.TencentUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Encoder;

@Api(tags={" \u6587\u5b57\u8bed\u97f3\u7ffb\u8bd1"})
@RestController
@RequestMapping(value={"/base/translate"})
public class TranslateController {
    private static final Logger log = LoggerFactory.getLogger(TranslateController.class);
    private static final String BAI_FAN_YI = "https://fanyi.baidu.com/gettts?";
    @Autowired(required=false)
    private TencentUtils tencentUtils;
    @Autowired
    private TranslateService translateService;

    @AutoLog(value="\u6587\u5b57\u8f6c\u8bed\u97f3")
    @ApiOperation(value="\u6587\u5b57\u8f6c\u8bed\u97f3", notes="\u6587\u5b57\u8f6c\u8bed\u97f3")
    @PostMapping(value={"/textToMp3File"})
    @RequiresPermissions(value={"translate#translate:textToMp3File"})
    public void textToMp3File(@RequestBody TranslateDto translateDto, HttpServletResponse response) throws IOException {
        HashMap<String, String> headParam = new HashMap<String, String>();
        headParam.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9");
        headParam.put("Accept-Encoding", "gzip, deflate, br");
        headParam.put("Accept-Language", "zh-CN,zh;q=0.9");
        headParam.put("sec-ch-ua", "\"Google Chrome\";v=\"95\", \"Chromium\";v=\"95\", \";Not A Brand\";v=\"99\"");
        headParam.put("sec-ch-ua-mobile", "?0");
        headParam.put("Upgrade-Insecure-Requests", "?1");
        headParam.put("Cookie", "PSTM=" + System.currentTimeMillis() + "; BIDUPSID=56B4CD5A1BA393E439F07B0421B99A10; BAIDUID=F5FF0B4DFD9E63A3C2A84B03C38D393A:FG=1; __yjs_duid=1_1665edf9ff070b4a6762f0237cc2b0f61625472700464; REALTIME_TRANS_SWITCH=1; FANYI_WORD_SWITCH=1; HISTORY_SWITCH=1; SOUND_SPD_SWITCH=1; SOUND_PREFER_SWITCH=1; BAIDUID_BFESS=F5FF0B4DFD9E63A3C2A84B03C38D393A:FG=1");
        String url = "https://fanyi.baidu.com/gettts?lan=" + translateDto.getLan() + "&text=" + HttpRequestUtil.encode((String)translateDto.getText()) + "&spd=" + ObjectUtil.defaultIfNull((Object)translateDto.getSpd(), (Object)3) + "&source=web";
        byte[] bytes = HttpRequestUtil.httpDownLoadFileFromUrl((String)url, null, null, headParam);
        response.setContentType("audio/mpeg");
        response.setHeader("Content-Disposition", "attachment;filename=" + System.currentTimeMillis() + ".mp3");
        response.getOutputStream().write(bytes);
    }

    @AutoLog(value="\u6587\u5b57\u8f6c\u8bed\u97f3")
    @ApiOperation(value="\u8bed\u97f3\u8f6c\u6587\u5b57", notes="\u8bed\u97f3\u8f6c\u6587\u5b57")
    @PostMapping(value={"/audioToText"})
    @RequiresPermissions(value={"translate#translate:audioToText"})
    public Result<?> audioToText(@RequestParam(name="lan", defaultValue="zh") String lan, @RequestParam(name="requestType", defaultValue="audioToText") String requestType, @RequestParam(value="file") MultipartFile file) throws IOException {
        if (null == this.tencentUtils) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VWERUWvIyVwZ_90a7f239", (String)"\u8bf7\u5148\u914d\u7f6e\u8bed\u97f3\u7ffb\u8bd1\u63a5\u53e3\u79d8\u94a5"));
        }
        Integer length = file.getBytes().length;
        BASE64Encoder base64Encoder = new BASE64Encoder();
        String base64Text = base64Encoder.encode(file.getBytes());
        int times = this.tencentUtils.computeFileLength(file);
        if (times >= 60) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RiTvIWWMICWN_f97805bf", (String)"\u53ea\u5141\u8bb8\u7ffb\u8bd160\u79d2\u4ee5\u5185\u97f3\u9891"));
        }
        TencentTranslateDto dto = new TencentTranslateDto();
        dto.setEngSerViceType("16k_" + lan);
        String result = this.tencentUtils.audioToText(base64Text, length, dto);
        JSONObject jsonObject = JSONObject.parseObject((String)result.toString());
        this.translateService.buildResult(jsonObject, requestType);
        return Result.ok((Object)jsonObject);
    }
}

