/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.knowledge.controller;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.integration.service.SrmToIPaasService;
import com.els.modules.knowledge.entity.KnowledgeAttachment;
import com.els.modules.knowledge.service.KnowledgeAttachmentService;
import com.els.modules.system.service.ElsIpaasConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u95ee\u7b54\u5e93\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/base/knowledgeAttachment"})
public class KnowledgeAttachmentController
extends BaseController<KnowledgeAttachment, KnowledgeAttachmentService> {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeAttachmentController.class);
    @Autowired
    private KnowledgeAttachmentService knowledgeAttachmentService;
    private static final String UPLOAD_PATH = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.path.upload");
    private static final String SERVICE_BASE = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.config.service.address");
    private static final String KNOWLEDGE_BASE = "v5srm_";
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignService;
    @Autowired
    private SrmToIPaasService srmToIPaasService;
    @Autowired
    private ElsIpaasConfigService ipaasConfigService;
    @Value(value="${els.storage.type}")
    private String fileServerType;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"knowledge#knowledgeAttachment:list"})
    public Result<?> queryPageList(KnowledgeAttachment knowledgeAttachment, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)knowledgeAttachment), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.knowledgeAttachmentService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u95ee\u7b54\u5e93\u7ba1\u7406-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"knowledge#knowledgeAttachment:add"})
    public Result<?> add(@RequestParam(value="files") MultipartFile[] files) {
        String elsAccount = this.getTenantId();
        String savePath = File.separator + "knowledgeAttachment" + File.separator + elsAccount + File.separator;
        String rootPath = UPLOAD_PATH + savePath;
        try {
            for (MultipartFile uploadFile : files) {
                KnowledgeAttachment attachment = new KnowledgeAttachment();
                String fileName = uploadFile.getOriginalFilename();
                if (!FileUtil.exist((String)rootPath)) {
                    FileUtil.mkdir((String)rootPath);
                }
                File attachmentFile = new File(rootPath + fileName);
                BufferedOutputStream out = FileUtil.getOutputStream((File)attachmentFile);
                IoUtil.copy((InputStream)uploadFile.getInputStream(), (OutputStream)out, (int)8192);
                out.flush();
                out.close();
                JSONObject paramObj = new JSONObject();
                paramObj.put("knowledge_base_id", (Object)(KNOWLEDGE_BASE + elsAccount));
                paramObj.put("file", (Object)(SERVICE_BASE + "/opt/upFiles" + savePath + fileName));
                JSONObject result = this.srmToIPaasService.callIPaasInterface(paramObj, "valueAddedApplication", this.ipaasConfigService.getIpaasInterfaceCode("glm_upload_file"));
                if (!result.containsKey((Object)"data") || result.getJSONObject("data").getInteger("code") != 200) {
                    throw new ELSBootException("\u8c03\u7528langchain\u670d\u52a1\u5931\u8d25\uff01");
                }
                attachment.setFileName(fileName);
                attachment.setFileSize(String.valueOf(uploadFile.getSize()));
                attachment.setFilePath(savePath + fileName);
                this.knowledgeAttachmentService.save((Object)attachment);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ELSBootException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25" + e.getMessage());
        }
        return this.commonSuccessResult(2);
    }

    @AutoLog(value="\u95ee\u7b54\u5e93\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"knowledge#knowledgeAttachment:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        KnowledgeAttachment knowledgeAttachment = (KnowledgeAttachment)((Object)this.knowledgeAttachmentService.getById((Serializable)((Object)id)));
        JSONObject paramObj = new JSONObject();
        JSONObject baseObj = new JSONObject();
        baseObj.put("knowledge_base_id", (Object)(KNOWLEDGE_BASE + this.getTenantId()));
        baseObj.put("doc_name", (Object)knowledgeAttachment.getFileName());
        paramObj.put("base", (Object)baseObj);
        paramObj.put("body", (Object)"{}");
        JSONObject result = this.srmToIPaasService.callIPaasInterface(paramObj, "valueAddedApplication", this.ipaasConfigService.getIpaasInterfaceCode("glm_delete_file"));
        if (!result.containsKey((Object)"data")) {
            throw new ELSBootException("\u8c03\u7528langchain\u670d\u52a1\u5931\u8d25\uff01");
        }
        this.knowledgeAttachmentService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u4ef6-\u4e0b\u8f7d", operateType=1)
    @GetMapping(value={"/download"})
    @RequiresPermissions(value={"knowledge#knowledgeAttachment:download"})
    public void download(@RequestParam(name="id") String id, HttpServletResponse response, HttpServletRequest request) {
        KnowledgeAttachment knowledgeAttachment = (KnowledgeAttachment)((Object)this.knowledgeAttachmentService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        try {
            this.headBuilder(response, request, knowledgeAttachment.getFileName());
            this.fileStoreSignService.downloadFileWithOutput(response, (OutputStream)response.getOutputStream(), knowledgeAttachment.getFilePath(), this.fileServerType);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
    }

    private void headBuilder(HttpServletResponse response, HttpServletRequest request, String filename) throws Exception {
        filename = request.getHeader("User-Agent").toUpperCase().indexOf("MSIE") > 0 ? URLEncoder.encode(filename, "UTF-8") : new String(filename.getBytes("UTF-8"), "ISO8859-1");
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=\"" + filename + "\"");
        response.setContentType("application/octet-stream");
    }
}

