/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.generate.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.els.api.dto.TableInfoQueryDto;
import com.els.common.util.SpringContextUtils;
import com.els.modules.generate.pojo.ColumnVo;
import com.els.modules.generate.pojo.MainTableVo;
import com.els.modules.generate.pojo.SubTableVo;
import com.els.modules.generate.pojo.TemplateFileConfig;
import com.els.modules.generate.pojo.generateConfig;
import com.els.modules.generate.service.FrameworkFileUtil;
import com.els.modules.generate.service.IGenerate;
import com.els.modules.generate.service.MysqlReadTableService;
import com.els.modules.generate.util.NonceUtils;
import com.els.modules.system.util.TableFieldUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenerateManyService
extends FrameworkFileUtil
implements IGenerate<MainTableVo> {
    private static final Logger log = LoggerFactory.getLogger(CodeGenerateManyService.class);

    @Override
    public Map<String, Object> configMap(MainTableVo tableVo, generateConfig generateConfig2, List<ColumnVo> columns, List<ColumnVo> originalColumns, Map<String, List<ColumnVo>> subColumnList) throws Exception {
        TableInfoQueryDto dto;
        Iterator<SubTableVo> bean;
        HashMap<String, Object> localHashMap = new HashMap<String, Object>();
        localHashMap.put("bussiPackage", generateConfig2.getBasePackage());
        localHashMap.put("entityPackage", tableVo.getEntityPackage());
        localHashMap.put("entityName", tableVo.getEntityName());
        localHashMap.put("tableName", tableVo.getTableName());
        localHashMap.put("ftl_description", tableVo.getFtlDescription());
        localHashMap.put("primaryKeyField", generateConfig2.getDbTableId());
        localHashMap.put("left", "${");
        localHashMap.put("right", "}");
        if (tableVo.getFieldRequiredNum() == null) {
            tableVo.setFieldRequiredNum((Integer)ObjectUtil.defaultIfNull((Object)generateConfig2.getFieldRequiredNum(), (Object)-1));
        }
        if (tableVo.getSearchFieldNum() == null) {
            tableVo.setSearchFieldNum((Integer)ObjectUtil.defaultIfNull((Object)generateConfig2.getPageSearchFieldNum(), (Object)-1));
        }
        if (tableVo.getFieldRowNum() == null) {
            tableVo.setFieldRowNum(generateConfig2.getFieldRowNum());
        }
        if (tableVo.getFieldRowNum() == null) {
            tableVo.setFieldRowNum(1);
        }
        localHashMap.put("tableVo", tableVo);
        if (CollUtil.isEmpty(columns)) {
            bean = (MysqlReadTableService)SpringContextUtils.getBean(MysqlReadTableService.class);
            dto = new TableInfoQueryDto();
            dto.setTableName(tableVo.getTableName());
            dto.setServiceInstanceId(tableVo.getServiceInstanceId());
            columns = ((MysqlReadTableService)((Object)bean)).queryTableColumns(dto);
        }
        localHashMap.put("columns", columns);
        if (CollUtil.isEmpty(originalColumns)) {
            bean = (MysqlReadTableService)SpringContextUtils.getBean(MysqlReadTableService.class);
            dto = new TableInfoQueryDto();
            dto.setTableName(tableVo.getTableName());
            dto.setServiceInstanceId(tableVo.getServiceInstanceId());
            originalColumns = ((MysqlReadTableService)((Object)bean)).queryTableColumns(dto);
        }
        localHashMap.put("originalColumns", originalColumns);
        for (ColumnVo localColumnVo : originalColumns) {
            if (!localColumnVo.getFieldName().toLowerCase().equals(generateConfig2.getDbTableId().toLowerCase())) continue;
            localHashMap.put("primaryKeyPolicy", localColumnVo.getFieldType());
        }
        for (SubTableVo subTableVo : tableVo.getSubTables()) {
            List<Object> localObject2;
            if (subTableVo.getColumns() == null || subTableVo.getColumns().size() == 0) {
                localObject2 = subColumnList.get(subTableVo.getTableName());
                subTableVo.setColumns(localObject2);
            }
            if (subTableVo.getOriginalColumns() == null || subTableVo.getOriginalColumns().size() == 0) {
                localObject2 = subColumnList.get(subTableVo.getTableName());
                subTableVo.setOriginalColumns(localObject2);
            }
            localObject2 = subTableVo.getForeignKeys();
            ArrayList<String> localArrayList = new ArrayList<String>();
            if (null != subTableVo.getForeignKeys()) {
                for (String string : localObject2) {
                    localArrayList.add(TableFieldUtil.initialToCapital(string));
                }
            }
            subTableVo.setForeignKeys(localArrayList);
            subTableVo.setOriginalForeignKeys(localObject2);
        }
        localHashMap.put("subTables", tableVo.getSubTables());
        long l = NonceUtils.randomNextLong() + NonceUtils.currentTime();
        localHashMap.put("serialVersionUID", String.valueOf(l));
        return localHashMap;
    }

    @Override
    public void generateCodeFile(MainTableVo tableVo, generateConfig generateConfig2, List<ColumnVo> columns, List<ColumnVo> originalColumns, Map<String, List<ColumnVo>> subColumnList) throws Exception {
        log.info("[\u751f\u6210\u4ee3\u7801\uff0c\u4e00\u5bf9\u591a\u6a21\u578b{},]-------------", (Object)tableVo.getTableName());
        Map<String, Object> localMap = this.configMap(tableVo, generateConfig2, columns, originalColumns, subColumnList);
        String projectPath = generateConfig2.getProjectPath();
        String templatePath = generateConfig2.getTemplatePath();
        if (CodeGenerateManyService.getPathSuffix(templatePath, "/").equals("els/code-template")) {
            templatePath = "/" + CodeGenerateManyService.getPathSuffix(templatePath, "/") + "/onetomany";
        }
        TemplateFileConfig fileConfig = new TemplateFileConfig(templatePath);
        this.generateFile(fileConfig, projectPath, localMap, generateConfig2);
        log.info("[\u751f\u6210\u4ee3\u7801\uff0c\u4e00\u5bf9\u591a\u6a21\u578b{},]-------------\u5b8c\u6210", (Object)tableVo.getTableName());
    }
}

