/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.generate.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.els.api.dto.TableFieldDto;
import com.els.api.dto.TableInfoQueryDto;
import com.els.common.api.service.ClassTypeRpcService;
import com.els.common.api.service.TableLoaderRpcService;
import com.els.common.util.SpringContextUtils;
import com.els.modules.generate.pojo.ColumnVo;
import com.els.modules.system.util.TableFieldUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MysqlReadTableService {
    private static final Logger log = LoggerFactory.getLogger(MysqlReadTableService.class);

    public List<ColumnVo> queryTableColumns(TableInfoQueryDto dto) throws Exception {
        Map<String, List<ColumnVo>> map = this.getTableFields(Lists.newArrayList((Object[])new TableInfoQueryDto[]{dto}));
        return map.get(dto.getTableName());
    }

    public Map<String, List<ColumnVo>> queryTableColumns(List<TableInfoQueryDto> dtos) throws Exception {
        return this.getTableFields(dtos);
    }

    List<TableFieldDto> rpcQueryTableField(TableLoaderRpcService rpcService, List<String> tableName) {
        ArrayList<TableFieldDto> tableFieldDtos = new ArrayList();
        try {
            tableFieldDtos = rpcService.queryTableField(tableName);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return tableFieldDtos;
    }

    private Map<String, List<ColumnVo>> getTableFields(List<TableInfoQueryDto> dtos) {
        List instanceIds = dtos.stream().map(TableInfoQueryDto::getServiceInstanceId).collect(Collectors.toList());
        Map rpcMap = ((ClassTypeRpcService)SpringContextUtils.getBean(ClassTypeRpcService.class)).getExcelDataLoader(instanceIds);
        if (CollectionUtil.isEmpty((Map)rpcMap)) {
            return null;
        }
        ArrayList<TableFieldDto> tableFieldBos = new ArrayList<TableFieldDto>();
        Map tableMap = dtos.stream().collect(Collectors.groupingBy(TableInfoQueryDto::getServiceInstanceId, Collectors.mapping(TableInfoQueryDto::getTableName, Collectors.toList())));
        for (String instance : tableMap.keySet()) {
            List<String> tableList = tableMap.get(instance);
            List<TableFieldDto> fieldDtoList = this.rpcQueryTableField((TableLoaderRpcService)rpcMap.get(instance), tableList);
            tableFieldBos.addAll(fieldDtoList);
        }
        Map<String, List<TableFieldDto>> groupByTableMap = tableFieldBos.stream().collect(Collectors.groupingBy(TableFieldDto::getTableName));
        HashMap<String, List<ColumnVo>> columnMap = new HashMap<String, List<ColumnVo>>();
        groupByTableMap.forEach((tableName, columns) -> {
            ArrayList result = Lists.newArrayList();
            for (TableFieldDto dto : columns) {
                ColumnVo columnDto = new ColumnVo();
                columnDto.setFieldName(TableFieldUtil.initialToCapital(dto.getColumnName().toLowerCase()));
                columnDto.setFieldDbName(dto.getColumnName());
                columnDto.setFieldType(TableFieldUtil.getFiledCodeType(dto.getDataType(), dto.getNumericPrecision(), dto.getNumericScale()));
                columnDto.setFieldDbType(TableFieldUtil.initialToCapital(dto.getDataType()));
                columnDto.setPrecision(dto.getNumericPrecision());
                columnDto.setScale(dto.getNumericScale());
                columnDto.setNullable(dto.getIsNullable());
                columnDto.setFiledComment(StrUtil.isBlank((CharSequence)dto.getColumnComment()) ? columnDto.getFieldName() : dto.getColumnComment());
                TableFieldUtil.initTableField2CodeField(columnDto);
                result.add(columnDto);
            }
            columnMap.put((String)tableName, result);
        });
        return columnMap;
    }
}

