/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.encryption;

import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.barcode.encryption.base.BaseEncryption;
import com.els.modules.barcode.encryption.base.IEncryption;
import com.els.modules.barcode.enumerate.I18nBarCodeEnum;
import com.els.modules.barcode.utils.EncodesUtil;
import java.math.BigInteger;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DES
extends BaseEncryption
implements IEncryption {
    private static final Logger log = LoggerFactory.getLogger(DES.class);
    private static final String DES_PRIVATE_KEY = "V5QqTqQt";
    private static final String KEY_ALGORITHM = "DES";
    private static final String CIPHER_ALGORITHM = "DES/CBC/PKCS5Padding";

    private Key generateKey() throws Exception {
        DESKeySpec dks = new DESKeySpec(DES_PRIVATE_KEY.getBytes("utf-8"));
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(KEY_ALGORITHM);
        return keyFactory.generateSecret(dks);
    }

    private Cipher getCipher() throws Exception {
        return Cipher.getInstance(CIPHER_ALGORITHM);
    }

    private IvParameterSpec getIvParameterSpec() throws Exception {
        return new IvParameterSpec(DES_PRIVATE_KEY.getBytes("utf-8"));
    }

    private byte[] encrypt(String plainText) throws Exception {
        Cipher cipher = this.getCipher();
        cipher.init(1, this.generateKey(), this.getIvParameterSpec());
        return cipher.doFinal(plainText.getBytes("utf-8"));
    }

    private byte[] decrypt(String cipherText) throws Exception {
        BigInteger bigInteger = new BigInteger(cipherText);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, this.generateKey(), this.getIvParameterSpec());
        return cipher.doFinal(EncodesUtil.decodeHex(bigInteger.toString(16)));
    }

    @Override
    public String plainTextEncrypt(String plainText) {
        try {
            return new BigInteger(EncodesUtil.encodeHex(this.encrypt(plainText)), 16).toString();
        }
        catch (Exception e) {
            log.error("DES\u52a0\u5bc6\u51fa\u9519", (Throwable)e);
            throw new ELSBootException(I18nUtil.translate((Enum)I18nBarCodeEnum.ENCRYPTION_ERROR), (Throwable)e, new String[0]);
        }
    }

    @Override
    public String cipherTextDecrypt(String cipherText) {
        try {
            return new String(this.decrypt(cipherText), "utf-8");
        }
        catch (Exception e) {
            log.error("DES\u52a0\u5bc6\u51fa\u9519", (Throwable)e);
            throw new ELSBootException(I18nUtil.translate((Enum)I18nBarCodeEnum.ENCRYPTION_ERROR), (Throwable)e, new String[0]);
        }
    }
}

