/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.generate.service;

import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.generate.pojo.TemplateFileConfig;
import com.els.modules.generate.pojo.generateConfig;
import com.els.modules.generate.util.FrameworkUtil;
import com.els.modules.generate.util.GenerateFileUtil;
import com.qcloud.cos.utils.IOUtils;
import freemarker.template.Template;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameworkFileUtil {
    private static final Logger log = LoggerFactory.getLogger(FrameworkFileUtil.class);
    protected static String ENCODING = "UTF-8";

    protected void generateFile(TemplateFileConfig templateFileConfig, String projectPath, Map<String, Object> paramMap, generateConfig generateConfig2) throws Exception {
        log.info("----------------\u751f\u6210\u9879\u76ee\u8def\u5f84--------------{}", (Object)projectPath);
        for (int i = 0; i < templateFileConfig.getTemplateFileList().size(); ++i) {
            File rootDirFile = templateFileConfig.getTemplateFileList().get(i);
            this.generate(projectPath, rootDirFile, paramMap, templateFileConfig, generateConfig2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generate(String projectPath, File rootDirFile, Map<String, Object> paramMap, TemplateFileConfig templateFileConfig, generateConfig generateConfig2) throws Exception {
        if (rootDirFile == null) {
            throw new ELSBootException("\u4e34\u65f6\u6587\u4ef6\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<File> localList = GenerateFileUtil.sortFile(rootDirFile);
        for (int i = 0; i < localList.size(); ++i) {
            File localFile = localList.get(i);
            this.generateToLocal(projectPath, rootDirFile, paramMap, localFile, templateFileConfig, generateConfig2);
        }
        File zipFile = new File(projectPath);
        File toZip = this.fileToZip(zipFile);
        FileUtils.deleteDirectory((File)zipFile);
        HttpServletResponse response = SpringContextUtils.getHttpServletResponse();
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.setContentType("application/zip");
        try {
            FileInputStream inputStream = new FileInputStream(toZip);
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            response.getOutputStream().write(bytes, 0, bytes.length);
            response.getOutputStream().flush();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                response.getOutputStream().close();
            }
            catch (IOException iOException) {}
            FileUtils.forceDelete((File)toZip);
        }
    }

    protected void generateToLocal(String projectPath, File rootDirFile, Map<String, Object> paramMap, File localFile, TemplateFileConfig templateFileConfig, generateConfig generateConfig2) throws Exception {
        String templateFileName = GenerateFileUtil.getFileAbsolutePath(rootDirFile, localFile);
        try {
            String outputFilepath = FrameworkFileUtil.getOutputFilepath(paramMap, templateFileName, templateFileConfig);
            if (outputFilepath.startsWith("java")) {
                String str3;
                String str4 = str3 = projectPath + File.separator + generateConfig2.getSourceRootPackage().replace(".", File.separator);
                outputFilepath = outputFilepath.substring("java".length());
                outputFilepath = str4 + outputFilepath;
                this.generateTpl2Local(templateFileName, outputFilepath, paramMap, templateFileConfig);
            } else if (outputFilepath.startsWith("webapp")) {
                String str3;
                String str4 = str3 = projectPath + File.separator + generateConfig2.getWebRootPackage().replace(".", File.separator);
                outputFilepath = outputFilepath.substring("webapp".length());
                outputFilepath = str4 + outputFilepath;
                this.generateTpl2Local(templateFileName, outputFilepath, paramMap, templateFileConfig);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File fileToZip(File sourceFile) throws IOException {
        if (!sourceFile.exists()) {
            throw new ELSBootException("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728");
        }
        if (!sourceFile.isDirectory()) {
            throw new ELSBootException("\u4e0d\u662f\u6587\u4ef6\u5939");
        }
        File zipFile = new File(sourceFile.getAbsolutePath() + ".zip");
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(zipFile);
            zos = new ZipOutputStream(new BufferedOutputStream(fos));
            this.fileToZip(zos, sourceFile, "");
        }
        catch (Exception exception) {
        }
        finally {
            zos.close();
            fos.close();
        }
        return zipFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileToZip(ZipOutputStream zos, File sourceFile, String path) throws IOException {
        if (sourceFile.isDirectory()) {
            path = path + sourceFile.getName() + File.separator;
            ZipEntry zipEntry = new ZipEntry(path);
            zos.putNextEntry(zipEntry);
            for (File file : sourceFile.listFiles()) {
                this.fileToZip(zos, file, path);
            }
        } else {
            ZipEntry zipEntry = new ZipEntry(path + sourceFile.getName());
            zos.putNextEntry(zipEntry);
            byte[] bufs = new byte[10240];
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            try {
                fis = new FileInputStream(sourceFile);
                bis = new BufferedInputStream(fis, 10240);
                int read = 0;
                while ((read = bis.read(bufs, 0, 10240)) != -1) {
                    zos.write(bufs, 0, read);
                }
            }
            catch (Exception exception) {
            }
            finally {
                bis.close();
                fis.close();
            }
        }
    }

    protected void generateTpl2Local(String templateFileName, String outputFilepath, Map<String, Object> paramMap, TemplateFileConfig parama) throws Exception {
        if (outputFilepath.endsWith("i")) {
            outputFilepath = outputFilepath.substring(0, outputFilepath.length() - 1);
        }
        Template localTemplate = this.getTemplate(templateFileName, parama);
        localTemplate.setOutputEncoding(ENCODING);
        File localFile = GenerateFileUtil.getFile(outputFilepath);
        FrameworkUtil.write2TargetFile(localTemplate, paramMap, localFile, ENCODING);
        if (this.isSubTableFile(localFile)) {
            FrameworkFileUtil.write2Local(localFile, "#segment#");
        }
    }

    protected Template getTemplate(String paramString, TemplateFileConfig parama) throws IOException {
        return FrameworkUtil.getConfiguration(parama.getTemplateFileList(), ENCODING, paramString).getTemplate(paramString);
    }

    protected boolean isSubTableFile(File paramFile) {
        return paramFile.getName().startsWith("[1-n]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void write2Local(File paramFile, String subTableFileContentFlag) {
        InputStreamReader localInputStreamReader = null;
        BufferedReader localBufferedReader = null;
        try {
            String readerTmp;
            localInputStreamReader = new InputStreamReader((InputStream)new FileInputStream(paramFile), "UTF-8");
            localBufferedReader = new BufferedReader(localInputStreamReader);
            boolean m = false;
            File templateFile = null;
            while ((readerTmp = localBufferedReader.readLine()) != null) {
                if (readerTmp.trim().length() > 0 && readerTmp.startsWith(subTableFileContentFlag)) {
                    String str2 = readerTmp.substring(subTableFileContentFlag.length());
                    String str3 = paramFile.getParentFile().getAbsolutePath();
                    str2 = str3 + File.separator + str2;
                    templateFile = new File(str2);
                    m = true;
                    continue;
                }
                if (!m) continue;
                FileUtils.writeStringToFile(templateFile, (String)(readerTmp + "\r\n"), (boolean)true);
            }
            localBufferedReader.close();
            localInputStreamReader.close();
            FrameworkFileUtil.deleteFile(paramFile);
        }
        catch (FileNotFoundException localFileNotFoundException) {
            localFileNotFoundException.printStackTrace();
            log.error("\u6ca1\u627e\u5230\u6a21\u677f\u6587\u4ef6\uff1a", (Throwable)localFileNotFoundException);
        }
        catch (IOException localIOException3) {
            log.error("\u6587\u4ef6\u6d41\u51fa\u6765\u51fa\u9519\uff1a", (Throwable)localIOException3);
        }
        finally {
            try {
                if (localBufferedReader != null) {
                    localBufferedReader.close();
                }
                if (localInputStreamReader != null) {
                    localInputStreamReader.close();
                }
            }
            catch (IOException localIOException5) {
                log.error("\u6587\u4ef6\u6d41\u51fa\u6765\u51fa\u9519\uff1a", (Throwable)localIOException5);
            }
        }
    }

    protected static String getOutputFilepath(Map<String, Object> paramMap, String templateFileName, TemplateFileConfig templateFileConfig) throws Exception {
        Object localObject1;
        String str1 = templateFileName;
        int i = -1;
        i = templateFileName.indexOf(64);
        if (i != -1) {
            str1 = templateFileName.substring(0, i);
            localObject1 = templateFileName.substring(i + 1);
            Object localObject2 = paramMap.get(localObject1);
            if (localObject2 == null) {
                System.err.println("[not-generate] WARN: test expression is null by key:[" + (String)localObject1 + "] on template:[" + templateFileName + "]");
                return null;
            }
            if (!"true".equals(String.valueOf(localObject2))) {
                log.error("[not-generate]\t test expression '@" + (String)localObject1 + "' is false,template:" + templateFileName);
                return null;
            }
        }
        localObject1 = FrameworkUtil.getConfiguration(templateFileConfig.getTemplateFileList(), ENCODING, "/");
        String author = SysUtil.getLoginUser().getRealname();
        if (StringUtils.isNotBlank((String)author)) {
            paramMap.put("author", author);
        } else {
            paramMap.put("author", "");
        }
        str1 = FrameworkUtil.templateFillWithParams(str1, paramMap, localObject1);
        String localObject2 = str1.substring(str1.lastIndexOf("."));
        String str2 = str1.substring(0, str1.lastIndexOf(".")).replace(".", File.separator);
        str1 = str2 + localObject2;
        return str1;
    }

    protected static boolean deleteFile(File paramFile) {
        boolean bool = false;
        int i = 0;
        while (!bool && i++ < 10) {
            System.gc();
            bool = paramFile.delete();
        }
        return bool;
    }

    protected static String getPathSuffix(String templatePath, String suffix) {
        boolean i = true;
        boolean j = true;
        do {
            int k = templatePath.indexOf(suffix) == 0 ? 1 : 0;
            int m = templatePath.lastIndexOf(suffix) + 1 == templatePath.length() ? templatePath.lastIndexOf(suffix) : templatePath.length();
            templatePath = templatePath.substring(k, m);
            i = templatePath.indexOf(suffix) == 0;
            boolean bl = j = templatePath.lastIndexOf(suffix) + 1 == templatePath.length();
        } while (i || j);
        return templatePath;
    }
}

