/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.history.rocketMq.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.history.entity.ElsInitialTable;
import com.els.modules.history.service.ElsInitialTableService;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InitTableConsumer {
    private static final Logger log = LoggerFactory.getLogger(InitTableConsumer.class);
    @Autowired
    private ElsInitialTableService elsInitialTableService;

    public Consumer<String> receive() {
        return msgBody -> {
            try {
                if (StringUtils.isBlank((CharSequence)msgBody)) {
                    return;
                }
                JSONObject body = JSONObject.parseObject((String)msgBody);
                ElsInitialTable table = (ElsInitialTable)((Object)((Object)JSONObject.toJavaObject((JSON)body, ElsInitialTable.class)));
                if (StringUtils.isNotBlank((CharSequence)table.getRelationId()) && StringUtils.isNotBlank((CharSequence)table.getBusinessInfoJson())) {
                    log.info("msgBody: " + msgBody);
                    this.elsInitialTableService.saveElsInitialTable(table);
                }
            }
            catch (Exception e) {
                log.error("InitTableConsumer_receive_msgBody:" + msgBody, (Throwable)e);
                throw e;
            }
        };
    }
}

