/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.history.rocketMq.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.history.entity.ElsInitialTable;
import com.els.modules.history.service.ElsInitialTableService;
import com.tongtech.client.annotation.HTPMessageListener;
import com.tongtech.client.consumer.PullResult;
import com.tongtech.client.consumer.listener.ConsumeConcurrentlyContext;
import com.tongtech.client.consumer.listener.ConsumeConcurrentlyStatus;
import com.tongtech.client.core.HTPPushConsumerLifecycleListener;
import com.tongtech.client.exception.HTPException;
import com.tongtech.client.htp.consumer.HTPPushConsumer;
import com.tongtech.client.message.Message;
import com.tongtech.client.support.HTPListenerConcurrently;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HTPMessageListener(consumerGroup="init_table", topic="init_table", namespace="dongfangtonghtp")
public class InitTableConsumerListener
implements HTPListenerConcurrently,
HTPPushConsumerLifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(InitTableConsumerListener.class);
    private HTPPushConsumer pushConsumer;
    @Autowired
    private ElsInitialTableService elsInitialTableService;

    public ConsumeConcurrentlyStatus onMessage(PullResult pullResult, ConsumeConcurrentlyContext consumeConcurrentlyContext) {
        pullResult.getMsgFoundList().forEach(messageExt -> {
            try {
                String msgBody = new String(messageExt.getBody());
                log.info("push\u6d88\u606f\u6210\u529f,initTable_msgBody \u7ed3\u679c\uff1a" + msgBody);
                if (StringUtils.isBlank((CharSequence)msgBody)) {
                    return;
                }
                JSONObject body = JSONObject.parseObject((String)msgBody);
                ElsInitialTable table = (ElsInitialTable)((Object)((Object)JSONObject.toJavaObject((JSON)body, ElsInitialTable.class)));
                if (StringUtils.isNotBlank((CharSequence)table.getRelationId()) && StringUtils.isNotBlank((CharSequence)table.getBusinessInfoJson())) {
                    this.elsInitialTableService.saveElsInitialTable(table);
                }
                this.pushConsumer.acknowledge((Message)messageExt);
            }
            catch (HTPException e) {
                throw new RuntimeException(e);
            }
        });
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    }

    public void prepareStart(HTPPushConsumer htpPushConsumer) {
        this.pushConsumer = htpPushConsumer;
        this.pushConsumer.setClientAcknowledge();
    }
}

