/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.integrated.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.integrated.entity.IntegratedBusinessData;
import com.els.modules.integrated.mapper.IntegratedBusinessDataMapper;
import com.els.modules.integrated.service.IntegratedBusinessDataService;
import com.els.modules.integrated.util.ModulesDataHandleFactory;
import com.google.common.base.Supplier;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class IntegratedBusinessDataServiceImpl
extends BaseServiceImpl<IntegratedBusinessDataMapper, IntegratedBusinessData>
implements IntegratedBusinessDataService {
    @Resource
    private IntegratedBusinessDataMapper integratedBusinessDataMapper;

    @Override
    public void add(IntegratedBusinessData integratedBusinessData) {
        ((IntegratedBusinessDataMapper)this.baseMapper).insert((Object)integratedBusinessData);
    }

    @Override
    public void edit(IntegratedBusinessData integratedBusinessData) {
        int count = ((IntegratedBusinessDataMapper)this.baseMapper).updateById((Object)integratedBusinessData);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((IntegratedBusinessDataMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((IntegratedBusinessDataMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void updateIntegratedData(IntegratedBusinessData integratedBusinessData) {
        if (StringUtils.isNotBlank((CharSequence)integratedBusinessData.getBusinessType()) && StringUtils.isNotBlank((CharSequence)integratedBusinessData.getIntegratedId()) && StringUtils.isNotBlank((CharSequence)integratedBusinessData.getBusinessType())) {
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(IntegratedBusinessData::getBusinessType, (Object)integratedBusinessData.getBusinessType())).eq(IntegratedBusinessData::getIntegratedId, (Object)integratedBusinessData.getIntegratedId())).eq(IntegratedBusinessData::getBusinessId, (Object)integratedBusinessData.getBusinessId())).list();
            JSONObject jsonObject = JSONObject.parseObject((String)integratedBusinessData.getDataJson());
            if (CollectionUtils.isEmpty((Collection)list)) {
                integratedBusinessData.setCreateBy(jsonObject.getString("createBy"));
                integratedBusinessData.setElsAccount(jsonObject.getString("elsAccount"));
                integratedBusinessData.setUpdateBy(jsonObject.getString("updateBy"));
                ((IntegratedBusinessDataMapper)this.baseMapper).insert((Object)integratedBusinessData);
            } else {
                Supplier aNew = IntegratedBusinessData::new;
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(IntegratedBusinessData::getDataJson, (Object)integratedBusinessData.getDataJson())).set(BaseEntity::getElsAccount, (Object)jsonObject.getString("elsAccount"))).set(IntegratedBusinessData::getBusinessDataType, (Object)integratedBusinessData.getBusinessDataType())).set(IntegratedBusinessData::getUsed, (Object)"0")).eq(BaseEntity::getId, (Object)((IntegratedBusinessData)((Object)list.get(0))).getId())).update(aNew.get());
            }
        }
    }

    @Override
    public void updateIntegratedDataOverThreeDay() {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().le(BaseEntity::getUpdateTime, (Object)DateUtils.getDateAfter((Date)DateUtils.getDate(), (int)3))).eq(IntegratedBusinessData::getBusinessDataType, (Object)"head")).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).list();
        list.forEach(v -> {
            JSONObject dataHandle = ModulesDataHandleFactory.getDataHandle(v.getBusinessType(), v.getBusinessId());
            v.setDataJson(dataHandle.toJSONString());
            v.setUsed("0");
        });
        this.updateBatchById(list);
    }

    @Override
    public void deleteIntegratedData(String businessId, String modules, String businessDataType) {
        LambdaQueryWrapper integratedBusinessDataLambdaQueryWrapper = new LambdaQueryWrapper();
        if (StringUtils.isBlank((CharSequence)businessId)) {
            return;
        }
        integratedBusinessDataLambdaQueryWrapper.eq(IntegratedBusinessData::getBusinessId, (Object)businessId);
        if (!StringUtils.isBlank((CharSequence)modules)) {
            integratedBusinessDataLambdaQueryWrapper.eq(IntegratedBusinessData::getBusinessType, (Object)modules);
        }
        if (!StringUtils.isBlank((CharSequence)businessDataType)) {
            integratedBusinessDataLambdaQueryWrapper.eq(IntegratedBusinessData::getBusinessDataType, (Object)businessDataType);
        }
        integratedBusinessDataLambdaQueryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List list = this.list((Wrapper)integratedBusinessDataLambdaQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List<String> collect = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.deleteBatch(collect);
        }
    }

    @Override
    public List<IntegratedBusinessData> listHeadMsg(List<String> stringList) {
        return this.integratedBusinessDataMapper.listHeadMsg(stringList);
    }
}

