/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.rocketMq.util;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.rpc.service.InvokeBaseRpcService;
import com.tongtech.client.core.HTPTemplate;
import com.tongtech.client.message.Message;
import com.tongtech.client.producer.SendCallback;
import com.tongtech.client.producer.SendResult;
import com.tongtech.client.producer.SendStatus;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitPrintDataMqUtil {
    private static final Logger log = LoggerFactory.getLogger(InitPrintDataMqUtil.class);
    private static ExecutorService THREAD_POOL = new ThreadPoolExecutor(5, 20, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    public static void sendInitMsg(final String msg) {
        if (StrUtil.isBlank((CharSequence)msg)) {
            return;
        }
        final String key = IdWorker.getIdStr();
        final String elsAccount = TenantContext.getTenant();
        THREAD_POOL.submit(new Runnable(){

            @Override
            public void run() {
                Message message = new Message();
                log.info("printReportmsg:" + msg);
                message.setBody(msg.getBytes());
                message.setTopic("print_report_msg");
                try {
                    HTPTemplate htpTemplate = (HTPTemplate)SpringContextUtils.getBean(HTPTemplate.class);
                    htpTemplate.asyncSend(message, new SendCallback(){

                        public void onSuccess(SendResult sendResult) {
                            InvokeBaseRpcService service = (InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class);
                            service.saveRecord(elsAccount, key, msg, "printMessage");
                            if (sendResult != null && sendResult.getSendStatus() == SendStatus.SEND_OK) {
                                log.info("\u6210\u529f,\u7ed3\u679c:" + sendResult);
                            }
                            if (sendResult != null && sendResult.getSendStatus() == SendStatus.SEND_FAILED) {
                                log.info("\u5931\u8d25,\u7ed3\u679c:" + sendResult);
                            }
                        }

                        public void onException(Throwable throwable) {
                            log.info("\u5f02\u5e38,\u7ed3\u679c: " + throwable);
                        }
                    }, 2000L);
                }
                catch (Exception e) {
                    log.error("printReportmsg_failed:", (Throwable)e);
                }
            }
        });
    }
}

