/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.entity.BarcodeSupplierList;
import com.els.modules.barcode.entity.ElsBarcodeRuleHead;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoDetail;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoHead;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoItem;
import com.els.modules.barcode.entity.SaleBarcodeInfoHead;
import com.els.modules.barcode.enumerate.BarcodeResolveTypeEnum;
import com.els.modules.barcode.enumerate.PurchaseBarcodeInfoStatusEnum;
import com.els.modules.barcode.mapper.BarcodeSupplierListMapper;
import com.els.modules.barcode.mapper.ElsBarcodeRuleHeadMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodeInfoDetailMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodeInfoHeadMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodeInfoItemMapper;
import com.els.modules.barcode.service.BarcodeSupplierListService;
import com.els.modules.barcode.service.PurchaseBarcodeInfoDetailService;
import com.els.modules.barcode.service.PurchaseBarcodeInfoHeadService;
import com.els.modules.barcode.service.PurchaseBarcodeInfoItemService;
import com.els.modules.barcode.service.PurchaseBarcodePoolHeadService;
import com.els.modules.barcode.service.SaleBarcodeInfoHeadService;
import com.els.modules.barcode.vo.PurchaseBarcodeInfoHeadVO;
import com.els.modules.system.service.CodeGeneratorService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PurchaseBarcodeInfoHeadServiceImpl
extends BaseServiceImpl<PurchaseBarcodeInfoHeadMapper, PurchaseBarcodeInfoHead>
implements PurchaseBarcodeInfoHeadService {
    @Autowired
    private PurchaseBarcodeInfoHeadMapper purchaseBarcodeInfoHeadMapper;
    @Autowired
    private PurchaseBarcodeInfoItemMapper purchaseBarcodeInfoItemMapper;
    @Autowired
    private PurchaseBarcodeInfoItemService purchaseBarcodeInfoItemService;
    @Autowired
    private PurchaseBarcodeInfoDetailMapper purchaseBarcodeInfoDetailMapper;
    @Autowired
    private PurchaseBarcodeInfoDetailService purchaseBarcodeInfoDetailService;
    @Autowired
    private BarcodeSupplierListMapper barcodeSupplierListMapper;
    @Autowired
    private BarcodeSupplierListService barcodeSupplierListService;
    @Autowired
    private CodeGeneratorService codeGeneratorService;
    @Autowired
    private SaleBarcodeInfoHeadService saleBarcodeInfoHeadService;
    @Autowired
    private PurchaseBarcodePoolHeadService purchaseBarcodePoolHeadService;
    @Autowired
    private ElsBarcodeRuleHeadMapper elsBarcodeRuleHeadMapper;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseBarcodeInfoHead purchaseBarcodeInfoHead, List<PurchaseBarcodeInfoItem> purchaseBarcodeInfoItemList, List<PurchaseBarcodeInfoDetail> sysBarcodeList, List<PurchaseBarcodeInfoDetail> customBarcodeList, List<BarcodeSupplierList> barcodeSupplierListList) {
        purchaseBarcodeInfoHead.setInfoNumber(this.codeGeneratorService.getNextCode("srmBarcodeInfoNumber", (Object)purchaseBarcodeInfoHead));
        purchaseBarcodeInfoHead.setInfoStatus(PurchaseBarcodeInfoStatusEnum.NEW.getValue());
        purchaseBarcodeInfoHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        purchaseBarcodeInfoHead.setPublishAudit(StringUtils.isBlank((CharSequence)purchaseBarcodeInfoHead.getPublishAudit()) ? "0" : purchaseBarcodeInfoHead.getPublishAudit());
        this.purchaseBarcodeInfoHeadMapper.insert((Object)purchaseBarcodeInfoHead);
        this.insertData(purchaseBarcodeInfoHead, purchaseBarcodeInfoItemList, sysBarcodeList, customBarcodeList, barcodeSupplierListList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseBarcodeInfoHead purchaseBarcodeInfoHead, List<PurchaseBarcodeInfoItem> purchaseBarcodeInfoItemList, List<PurchaseBarcodeInfoDetail> sysBarcodeList, List<PurchaseBarcodeInfoDetail> customBarcodeList, List<BarcodeSupplierList> barcodeSupplierListList) {
        int count = 0;
        if (StringUtils.isBlank((CharSequence)purchaseBarcodeInfoHead.getId())) {
            purchaseBarcodeInfoHead.setInfoNumber(this.codeGeneratorService.getNextCode("srmBarcodeInfoNumber", (Object)purchaseBarcodeInfoHead));
            purchaseBarcodeInfoHead.setInfoStatus(PurchaseBarcodeInfoStatusEnum.NEW.getValue());
            purchaseBarcodeInfoHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            purchaseBarcodeInfoHead.setPublishAudit(StringUtils.isBlank((CharSequence)purchaseBarcodeInfoHead.getPublishAudit()) ? "0" : purchaseBarcodeInfoHead.getPublishAudit());
            count = this.purchaseBarcodeInfoHeadMapper.insert((Object)purchaseBarcodeInfoHead);
        } else {
            count = this.purchaseBarcodeInfoHeadMapper.updateById((Object)purchaseBarcodeInfoHead);
        }
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.purchaseBarcodeInfoItemMapper.deleteByMainId(purchaseBarcodeInfoHead.getId());
        this.purchaseBarcodeInfoDetailMapper.deleteByMainId(purchaseBarcodeInfoHead.getId());
        this.barcodeSupplierListMapper.deleteByMainId(purchaseBarcodeInfoHead.getId());
        this.insertData(purchaseBarcodeInfoHead, purchaseBarcodeInfoItemList, sysBarcodeList, customBarcodeList, barcodeSupplierListList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publish(PurchaseBarcodeInfoHead purchaseBarcodeInfoHead, List<PurchaseBarcodeInfoItem> purchaseBarcodeInfoItemList, List<PurchaseBarcodeInfoDetail> sysBarcodeList, List<PurchaseBarcodeInfoDetail> customBarcodeList, List<BarcodeSupplierList> barcodeSupplierListList) {
        int count;
        if ("0".equals(purchaseBarcodeInfoHead.getPublishAudit()) || StringUtils.isBlank((CharSequence)purchaseBarcodeInfoHead.getPublishAudit())) {
            purchaseBarcodeInfoHead.setInfoStatus(PurchaseBarcodeInfoStatusEnum.PUBLISH.getValue());
            purchaseBarcodeInfoHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            purchaseBarcodeInfoHead.setPublishAudit(StringUtils.isBlank((CharSequence)purchaseBarcodeInfoHead.getPublishAudit()) ? "0" : purchaseBarcodeInfoHead.getPublishAudit());
        }
        if ((count = this.purchaseBarcodeInfoHeadMapper.updateById((Object)purchaseBarcodeInfoHead)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.purchaseBarcodeInfoItemMapper.deleteByMainId(purchaseBarcodeInfoHead.getId());
        this.purchaseBarcodeInfoDetailMapper.deleteByMainId(purchaseBarcodeInfoHead.getId());
        this.barcodeSupplierListMapper.deleteByMainId(purchaseBarcodeInfoHead.getId());
        this.insertData(purchaseBarcodeInfoHead, purchaseBarcodeInfoItemList, sysBarcodeList, customBarcodeList, barcodeSupplierListList);
        if ("0".equals(purchaseBarcodeInfoHead.getPublishAudit())) {
            ElsBarcodeRuleHead ruleHead = (ElsBarcodeRuleHead)((Object)this.elsBarcodeRuleHeadMapper.selectById((Serializable)((Object)purchaseBarcodeInfoHead.getRuleId())));
            if (BarcodeResolveTypeEnum.BARCODE_POOL.getValue().equals(ruleHead.getResolveType())) {
                this.purchaseBarcodePoolHeadService.addByBarcodeInfo(purchaseBarcodeInfoHead, purchaseBarcodeInfoItemList, sysBarcodeList);
            }
            if (barcodeSupplierListList.size() > 0) {
                Map<String, SaleBarcodeInfoHead> supplierMap = this.saleBarcodeInfoHeadService.addByPurchase(purchaseBarcodeInfoHead, purchaseBarcodeInfoItemList, sysBarcodeList, customBarcodeList, barcodeSupplierListList, BarcodeResolveTypeEnum.BARCODE_POOL.getValue().equals(ruleHead.getResolveType()));
                Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(supplierMap);
                List toElsAccountList = barcodeSupplierListList.stream().map(BarcodeSupplierList::getToElsAccount).collect(Collectors.toList());
                String idStr = IdWorker.getIdStr();
                PurchaseBarcodeInfoHeadVO purchaseBarcodeInfoHeadVO = (PurchaseBarcodeInfoHeadVO)((Object)BeanUtil.copyProperties((Object)((Object)purchaseBarcodeInfoHead), PurchaseBarcodeInfoHeadVO.class, (String[])new String[0]));
                JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)purchaseBarcodeInfoHeadVO)));
                jsonObject.put("urlParams", receiveParamMap);
                this.redisUtil.set("sys:message:" + idStr, (Object)jsonObject, 172800L);
                super.sendMessage(TenantContext.getTenant(), "barcodeInfo", "publish", idStr, "purchaseBarcodeInfoHeadBusDataServiceImpl", toElsAccountList);
            }
        }
    }

    private Map<String, JSONObject> getReceiveParamMap(Map<String, SaleBarcodeInfoHead> supplierMap) {
        ConcurrentHashMap<String, JSONObject> receiveParamMap = new ConcurrentHashMap<String, JSONObject>();
        if (CollectionUtil.isNotEmpty(supplierMap)) {
            supplierMap.forEach((key, value) -> {
                JSONObject object = new JSONObject();
                object.put("id", (Object)value.getId());
                object.put("templateNumber", (Object)value.getTemplateNumber());
                object.put("templateVersion", (Object)value.getTemplateVersion());
                object.put("templateAccount", (Object)value.getTemplateAccount());
                receiveParamMap.put((String)key, object);
            });
        }
        return receiveParamMap;
    }

    private void insertData(PurchaseBarcodeInfoHead purchaseBarcodeInfoHead, List<PurchaseBarcodeInfoItem> purchaseBarcodeInfoItemList, List<PurchaseBarcodeInfoDetail> sysBarcodeList, List<PurchaseBarcodeInfoDetail> customBarcodeList, List<BarcodeSupplierList> barcodeSupplierListList) {
        if (purchaseBarcodeInfoItemList != null && purchaseBarcodeInfoItemList.size() > 0) {
            for (PurchaseBarcodeInfoItem purchaseBarcodeInfoItem : purchaseBarcodeInfoItemList) {
                purchaseBarcodeInfoItem.setHeadId(purchaseBarcodeInfoHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseBarcodeInfoItem, (BaseEntity)purchaseBarcodeInfoHead);
            }
            this.purchaseBarcodeInfoItemService.saveBatch(purchaseBarcodeInfoItemList);
        }
        if (sysBarcodeList != null && sysBarcodeList.size() > 0) {
            ArrayList<PurchaseBarcodeInfoDetail> resultDetailList = new ArrayList<PurchaseBarcodeInfoDetail>();
            for (PurchaseBarcodeInfoDetail entity : sysBarcodeList) {
                entity.setHeadId(purchaseBarcodeInfoHead.getId());
                entity.setBarcodeType(1);
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseBarcodeInfoHead);
            }
            resultDetailList.addAll(sysBarcodeList);
            if (customBarcodeList != null && customBarcodeList.size() > 0) {
                for (PurchaseBarcodeInfoDetail entity : customBarcodeList) {
                    entity.setHeadId(purchaseBarcodeInfoHead.getId());
                    entity.setBarcodeType(2);
                    SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseBarcodeInfoHead);
                }
                resultDetailList.addAll(customBarcodeList);
            }
            this.purchaseBarcodeInfoDetailService.saveBatch(resultDetailList);
        }
        if (barcodeSupplierListList != null && barcodeSupplierListList.size() > 0) {
            for (BarcodeSupplierList barcodeSupplierList : barcodeSupplierListList) {
                barcodeSupplierList.setHeadId(purchaseBarcodeInfoHead.getId());
                SysUtil.setSysParam((BaseEntity)barcodeSupplierList, (BaseEntity)purchaseBarcodeInfoHead);
            }
            this.barcodeSupplierListService.saveBatch(barcodeSupplierListList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        PurchaseBarcodeInfoHead head = (PurchaseBarcodeInfoHead)((Object)this.getById((Serializable)((Object)id)));
        if (AuditStatusEnum.AUDIT_DOING.getValue().equals(head.getAuditStatus()) || AuditStatusEnum.AUDIT_FINISH.getValue().equals(head.getAuditStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UzsSUzeRjtFqQG_908d607c", (String)"\u5ba1\u6279\u4e2d\u6216\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\u4e0d\u53ef\u5220\u9664"));
        }
        this.purchaseBarcodeInfoItemMapper.deleteByMainId(id);
        this.purchaseBarcodeInfoHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseBarcodeInfoItemMapper.deleteByMainId(serializable.toString());
            this.purchaseBarcodeInfoHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public void copyData(String id) {
        PurchaseBarcodeInfoHead purchaseBarcodeInfoHead = (PurchaseBarcodeInfoHead)((Object)this.getById((Serializable)((Object)id)));
        LoginUser user = SysUtil.getLoginUser();
        purchaseBarcodeInfoHead.setId(null);
        purchaseBarcodeInfoHead.setCreateById(user.getId());
        purchaseBarcodeInfoHead.setCreateBy(user.getSubAccount());
        purchaseBarcodeInfoHead.setCreateTime(new Date());
        purchaseBarcodeInfoHead.setUpdateTime(new Date());
        purchaseBarcodeInfoHead.setUpdateBy(user.getSubAccount());
        purchaseBarcodeInfoHead.setUpdateById(user.getId());
        List<PurchaseBarcodeInfoItem> purchaseBarcodeInfoItemList = this.purchaseBarcodeInfoItemService.selectByMainId(id);
        purchaseBarcodeInfoItemList.forEach(x -> {
            x.setId(null);
            x.setCreateBy(user.getSubAccount());
            x.setCreateTime(new Date());
            x.setCreateById(user.getId());
            x.setUpdateTime(new Date());
            x.setUpdateBy(user.getSubAccount());
            x.setUpdateById(user.getId());
        });
        List<PurchaseBarcodeInfoDetail> purchaseBarcodeInfoDetailList = this.purchaseBarcodeInfoDetailService.selectByMainId(id);
        purchaseBarcodeInfoDetailList.forEach(x -> {
            x.setId(null);
            x.setCreateBy(user.getSubAccount());
            x.setCreateTime(new Date());
            x.setCreateById(user.getId());
            x.setUpdateTime(new Date());
            x.setUpdateBy(user.getSubAccount());
            x.setUpdateById(user.getId());
        });
        List<PurchaseBarcodeInfoDetail> sysBarcodeList = purchaseBarcodeInfoDetailList.stream().filter(detail -> detail.getBarcodeType() == 1).collect(Collectors.toList());
        List<PurchaseBarcodeInfoDetail> customBarcodeList = purchaseBarcodeInfoDetailList.stream().filter(detail -> detail.getBarcodeType() == 2).collect(Collectors.toList());
        List<BarcodeSupplierList> barcodeSupplierListList = this.barcodeSupplierListService.selectByMainId(id);
        barcodeSupplierListList.forEach(x -> {
            x.setId(null);
            x.setCreateBy(user.getSubAccount());
            x.setCreateById(user.getId());
            x.setCreateTime(new Date());
            x.setUpdateTime(new Date());
            x.setUpdateBy(user.getSubAccount());
            x.setUpdateById(user.getId());
        });
        this.saveMain(purchaseBarcodeInfoHead, purchaseBarcodeInfoItemList, sysBarcodeList, customBarcodeList, barcodeSupplierListList);
    }

    @Override
    public JSONObject getDataById(String id) {
        PurchaseBarcodeInfoHead purchaseBarcodeInfoHead = (PurchaseBarcodeInfoHead)((Object)this.getById((Serializable)((Object)id)));
        PurchaseBarcodeInfoHeadVO purchaseBarcodeInfoHeadVO = (PurchaseBarcodeInfoHeadVO)((Object)BeanUtil.copyProperties((Object)((Object)purchaseBarcodeInfoHead), PurchaseBarcodeInfoHeadVO.class, (String[])new String[0]));
        Result result = Result.ok((Object)((Object)purchaseBarcodeInfoHeadVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }
}

