/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.system.entity.DataPermissionFieldConfig;
import com.els.modules.system.entity.DataPermissionFieldConfigItem;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.mapper.DataPermissionFieldConfigMapper;
import com.els.modules.system.service.DataPermissionFieldConfigItemService;
import com.els.modules.system.service.DataPermissionFieldConfigService;
import com.els.modules.system.service.DictItemService;
import com.els.modules.system.service.DictService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class DataPermissionFieldConfigServiceImpl
extends BaseServiceImpl<DataPermissionFieldConfigMapper, DataPermissionFieldConfig>
implements DataPermissionFieldConfigService {
    @Resource
    private DataPermissionFieldConfigItemService dataPermissionFieldConfigItemService;
    @Resource
    private DictService dictService;
    @Resource
    private DictItemService dictItemService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(DataPermissionFieldConfig dataPermissionFieldConfig, List<DataPermissionFieldConfigItem> dataPermissionFieldConfigItemList) {
        if (StrUtil.isBlank((CharSequence)dataPermissionFieldConfig.getBusinessCode())) {
            throw new ELSBootException("\u4e1a\u52a1\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int checkCount = (int)this.count((Wrapper)new QueryWrapper().eq((Object)"business_code", (Object)dataPermissionFieldConfig.getBusinessCode()));
        if (checkCount > 0) {
            throw new ELSBootException("\u4e1a\u52a1\u7c7b\u578b\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff01");
        }
        ((DataPermissionFieldConfigMapper)this.baseMapper).insert((Object)dataPermissionFieldConfig);
        super.setHeadDefaultValue((BaseEntity)dataPermissionFieldConfig);
        this.insertData(dataPermissionFieldConfig, dataPermissionFieldConfigItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(DataPermissionFieldConfig dataPermissionFieldConfig, List<DataPermissionFieldConfigItem> dataPermissionFieldConfigItemList) {
        int count = ((DataPermissionFieldConfigMapper)this.baseMapper).updateById((Object)dataPermissionFieldConfig);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.dataPermissionFieldConfigItemService.deleteByMainId(dataPermissionFieldConfig.getId());
        this.insertData(dataPermissionFieldConfig, dataPermissionFieldConfigItemList);
    }

    private void insertData(DataPermissionFieldConfig dataPermissionFieldConfig, List<DataPermissionFieldConfigItem> dataPermissionFieldConfigItemList) {
        if (!CollectionUtils.isEmpty(dataPermissionFieldConfigItemList)) {
            for (DataPermissionFieldConfigItem entity : dataPermissionFieldConfigItemList) {
                entity.setHeadId(dataPermissionFieldConfig.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)dataPermissionFieldConfig);
            }
            this.dataPermissionFieldConfigItemService.saveBatch(dataPermissionFieldConfigItemList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.dataPermissionFieldConfigItemService.deleteByMainId(id);
        ((DataPermissionFieldConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void refreshPermissionDict() {
        Dict dict = (Dict)this.dictService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)"100000")).eq((Object)"dict_code", (Object)"permissionScope"));
        if (dict == null) {
            throw new ELSBootException("\u5e73\u53f0\u7ea7\u5b57\u5178 permissionScope\uff08\u6743\u9650\u63a7\u5236\u8303\u56f4\uff09\u4e0d\u5b58\u5728\uff01");
        }
        this.dictItemService.deleteByMainId(dict.getId());
        List configList = this.list();
        ArrayList<DictItem> dictItemList = new ArrayList<DictItem>();
        int index = 1;
        for (DataPermissionFieldConfig config : configList) {
            DictItem item = new DictItem();
            item.setDictId(dict.getId());
            item.setElsAccount("100000");
            item.setItemText(config.getBusinessName());
            item.setItemValue(config.getBusinessCode());
            item.setItemTextI18nKey(config.getBusinessNameI18nk());
            item.setSortOrder(index);
            item.setStatus(1);
            dictItemList.add(item);
            ++index;
        }
        if (!dictItemList.isEmpty()) {
            this.dictItemService.saveBatch(dictItemList);
        }
    }
}

