/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.archiver.service.impl;

import cn.hutool.core.date.DateUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.archiver.entity.ArchiverConfigHead;
import com.els.modules.archiver.entity.ArchiverConfigItem;
import com.els.modules.archiver.entity.ArchiverLog;
import com.els.modules.archiver.mapper.ArchiverConfigHeadMapper;
import com.els.modules.archiver.mapper.ArchiverLogMapper;
import com.els.modules.archiver.service.ArchiverConfigHeadService;
import com.els.modules.archiver.service.ArchiverConfigItemService;
import com.els.modules.archiver.vo.ArchiverConfigHeadVO;
import com.els.modules.template.util.FreeMarkerTemplateUtils;
import freemarker.template.Template;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ArchiverConfigHeadServiceImpl
extends BaseServiceImpl<ArchiverConfigHeadMapper, ArchiverConfigHead>
implements ArchiverConfigHeadService {
    @Autowired
    private ArchiverConfigItemService archiverConfigItemService;
    @Resource
    private ArchiverLogMapper archiverLogMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(ArchiverConfigHead archiverConfigHead, List<ArchiverConfigItem> archiverConfigItemList) {
        ((ArchiverConfigHeadMapper)this.baseMapper).insert((Object)archiverConfigHead);
        super.setHeadDefaultValue((BaseEntity)archiverConfigHead);
        this.insertData(archiverConfigHead, archiverConfigItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(ArchiverConfigHead archiverConfigHead, List<ArchiverConfigItem> archiverConfigItemList) {
        int count = ((ArchiverConfigHeadMapper)this.baseMapper).updateById((Object)archiverConfigHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.archiverConfigItemService.deleteByMainId(archiverConfigHead.getId());
        this.insertData(archiverConfigHead, archiverConfigItemList);
    }

    private void insertData(ArchiverConfigHead archiverConfigHead, List<ArchiverConfigItem> archiverConfigItemList) {
        if (!CollectionUtils.isEmpty(archiverConfigItemList)) {
            int index = 1;
            for (ArchiverConfigItem entity : archiverConfigItemList) {
                entity.setId(null);
                entity.setItemNumber(index++);
                entity.setHeadId(archiverConfigHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)archiverConfigHead);
            }
            this.archiverConfigItemService.saveBatch(archiverConfigItemList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.archiverConfigItemService.deleteByMainId(id);
        ((ArchiverConfigHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.archiverConfigItemService.deleteByMainId(serializable.toString());
            ((ArchiverConfigHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveConfig(ArchiverConfigHeadVO archiverConfigHeadPage) {
        this.generateScript(archiverConfigHeadPage);
        ArchiverConfigHead archiverConfigHead = new ArchiverConfigHead();
        BeanUtils.copyProperties((Object)((Object)archiverConfigHeadPage), (Object)((Object)archiverConfigHead));
        if (StringUtils.isBlank((CharSequence)archiverConfigHeadPage.getId())) {
            this.saveMain(archiverConfigHead, archiverConfigHeadPage.getArchiverConfigItemList());
        } else {
            this.updateMain(archiverConfigHead, archiverConfigHeadPage.getArchiverConfigItemList());
        }
        archiverConfigHeadPage.setId(archiverConfigHead.getId());
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void generateScript(ArchiverConfigHeadVO archiverConfigHeadPage) {
        try {
            List<ArchiverConfigItem> itemList = archiverConfigHeadPage.getArchiverConfigItemList();
            Assert.isTrue((!CollectionUtils.isEmpty(itemList) ? 1 : 0) != 0, (String)"\u5f52\u6863\u884c\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            StringWriter sw = new StringWriter();
            Template tpl = FreeMarkerTemplateUtils.getTemplate("archiver_script.ftl");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("head", (Object)archiverConfigHeadPage);
            map.put("itemList", itemList);
            archiverConfigHeadPage.setArchiverDate(DateUtil.format((Date)DateUtils.addMonths((Date)new Date(), (int)(-Integer.parseInt(archiverConfigHeadPage.getArchiverMonths()))), (String)"yyyy-MM-dd"));
            for (ArchiverConfigItem item : itemList) {
                if (item.getArchiverMonths() == null) {
                    item.setArchiverDate(archiverConfigHeadPage.getArchiverDate());
                    continue;
                }
                item.setArchiverDate(DateUtil.format((Date)DateUtils.addMonths((Date)new Date(), (int)(-Integer.parseInt(item.getArchiverMonths()))), (String)"yyyy-MM-dd"));
            }
            tpl.process(map, (Writer)sw);
            archiverConfigHeadPage.setScriptContent(sw.toString());
        }
        catch (Exception e) {
            throw new ELSBootException((Throwable)e);
        }
    }

    @Override
    public void executeScript(ArchiverConfigHeadVO archiverConfigHeadPage) {
        ArchiverConfigHead head = (ArchiverConfigHead)((Object)((ArchiverConfigHeadMapper)this.baseMapper).selectById((Serializable)((Object)archiverConfigHeadPage.getId())));
        if (head == null) {
            throw new ELSBootException("\u8bf7\u5148\u4fdd\u5b58\u914d\u7f6e\uff01");
        }
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)head.getScriptContent()), (String)"\u5f52\u6863\u811a\u672c\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u4fdd\u5b58\u751f\u6210\uff01");
        ArchiverLog archiverLog = new ArchiverLog();
        archiverLog.setHeadId(head.getId());
        archiverLog.setElsAccount(head.getElsAccount());
        archiverLog.setScriptContent(head.getScriptContent());
        archiverLog.setCreateBy(this.getLoginSubAndName());
        archiverLog.setCreateTime(new Date());
        this.archiverLogMapper.insert((Object)archiverLog);
        String scriptFile = System.getProperty("user.dir") + "/archiver_script.sh";
        String command = "sh " + scriptFile;
        this.log.warn("scriptFile:" + scriptFile);
        this.writeScript(scriptFile, head.getScriptContent());
        String log = this.exeCmd(command);
        head.setExecuteResult(log);
        archiverConfigHeadPage.setExecuteResult(log);
        this.updateById((Object)head);
        archiverLog.setExecuteResult(log);
        archiverLog.setUpdateBy(this.getLoginSubAndName());
        archiverLog.setUpdateTime(new Date());
        this.archiverLogMapper.updateById((Object)archiverLog);
    }

    public void writeScript(String scriptFile, String scriptContent) {
        OutputStreamWriter fileWriter = null;
        try {
            File file = new File(scriptFile);
            if (file.exists()) {
                file.delete();
            }
            fileWriter = new FileWriter(file);
            fileWriter.write(scriptContent);
        }
        catch (IOException e) {
            throw new ELSBootException((Throwable)e);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String exeCmd(String commandStr) {
        String result = null;
        try {
            String line;
            String[] cmd = new String[]{"/bin/sh", "-c", commandStr};
            Process ps = Runtime.getRuntime().exec(cmd);
            BufferedReader br = new BufferedReader(new InputStreamReader(ps.getInputStream()));
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                this.log.warn(line);
                sb.append(line).append("\n");
            }
            ps.waitFor();
            br.close();
            ps.destroy();
            result = sb.toString();
        }
        catch (Exception e) {
            result = e.getMessage();
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.format((Date)DateUtils.addMonths((Date)new Date(), (int)-6), (String)"yyyy-MM-dd"));
    }
}

