/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.integrated.listener;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.integrated.entity.IntegratedBusinessData;
import com.els.modules.integrated.entity.IntegratedBusinessDataLinks;
import com.els.modules.integrated.service.IntegratedBusinessDataLinksService;
import com.els.modules.integrated.service.IntegratedBusinessDataService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;

@Component
public class IntegratedDataConsumer {
    private static final Logger log = LoggerFactory.getLogger(IntegratedDataConsumer.class);
    @Autowired
    private IntegratedBusinessDataService integratedBusinessDataService;
    @Autowired
    private IntegratedBusinessDataLinksService integratedBusinessDataLinksService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Bean(value={"inputIntegratedData"})
    public Consumer<Message<String>> receive() {
        return message -> {
            String key = (String)message.getHeaders().get((Object)"ROCKET_KEYS");
            String msgBody = (String)message.getPayload();
            String msgStatus = this.invokeBaseRpcService.getMsgStatusById(key);
            if ("1".equals(msgStatus)) {
                log.error("\u6d88\u606fID\uff1a" + key + " \u5df2\u7ecf\u6d88\u8d39\uff0c\u4e0d\u80fd\u91cd\u590d\u6d88\u8d39\uff01");
                return;
            }
            String errorInfo = "";
            if (StringUtils.isBlank((CharSequence)msgBody)) {
                return;
            }
            JSONObject body = JSONObject.parseObject((String)msgBody);
            log.info("\u63a5\u6536\u6d88\u606f,\u6d88\u606f\u5185\u5bb9:" + body.toJSONString());
            try {
                if (body.containsKey((Object)"dataType") && "integrateData".equals(body.getString("dataType")) && body.containsKey((Object)"data")) {
                    JSONObject integrateData = body.getJSONObject("data");
                    IntegratedBusinessData integratedBusinessData = (IntegratedBusinessData)((Object)((Object)JSONObject.parseObject((String)body.getString("data"), IntegratedBusinessData.class)));
                    integratedBusinessData.setDataJson(integrateData.getJSONObject("jsonData").toJSONString());
                    this.integratedBusinessDataService.updateIntegratedData(integratedBusinessData);
                }
                if (body.containsKey((Object)"dataType") && "integrateDataLink".equals(body.getString("dataType"))) {
                    if (body.containsKey((Object)"delItemStringList")) {
                        List delItemStringList = JSONArray.parseArray((String)body.getString("delItemStringList"), String.class);
                        this.integratedBusinessDataLinksService.deleteByBusinessIdList(delItemStringList, "item");
                    }
                    if (body.containsKey((Object)"delHeadStringList")) {
                        List delHeadStringList = JSONArray.parseArray((String)body.getString("delHeadStringList"), String.class);
                        this.integratedBusinessDataLinksService.deleteByBusinessIdList(delHeadStringList, "head");
                    }
                    if (body.containsKey((Object)"jsonArray")) {
                        JSONArray jsonArray = body.getJSONArray("jsonArray");
                        List integratedBusinessDataLinks = jsonArray.toJavaList(IntegratedBusinessDataLinks.class);
                        for (IntegratedBusinessDataLinks link : integratedBusinessDataLinks) {
                            this.integratedBusinessDataLinksService.saveIntegratedBusinessDataLinks(link.getElsAccount(), link.getBusinessType(), link.getBusinessDataType(), link.getIntegratedId(), link.getIntegratedHeadId(), link.getBusinessParentId(), link.getBusinessId(), link.getBusinessHeadId(), link.getDocNo(), link.getDataJson());
                        }
                    }
                }
                msgStatus = "1";
            }
            catch (Exception e) {
                log.error("save log failed:", (Throwable)e);
                msgStatus = "2";
                errorInfo = e.getMessage();
            }
            finally {
                this.invokeBaseRpcService.updateRecord(key, msgStatus, errorInfo);
            }
        };
    }
}

