/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.integrated.service.impl;

import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.integrated.entity.IntegratedBusinessDataLinks;
import com.els.modules.integrated.mapper.IntegratedBusinessDataLinksMapper;
import com.els.modules.integrated.service.IntegratedBusinessDataLinksService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class IntegratedBusinessDataLinksServiceImpl
extends BaseServiceImpl<IntegratedBusinessDataLinksMapper, IntegratedBusinessDataLinks>
implements IntegratedBusinessDataLinksService {
    @Resource
    private IntegratedBusinessDataLinksMapper integratedBusinessDataLinksMapper;

    @Override
    public void add(IntegratedBusinessDataLinks integratedBusinessDataLinks) {
        ((IntegratedBusinessDataLinksMapper)this.baseMapper).insert((Object)integratedBusinessDataLinks);
    }

    @Override
    public void edit(IntegratedBusinessDataLinks integratedBusinessDataLinks) {
        int count = ((IntegratedBusinessDataLinksMapper)this.baseMapper).updateById((Object)integratedBusinessDataLinks);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((IntegratedBusinessDataLinksMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((IntegratedBusinessDataLinksMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void deleteByBusinessId(String id) {
        this.integratedBusinessDataLinksMapper.deleteByBusinessId(id);
    }

    @Override
    public void deleteByBusinessIdList(List<String> id) {
        this.integratedBusinessDataLinksMapper.deleteByBusinessIdList(id);
    }

    @Override
    public void deleteByBusinessIdList(List<String> id, String type) {
        ArrayList arrayList = new ArrayList();
        id.forEach(i -> {
            List list = Arrays.stream(i.split(",")).collect(Collectors.toList());
            arrayList.addAll(list);
        });
        if (!CollectionUtils.isEmpty(arrayList)) {
            this.integratedBusinessDataLinksMapper.deleteByBusinessIdTypeList(id, type);
        }
    }

    @Override
    public void saveIntegratedBusinessDataLinks(String elsAccount, String module, String type, String integratedId, String integratedHeadId, String businessParentId, String childId, String businessHeadId, String docNo, String dataJson) {
        ArrayList<IntegratedBusinessDataLinks> dataLinks = new ArrayList<IntegratedBusinessDataLinks>();
        if (StringUtils.isNotBlank((CharSequence)businessParentId)) {
            List integratedIdArr = Arrays.stream(integratedId.split(",")).collect(Collectors.toList());
            List integratedHeadIdArr = Arrays.stream(integratedHeadId.split(",")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(integratedIdArr)) {
                for (int i = 0; i < integratedIdArr.size(); ++i) {
                    String integratedIdOne = (String)integratedIdArr.get(i);
                    String integratedHeadIdOne = null;
                    integratedHeadIdOne = i < integratedHeadIdArr.size() ? (String)integratedHeadIdArr.get(i) : (String)integratedHeadIdArr.get(0);
                    IntegratedBusinessDataLinks integratedBusinessDataLinks = new IntegratedBusinessDataLinks();
                    integratedBusinessDataLinks.setBusinessId(childId);
                    integratedBusinessDataLinks.setIntegratedId(integratedIdOne);
                    integratedBusinessDataLinks.setIntegratedHeadId(integratedHeadIdOne);
                    integratedBusinessDataLinks.setBusinessType(module);
                    integratedBusinessDataLinks.setBusinessParentId(businessParentId);
                    integratedBusinessDataLinks.setBusinessDataType(type);
                    integratedBusinessDataLinks.setElsAccount(elsAccount);
                    integratedBusinessDataLinks.setBusinessHeadId(businessHeadId);
                    integratedBusinessDataLinks.setDocNo(docNo);
                    integratedBusinessDataLinks.setDataJson(dataJson);
                    dataLinks.add(integratedBusinessDataLinks);
                }
            }
            this.saveBatch(dataLinks);
        } else {
            IntegratedBusinessDataLinks integratedBusinessDataLinks = new IntegratedBusinessDataLinks();
            integratedBusinessDataLinks.setBusinessId(childId);
            integratedBusinessDataLinks.setIntegratedId(integratedId);
            integratedBusinessDataLinks.setIntegratedHeadId(integratedHeadId);
            integratedBusinessDataLinks.setBusinessType(module);
            integratedBusinessDataLinks.setBusinessParentId(businessParentId);
            integratedBusinessDataLinks.setBusinessDataType(type);
            integratedBusinessDataLinks.setElsAccount(elsAccount);
            integratedBusinessDataLinks.setBusinessHeadId(businessHeadId);
            integratedBusinessDataLinks.setDocNo(docNo);
            integratedBusinessDataLinks.setDataJson(dataJson);
            this.save((Object)integratedBusinessDataLinks);
        }
    }
}

